/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.google.common.collect.Maps;
import java.util.Map;

public enum Type {
    OBJECT(2, 0),
    BOOLEAN(4, 1),
    CHAR(5, 2),
    FLOAT(6, 4),
    DOUBLE(7, 8),
    BYTE(8, 1),
    SHORT(9, 2),
    INT(10, 4),
    LONG(11, 8);

    private static int sIdSize;
    private static Map<Integer, Type> sTypeMap;
    private int mId;
    private int mSize;

    private Type(int type, int size) {
        this.mId = type;
        this.mSize = size;
    }

    public static final void setIdSize(int size) {
        sIdSize = size;
    }

    public static Type getType(int id) {
        return sTypeMap.get(id);
    }

    public int getSize() {
        return this == OBJECT ? sIdSize : this.mSize;
    }

    static {
        sIdSize = 4;
        sTypeMap = Maps.newHashMap();
        for (Type type : Type.values()) {
            sTypeMap.put(type.mId, type);
        }
    }
}

