/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.annotations.Nullable;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootType;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Visitor;

public class RootObj
extends Instance {
    RootType mType = RootType.UNKNOWN;
    int mIndex;
    int mThread;
    long mParent;
    String mComment;

    public RootObj(RootType type) {
        this(type, 0L, 0, null);
    }

    public RootObj(RootType type, long id) {
        this(type, id, 0, null);
    }

    public RootObj(RootType type, long id, int thread, StackTrace stack) {
        this.mType = type;
        this.mId = id;
        this.mThread = thread;
        this.mStack = stack;
    }

    public final String getClassName(Snapshot snapshot) {
        ClassObj theClass = this.mType == RootType.SYSTEM_CLASS ? snapshot.findClass(this.mId) : snapshot.findReference(this.mId).getClassObj();
        if (theClass == null) {
            return "no class defined!!";
        }
        return theClass.mClassName;
    }

    @Override
    public final int getSize() {
        Instance instance = this.getReferredInstance();
        return instance != null ? instance.getSize() : 0;
    }

    @Override
    public final void accept(Visitor visitor) {
        Instance instance = this.getReferredInstance();
        if (instance != null) {
            instance.accept(visitor);
        }
    }

    public final String toString() {
        return String.format("%s@0x08x", this.mType.getName(), this.mId);
    }

    @Nullable
    public Instance getReferredInstance() {
        if (this.mType == RootType.SYSTEM_CLASS) {
            return this.mHeap.mSnapshot.findClass(this.mId);
        }
        return this.mHeap.mSnapshot.findReference(this.mId);
    }
}

