/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Visitor;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public abstract class Instance {
    long mId;
    ClassObj mClass;
    StackTrace mStack;
    Heap mHeap;
    int mSize;
    private final Map<Heap, Long> mRetainedSizes = Maps.newHashMap();
    private final ArrayList<Instance> mReferences = new ArrayList();

    public abstract void accept(Visitor var1);

    public ClassObj getClassObj() {
        return this.mClass;
    }

    public void setClass(ClassObj aClass) {
        assert (this.mClass == null);
        this.mClass = aClass;
        aClass.addInstance(this);
    }

    public final int getCompositeSize() {
        CollectingVisitor visitor = new CollectingVisitor();
        this.accept(visitor);
        int size = 0;
        for (Instance instance : visitor.getVisited()) {
            size += instance.getSize();
        }
        return size;
    }

    public int getSize() {
        return this.mSize;
    }

    public void setSize(int size) {
        this.mSize = size;
    }

    public void setHeap(Heap heap) {
        this.mHeap = heap;
    }

    public void setRetainedSize(Heap heap, long size) {
        this.mRetainedSizes.put(heap, size);
    }

    public long getRetainedSize(Heap heap) {
        Long result = this.mRetainedSizes.get(heap);
        return result == null ? 0L : result;
    }

    public void addReference(Instance reference) {
        this.mReferences.add(reference);
    }

    public ArrayList<Instance> getReferences() {
        return this.mReferences;
    }

    public static class CollectingVisitor
    implements Visitor {
        private final Set<Instance> mVisited = Sets.newHashSet();

        @Override
        public boolean visitEnter(Instance instance) {
            return this.mVisited.add(instance);
        }

        @Override
        public void visitLeave(Instance instance) {
        }

        public Set<Instance> getVisited() {
            return this.mVisited;
        }
    }
}

