/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.annotations.NonNull;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.StackFrame;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.ThreadObj;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Heap {
    String mName;
    HashMap<Long, StackFrame> mFrames = new HashMap();
    HashMap<Integer, StackTrace> mTraces = new HashMap();
    ArrayList<RootObj> mRoots = new ArrayList();
    HashMap<Integer, ThreadObj> mThreads = new HashMap();
    HashMap<Long, ClassObj> mClassesById = new HashMap();
    HashMap<String, ClassObj> mClassesByName = new HashMap();
    private final Map<Long, Instance> mInstances = Maps.newHashMap();
    Snapshot mSnapshot;

    public Heap(String name) {
        this.mName = name;
    }

    public final void addStackFrame(StackFrame theFrame) {
        this.mFrames.put(theFrame.mId, theFrame);
    }

    public final StackFrame getStackFrame(long id) {
        return this.mFrames.get(id);
    }

    public final void addStackTrace(StackTrace theTrace) {
        this.mTraces.put(theTrace.mSerialNumber, theTrace);
    }

    public final StackTrace getStackTrace(int traceSerialNumber) {
        return this.mTraces.get(traceSerialNumber);
    }

    public final StackTrace getStackTraceAtDepth(int traceSerialNumber, int depth) {
        StackTrace trace = this.mTraces.get(traceSerialNumber);
        if (trace != null) {
            trace = trace.fromDepth(depth);
        }
        return trace;
    }

    public final void addRoot(RootObj root) {
        root.mIndex = this.mRoots.size();
        this.mRoots.add(root);
    }

    public final void addThread(ThreadObj thread, int serialNumber) {
        this.mThreads.put(serialNumber, thread);
    }

    public final ThreadObj getThread(int serialNumber) {
        return this.mThreads.get(serialNumber);
    }

    public final void addInstance(long id, Instance instance) {
        this.mInstances.put(id, instance);
    }

    public final Instance getInstance(long id) {
        return this.mInstances.get(id);
    }

    public final void addClass(long id, ClassObj theClass) {
        this.mClassesById.put(id, theClass);
        this.mClassesByName.put(theClass.mClassName, theClass);
    }

    public final ClassObj getClass(long id) {
        return this.mClassesById.get(id);
    }

    public final ClassObj getClass(String name) {
        return this.mClassesByName.get(name);
    }

    public final void dumpInstanceCounts() {
        for (ClassObj theClass : this.mClassesById.values()) {
            int count = theClass.mInstances.size();
            if (count <= 0) continue;
            System.out.println(theClass + ": " + count);
        }
    }

    public final void dumpSubclasses() {
        for (ClassObj theClass : this.mClassesById.values()) {
            int count = theClass.mSubclasses.size();
            if (count <= 0) continue;
            System.out.println(theClass);
            theClass.dumpSubclasses();
        }
    }

    public final void dumpSizes() {
        for (ClassObj theClass : this.mClassesById.values()) {
            int size = 0;
            for (Instance instance : theClass.mInstances) {
                size += instance.getCompositeSize();
            }
            if (size <= 0) continue;
            System.out.println(theClass + ": base " + theClass.getSize() + ", composite " + size);
        }
    }

    public Collection<ClassObj> getClasses() {
        return this.mClassesByName.values();
    }

    @NonNull
    public Collection<Instance> getInstances() {
        return this.mInstances.values();
    }
}

