/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.Value;
import com.android.tools.perflib.heap.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClassObj
extends Instance
implements Comparable<ClassObj> {
    String mClassName;
    ClassObj mSuperClass;
    Field[] mFields;
    private int mInstanceSize;
    Map<Field, Value> mStaticFields = new HashMap<Field, Value>();
    ArrayList<Instance> mInstances = new ArrayList();
    Set<ClassObj> mSubclasses = new HashSet<ClassObj>();

    public ClassObj(long id, StackTrace stack, String className) {
        this.mId = id;
        this.mStack = stack;
        this.mClassName = className;
    }

    public final void addSubclass(ClassObj subclass) {
        this.mSubclasses.add(subclass);
    }

    public final Set<ClassObj> getSubclasses() {
        return this.mSubclasses;
    }

    public final void dumpSubclasses() {
        for (ClassObj subclass : this.mSubclasses) {
            System.out.println("     " + subclass.mClassName);
        }
    }

    public final String toString() {
        return this.mClassName.replace('/', '.');
    }

    public final void addInstance(Instance instance) {
        this.mInstances.add(instance);
    }

    public final void setSuperClass(ClassObj superClass) {
        this.mSuperClass = superClass;
        superClass.addSubclass(this);
    }

    public Field[] getFields() {
        return this.mFields;
    }

    public void setFields(Field[] fields) {
        this.mFields = fields;
    }

    public void setInstanceSize(int size) {
        this.mInstanceSize = size;
    }

    public int getInstanceSize() {
        return this.mInstanceSize;
    }

    public final void dump() {
        System.out.println("+----------  ClassObj dump for: " + this.mClassName);
        System.out.println("+-----  Static fields");
        for (Field field : this.mStaticFields.keySet()) {
            System.out.println(field.getName() + ": " + (Object)((Object)field.getType()) + " = " + this.mStaticFields.get(field));
        }
        System.out.println("+-----  Instance fields");
        for (Field field : this.mFields) {
            System.out.println(field.getName() + ": " + (Object)((Object)field.getType()));
        }
        if (this.mSuperClass != null) {
            this.mSuperClass.dump();
        }
    }

    public final String getClassName() {
        return this.mClassName;
    }

    @Override
    public final void accept(Visitor visitor) {
        if (visitor.visitEnter(this)) {
            for (Value value : this.mStaticFields.values()) {
                if (!(value.getValue() instanceof Instance)) continue;
                ((Instance)value.getValue()).accept(visitor);
            }
            visitor.visitLeave(this);
        }
    }

    @Override
    public final int compareTo(ClassObj o) {
        return this.mClassName.compareTo(o.mClassName);
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ClassObj)) {
            return false;
        }
        return 0 == this.compareTo((ClassObj)o);
    }

    public void addStaticField(Type type, String name, Value value) {
        this.mStaticFields.put(new Field(type, name), value);
    }

    public Value getStaticField(Type type, String name) {
        return this.mStaticFields.get(new Field(type, name));
    }

    public ClassObj getSuperClassObj() {
        return this.mSuperClass;
    }

    public Collection<Instance> getInstances() {
        return this.mInstances;
    }
}

