/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.Value;
import com.android.tools.perflib.heap.Visitor;
import com.google.common.collect.Maps;
import java.util.Map;

public class ClassInstance
extends Instance {
    private Map<Field, Value> mValues = Maps.newHashMap();

    public ClassInstance(long id, StackTrace stack) {
        this.mId = id;
        this.mStack = stack;
    }

    public void addField(Field field, Value value) {
        this.mValues.put(field, value);
    }

    public Value getField(Type type, String name) {
        return this.mValues.get(new Field(type, name));
    }

    @Override
    public final int getSize() {
        return this.mClass.getInstanceSize();
    }

    @Override
    public final void accept(Visitor visitor) {
        if (visitor.visitEnter(this)) {
            for (Value value : this.mValues.values()) {
                if (!(value.getValue() instanceof Instance)) continue;
                ((Instance)value.getValue()).accept(visitor);
            }
            visitor.visitLeave(this);
        }
    }

    public final String toString() {
        return String.format("%s@0x%08x", this.getClassObj().getClassName(), this.mId);
    }
}

