/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import org.w3c.dom.Element;

public class WrongCaseDetector
extends LayoutDetector {
    public static final Issue WRONG_CASE = Issue.create("WrongCase", "Wrong case for view tag", "Ensures that the correct case is used for special layout tags such as <fragment>", "Most layout tags, such as <Button>, refer to actual view classes and are therefore capitalized. However, there are exceptions such as <fragment> and <include>. This lint check looks for incorrect capitalizations.", Category.CORRECTNESS, 4, Severity.FATAL, new Implementation(WrongCaseDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/components/fragments.html");

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("Fragment", "RequestFocus", "Include", "Merge");
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        String tag = element.getTagName();
        String correct = Character.toLowerCase(tag.charAt(0)) + tag.substring(1);
        context.report(WRONG_CASE, element, context.getLocation(element), String.format("Invalid tag <%1$s>; should be <%2$s>", tag, correct), null);
    }

    @Nullable
    public static String getOldValue(@NonNull String errorMessage) {
        return LintUtils.findSubstring(errorMessage, " tag <", ">");
    }

    @Nullable
    public static String getNewValue(@NonNull String errorMessage) {
        return LintUtils.findSubstring(errorMessage, " should be <", ">");
    }
}

