/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import java.util.Collections;
import java.util.List;
import lombok.ast.Assert;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Case;
import lombok.ast.ClassDeclaration;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.DoWhile;
import lombok.ast.Expression;
import lombok.ast.ExpressionStatement;
import lombok.ast.For;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.If;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.Return;
import lombok.ast.Statement;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableReference;
import lombok.ast.While;

public class SharedPrefsDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create("CommitPrefEdits", "Missing `commit()` on `SharedPreference` editor", "Looks for code editing a `SharedPreference` but forgetting to call `commit()` on it", "After calling `edit()` on a `SharedPreference`, you must call `commit()` or `apply()` on the editor to save the results.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(SharedPrefsDetector.class, Scope.JAVA_FILE_SCOPE));
    public static final String ANDROID_CONTENT_SHARED_PREFERENCES = "android.content.SharedPreferences";
    private static final String ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR = "android.content.SharedPreferences.Editor";

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("edit");
    }

    @Nullable
    private static NormalTypeBody findSurroundingTypeBody(Node scope) {
        while (scope != null) {
            Class<?> type = scope.getClass();
            if (type == NormalTypeBody.class) {
                return (NormalTypeBody)scope;
            }
            scope = scope.getParent();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation node) {
        boolean allowCommitBeforeTarget;
        Expression operand;
        assert (node.astName().astValue().equals("edit"));
        boolean verifiedType = false;
        JavaParser.ResolvedNode resolve = context.resolve((Node)node);
        if (resolve instanceof JavaParser.ResolvedMethod) {
            JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolve;
            JavaParser.TypeDescriptor returnType = method.getReturnType();
            if (returnType == null || !returnType.matchesName(ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR)) {
                return;
            }
            verifiedType = true;
        }
        if ((operand = node.astOperand()) == null) {
            return;
        }
        Node parent = node.getParent();
        VariableDefinition definition = SharedPrefsDetector.getLhs(parent);
        if (definition == null) {
            if (!(operand instanceof VariableReference)) return;
            if (!verifiedType) {
                NormalTypeBody body = SharedPrefsDetector.findSurroundingTypeBody(parent);
                if (body == null) {
                    return;
                }
                String variableName = ((VariableReference)operand).astIdentifier().astValue();
                String type = SharedPrefsDetector.getFieldType(body, variableName);
                if (type == null || !type.equals("SharedPreferences")) {
                    return;
                }
            }
            allowCommitBeforeTarget = true;
        } else {
            String type;
            if (!(verifiedType || (type = definition.astTypeReference().toString()).endsWith("SharedPreferences.Editor") || type.equals("Editor") && LintUtils.isImported(context.getCompilationUnit(), ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR))) {
                return;
            }
            allowCommitBeforeTarget = false;
        }
        Node method = JavaContext.findSurroundingMethod(parent);
        if (method == null) {
            return;
        }
        CommitFinder finder = new CommitFinder(context, node, allowCommitBeforeTarget);
        method.accept((AstVisitor)finder);
        if (finder.isCommitCalled()) return;
        context.report(ISSUE, method, context.getLocation((Node)node), "SharedPreferences.edit() without a corresponding commit() or apply() call", null);
    }

    @Nullable
    private static String getFieldType(@NonNull NormalTypeBody cls, @NonNull String name) {
        List children = cls.getChildren();
        for (Node child : children) {
            if (child.getClass() != VariableDeclaration.class) continue;
            VariableDeclaration declaration = (VariableDeclaration)child;
            VariableDefinition definition = declaration.astDefinition();
            return definition.astTypeReference().toString();
        }
        return null;
    }

    @Nullable
    private static VariableDefinition getLhs(@NonNull Node node) {
        while (node != null) {
            Class<?> type = node.getClass();
            if (type == MethodDeclaration.class || type == ConstructorDeclaration.class) {
                return null;
            }
            if (type == VariableDefinition.class) {
                return (VariableDefinition)node;
            }
            node = node.getParent();
        }
        return null;
    }

    private static class CommitFinder
    extends ForwardingAstVisitor {
        private final MethodInvocation mTarget;
        private final boolean mAllowCommitBeforeTarget;
        private final JavaContext mContext;
        private boolean mFound;
        private boolean mSeenTarget;

        private CommitFinder(JavaContext context, MethodInvocation target, boolean allowCommitBeforeTarget) {
            this.mContext = context;
            this.mTarget = target;
            this.mAllowCommitBeforeTarget = allowCommitBeforeTarget;
        }

        public boolean visitMethodInvocation(MethodInvocation node) {
            String name;
            boolean isCommit;
            if (node == this.mTarget) {
                this.mSeenTarget = true;
            } else if ((this.mAllowCommitBeforeTarget || this.mSeenTarget || node.astOperand() == this.mTarget) && ((isCommit = "commit".equals(name = node.astName().astValue())) || "apply".equals(name))) {
                JavaParser.ResolvedMethod method;
                JavaParser.ResolvedClass clz;
                this.mFound = true;
                JavaParser.ResolvedNode resolved = this.mContext.resolve((Node)node);
                if (resolved instanceof JavaParser.ResolvedMethod && (clz = (method = (JavaParser.ResolvedMethod)resolved).getContainingClass()).isSubclassOf(SharedPrefsDetector.ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR, false) && this.mContext.getProject().getMinSdkVersion().getApiLevel() >= 9) {
                    Node parent = node.getParent();
                    boolean returnValueIgnored = false;
                    if (parent instanceof MethodDeclaration || parent instanceof ConstructorDeclaration || parent instanceof ClassDeclaration || parent instanceof Block || parent instanceof ExpressionStatement) {
                        returnValueIgnored = true;
                    } else if (parent instanceof Statement) {
                        returnValueIgnored = parent instanceof If ? ((If)parent).astCondition() != node : (parent instanceof Return ? false : (parent instanceof VariableDeclaration ? false : (parent instanceof For ? ((For)parent).astCondition() != node : (parent instanceof While ? ((While)parent).astCondition() != node : (parent instanceof DoWhile ? ((DoWhile)parent).astCondition() != node : (parent instanceof Case ? ((Case)parent).astCondition() != node : (parent instanceof Assert ? ((Assert)parent).astAssertion() != node : true)))))));
                    }
                    if (returnValueIgnored && isCommit) {
                        String message = "Consider using apply() instead; commit writes its data to persistent storage immediately, whereas apply will handle it in the background";
                        this.mContext.report(ISSUE, (Node)node, this.mContext.getLocation((Node)node), message, null);
                    }
                }
            }
            return super.visitMethodInvocation(node);
        }

        public boolean visitReturn(Return node) {
            if (node.astValue() == this.mTarget) {
                this.mFound = true;
            }
            return super.visitReturn(node);
        }

        boolean isCommitCalled() {
            return this.mFound;
        }
    }
}

