/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.signing;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeytoolException;
import com.android.prefs.AndroidLocation;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public final class KeystoreHelper {
    private static final String CERTIFICATE_DESC = "CN=Android Debug,O=Android,C=US";

    @NonNull
    public static String defaultDebugKeystoreLocation() throws AndroidLocation.AndroidLocationException {
        String folder = AndroidLocation.getFolder();
        return folder + "debug.keystore";
    }

    public static boolean createDebugStore(@Nullable String storeType, @NonNull File storeFile, @NonNull String storePassword, @NonNull String keyPassword, @NonNull String keyAlias, @NonNull ILogger logger) throws KeytoolException {
        return KeystoreHelper.createNewStore(storeType, storeFile, storePassword, keyPassword, keyAlias, CERTIFICATE_DESC, 30, logger);
    }

    private static boolean createNewStore(@Nullable String storeType, @NonNull File storeFile, @NonNull String storePassword, @NonNull String keyPassword, @NonNull String keyAlias, @NonNull String description, int validityYears, final @NonNull ILogger logger) throws KeytoolException {
        String os = System.getProperty("os.name");
        String keytoolCommand = os.startsWith("Windows") ? "keytool.exe" : "keytool";
        String javaHome = System.getProperty("java.home");
        if (javaHome != null && javaHome.length() > 0) {
            keytoolCommand = javaHome + File.separator + "bin" + File.separator + keytoolCommand;
        }
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(keytoolCommand);
        commandList.add("-genkey");
        commandList.add("-alias");
        commandList.add(keyAlias);
        commandList.add("-keyalg");
        commandList.add("RSA");
        commandList.add("-dname");
        commandList.add(description);
        commandList.add("-validity");
        commandList.add(Integer.toString(validityYears * 365));
        commandList.add("-keypass");
        commandList.add(keyPassword);
        commandList.add("-keystore");
        commandList.add(storeFile.getAbsolutePath());
        commandList.add("-storepass");
        commandList.add(storePassword);
        if (storeType != null) {
            commandList.add("-storetype");
            commandList.add(storeType);
        }
        String[] commandArray = commandList.toArray(new String[commandList.size()]);
        int result = 0;
        try {
            Process process = Runtime.getRuntime().exec(commandArray);
            result = GrabProcessOutput.grabProcessOutput((Process)process, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(){

                public void out(@Nullable String line) {
                    if (line != null) {
                        logger.info(line, new Object[0]);
                    }
                }

                public void err(@Nullable String line) {
                    if (line != null) {
                        logger.error(null, line, new Object[0]);
                    }
                }
            });
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder();
            boolean firstArg = true;
            for (String arg : commandArray) {
                boolean hasSpace;
                boolean bl = hasSpace = arg.indexOf(32) != -1;
                if (firstArg) {
                    firstArg = false;
                } else {
                    builder.append(' ');
                }
                if (hasSpace) {
                    builder.append('\"');
                }
                builder.append(arg);
                if (!hasSpace) continue;
                builder.append('\"');
            }
            throw new KeytoolException("Failed to create key: " + e.getMessage(), javaHome, builder.toString());
        }
        return result == 0;
    }

    public static CertificateInfo getCertificateInfo(@Nullable String storeType, @NonNull File storeFile, @NonNull String storePassword, @NonNull String keyPassword, @NonNull String keyAlias) throws KeytoolException, FileNotFoundException {
        try {
            KeyStore keyStore = KeyStore.getInstance(storeType != null ? storeType : KeyStore.getDefaultType());
            FileInputStream fis = new FileInputStream(storeFile);
            keyStore.load(fis, storePassword.toCharArray());
            fis.close();
            char[] keyPasswordArray = keyPassword.toCharArray();
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyAlias, new KeyStore.PasswordProtection(keyPasswordArray));
            if (entry != null) {
                return new CertificateInfo(entry.getPrivateKey(), (X509Certificate)entry.getCertificate());
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeytoolException(String.format("Failed to read key %1$s from store \"%2$s\": %3$s", keyAlias, storeFile, e.getMessage()), e);
        }
        return null;
    }
}

