/*
 * Decompiled with CFR 0.152.
 */
package com.android.assetstudiolib;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.assetstudiolib.GraphicGeneratorContext;
import com.android.assetstudiolib.Util;
import com.android.resources.Density;
import com.android.utils.Pair;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class LauncherIconGenerator
extends GraphicGenerator {
    private static final Rectangle IMAGE_SIZE_WEB = new Rectangle(0, 0, 512, 512);
    private static final Rectangle IMAGE_SIZE_MDPI = new Rectangle(0, 0, 48, 48);
    private static final Map<Pair<GraphicGenerator.Shape, Density>, Rectangle> TARGET_RECTS = new HashMap<Pair<GraphicGenerator.Shape, Density>, Rectangle>();

    @Override
    public BufferedImage generate(GraphicGeneratorContext context, GraphicGenerator.Options options) {
        Rectangle targetRect;
        LauncherOptions launcherOptions = (LauncherOptions)options;
        String density = launcherOptions.isWebGraphic ? "web" : launcherOptions.density.getResourceValue();
        BufferedImage backImage = null;
        BufferedImage foreImage = null;
        BufferedImage maskImage = null;
        BufferedImage maskInnerImage = null;
        if (launcherOptions.shape != GraphicGenerator.Shape.NONE && launcherOptions.shape != null) {
            String shape = launcherOptions.shape.id;
            backImage = context.loadImageResource("/images/launcher_stencil/" + shape + "/" + density + "/back.png");
            foreImage = context.loadImageResource("/images/launcher_stencil/" + shape + "/" + density + "/" + launcherOptions.style.id + ".png");
            maskImage = context.loadImageResource("/images/launcher_stencil/" + shape + "/" + density + "/mask.png");
            maskInnerImage = context.loadImageResource("/images/launcher_stencil/" + shape + "/" + density + "/mask_inner.png");
        }
        Rectangle imageRect = IMAGE_SIZE_WEB;
        if (!launcherOptions.isWebGraphic) {
            imageRect = Util.scaleRectangle(IMAGE_SIZE_MDPI, GraphicGenerator.getMdpiScaleFactor(launcherOptions.density));
        }
        if ((targetRect = TARGET_RECTS.get(Pair.of((Object)((Object)launcherOptions.shape), (Object)launcherOptions.density))) == null) {
            targetRect = Util.scaleRectangle(TARGET_RECTS.get(Pair.of((Object)((Object)launcherOptions.shape), (Object)Density.MEDIUM)), GraphicGenerator.getMdpiScaleFactor(launcherOptions.density));
        }
        BufferedImage outImage = Util.newArgbBufferedImage(imageRect.width, imageRect.height);
        Graphics2D g = (Graphics2D)outImage.getGraphics();
        if (backImage != null) {
            g.drawImage((Image)backImage, 0, 0, null);
        }
        BufferedImage tempImage = Util.newArgbBufferedImage(imageRect.width, imageRect.height);
        Graphics2D g2 = (Graphics2D)tempImage.getGraphics();
        if (maskImage != null) {
            g2.drawImage(maskImage, 0, 0, null);
            g2.setComposite(AlphaComposite.SrcAtop);
            g2.setPaint(new Color(launcherOptions.backgroundColor));
            g2.fillRect(0, 0, imageRect.width, imageRect.height);
        }
        BufferedImage tempImage2 = Util.newArgbBufferedImage(imageRect.width, imageRect.height);
        Graphics2D g3 = (Graphics2D)tempImage2.getGraphics();
        if (maskInnerImage != null) {
            g3.drawImage(maskInnerImage, 0, 0, null);
            g3.setComposite(AlphaComposite.SrcAtop);
            g3.setPaint(new Color(launcherOptions.backgroundColor));
            g3.fillRect(0, 0, imageRect.width, imageRect.height);
        }
        if (launcherOptions.crop) {
            Util.drawCenterCrop(g3, launcherOptions.sourceImage, targetRect);
        } else {
            Util.drawCenterInside(g3, launcherOptions.sourceImage, targetRect);
        }
        g2.drawImage((Image)tempImage2, 0, 0, null);
        g.drawImage((Image)tempImage, 0, 0, null);
        if (foreImage != null) {
            g.drawImage((Image)foreImage, 0, 0, null);
        }
        g.dispose();
        g2.dispose();
        return outImage;
    }

    @Override
    public void generate(String category, Map<String, Map<String, BufferedImage>> categoryMap, GraphicGeneratorContext context, GraphicGenerator.Options options, String name) {
        LauncherOptions launcherOptions = (LauncherOptions)options;
        boolean generateWebImage = launcherOptions.isWebGraphic;
        launcherOptions.isWebGraphic = false;
        super.generate(category, categoryMap, context, options, name);
        if (generateWebImage) {
            launcherOptions.isWebGraphic = true;
            launcherOptions.density = null;
            BufferedImage image = this.generate(context, options);
            if (image != null) {
                HashMap<String, BufferedImage> imageMap = new HashMap<String, BufferedImage>();
                categoryMap.put("Web", imageMap);
                imageMap.put(this.getIconPath(options, name), image);
            }
        }
    }

    @Override
    protected String getIconPath(GraphicGenerator.Options options, String name) {
        if (((LauncherOptions)options).isWebGraphic) {
            return name + "-web.png";
        }
        return super.getIconPath(options, name);
    }

    static {
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.NONE), (Object)null), new Rectangle(32, 32, 448, 448));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.NONE), (Object)Density.HIGH), new Rectangle(4, 4, 64, 64));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.NONE), (Object)Density.MEDIUM), new Rectangle(3, 3, 42, 42));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.CIRCLE), (Object)null), new Rectangle(32, 43, 448, 448));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.CIRCLE), (Object)Density.HIGH), new Rectangle(4, 6, 64, 64));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.CIRCLE), (Object)Density.MEDIUM), new Rectangle(3, 4, 42, 42));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.SQUARE), (Object)null), new Rectangle(32, 53, 448, 427));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.SQUARE), (Object)Density.HIGH), new Rectangle(4, 8, 64, 60));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.SQUARE), (Object)Density.MEDIUM), new Rectangle(3, 5, 42, 40));
    }

    public static class LauncherOptions
    extends GraphicGenerator.Options {
        public int backgroundColor = 0;
        public boolean crop = true;
        public GraphicGenerator.Shape shape = GraphicGenerator.Shape.SQUARE;
        public GraphicGenerator.Style style = GraphicGenerator.Style.SIMPLE;
        public boolean isWebGraphic;
    }
}

