/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Function;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.profiles.activation.JdkPrefixProfileActivator;
import org.apache.maven.profiles.activation.OperatingSystemProfileActivator;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.profiles.activation.ProfileActivator;
import org.apache.maven.profiles.activation.SystemPropertyProfileActivator;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectUtils;
import org.apache.maven.project.artifact.ProjectArtifactFactory;
import org.apache.maven.project.inheritance.DefaultModelInheritanceAssembler;
import org.apache.maven.project.injection.DefaultProfileInjector;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.project.path.DefaultPathTranslator;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeResolutionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.Maven2ServerGlobals;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenServerConsole;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.server.embedder.CustomArtifactFactory;
import org.jetbrains.idea.maven.server.embedder.CustomArtifactResolver;
import org.jetbrains.idea.maven.server.embedder.CustomModelInterpolator;
import org.jetbrains.idea.maven.server.embedder.CustomRepositoryMetadataManager;
import org.jetbrains.idea.maven.server.embedder.CustomWagonManager;
import org.jetbrains.idea.maven.server.embedder.ExecutorManager;
import org.jetbrains.idea.maven.server.embedder.Maven2ModelConverter;
import org.jetbrains.idea.maven.server.embedder.Maven2ServerConsoleWrapper;
import org.jetbrains.idea.maven.server.embedder.MyFileProfileActivator;
import org.jetbrains.idea.maven.server.embedder.RemoteNativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.embedder.RuntimeRemoteException;
import org.jetbrains.idea.maven.server.embedder.TransferListenerAdapter;
import org.jetbrains.maven.embedder.MavenEmbedder;
import org.jetbrains.maven.embedder.MavenEmbedderSettings;
import org.jetbrains.maven.embedder.MavenExecutionResult;
import org.jetbrains.maven.embedder.PlexusComponentConfigurator;

public class Maven2ServerEmbedderImpl
extends MavenRemoteObject
implements MavenServerEmbedder {
    private final MavenEmbedder myImpl;
    private final Maven2ServerConsoleWrapper myConsoleWrapper;
    private volatile MavenServerProgressIndicator myCurrentIndicator;

    public static Maven2ServerEmbedderImpl create(MavenServerSettings facadeSettings) throws RemoteException {
        MavenEmbedderSettings settings = new MavenEmbedderSettings();
        settings.setConfigurator(new PlexusComponentConfigurator(){

            @Override
            public void configureComponents(@NotNull PlexusContainer c) {
                if (c == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl$1", "configureComponents"));
                }
                Maven2ServerEmbedderImpl.setupContainer(c);
            }
        });
        Maven2ServerConsoleWrapper consoleWrapper = new Maven2ServerConsoleWrapper();
        consoleWrapper.setThreshold(facadeSettings.getLoggingLevel());
        settings.setLogger(consoleWrapper);
        settings.setRecursive(false);
        settings.setWorkOffline(facadeSettings.isOffline());
        settings.setUsePluginRegistry(false);
        settings.setMavenHome(facadeSettings.getMavenHome());
        settings.setUserSettingsFile(facadeSettings.getUserSettingsFile());
        settings.setGlobalSettingsFile(facadeSettings.getGlobalSettingsFile());
        settings.setLocalRepository(facadeSettings.getLocalRepository());
        settings.setSnapshotUpdatePolicy(Maven2ServerEmbedderImpl.convertUpdatePolicy(facadeSettings.getSnapshotUpdatePolicy()));
        settings.setPluginUpdatePolicy(Maven2ServerEmbedderImpl.convertUpdatePolicy(facadeSettings.getPluginUpdatePolicy()));
        settings.setProperties(MavenServerUtil.collectSystemProperties());
        return new Maven2ServerEmbedderImpl(MavenEmbedder.create(settings), consoleWrapper);
    }

    private static MavenEmbedderSettings.UpdatePolicy convertUpdatePolicy(MavenServerSettings.UpdatePolicy policy) throws RemoteException {
        switch (policy) {
            case ALWAYS_UPDATE: {
                return MavenEmbedderSettings.UpdatePolicy.ALWAYS_UPDATE;
            }
            case DO_NOT_UPDATE: {
                return MavenEmbedderSettings.UpdatePolicy.DO_NOT_UPDATE;
            }
        }
        Maven2ServerGlobals.getLogger().error(new Throwable("unexpected update policy"));
        return MavenEmbedderSettings.UpdatePolicy.DO_NOT_UPDATE;
    }

    private Maven2ServerEmbedderImpl(MavenEmbedder impl, Maven2ServerConsoleWrapper consoleWrapper) {
        this.myImpl = impl;
        this.myConsoleWrapper = consoleWrapper;
    }

    @NotNull
    public MavenServerExecutionResult resolveProject(final @NotNull File file, final @NotNull Collection<String> activeProfiles) throws MavenServerProcessCanceledException, RemoteException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "resolveProject"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "resolveProject"));
        }
        MavenServerExecutionResult mavenServerExecutionResult = this.doExecute(new Executor<MavenServerExecutionResult>(){

            @Override
            public MavenServerExecutionResult execute() throws Exception {
                DependencyTreeResolutionListener listener = new DependencyTreeResolutionListener((Logger)Maven2ServerEmbedderImpl.this.myConsoleWrapper);
                MavenExecutionResult result = Maven2ServerEmbedderImpl.this.myImpl.resolveProject(file, new ArrayList<String>(activeProfiles), Arrays.asList(listener));
                return Maven2ServerEmbedderImpl.this.createExecutionResult(file, result, listener.getRootNode());
            }
        });
        if (mavenServerExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "resolveProject"));
        }
        return mavenServerExecutionResult;
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(File file, MavenExecutionResult result, DependencyNode rootNode) throws RemoteException {
        Collection problems = MavenProjectProblem.createProblemsList();
        THashSet unresolvedArtifacts = new THashSet();
        this.validate(file, result.getExceptions(), problems, (Collection<MavenId>)unresolvedArtifacts);
        MavenProject mavenProject = result.getMavenProject();
        if (mavenProject == null) {
            MavenServerExecutionResult mavenServerExecutionResult = new MavenServerExecutionResult(null, problems, (Set)unresolvedArtifacts);
            if (mavenServerExecutionResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "createExecutionResult"));
            }
            return mavenServerExecutionResult;
        }
        MavenModel model = Maven2ModelConverter.convertModel(mavenProject.getModel(), mavenProject.getCompileSourceRoots(), mavenProject.getTestCompileSourceRoots(), mavenProject.getArtifacts(), rootNode == null ? Collections.emptyList() : rootNode.getChildren(), mavenProject.getExtensionArtifacts(), this.getLocalRepositoryFile());
        RemoteNativeMavenProjectHolder holder = new RemoteNativeMavenProjectHolder(mavenProject);
        try {
            UnicastRemoteObject.exportObject((Remote)((Object)holder), 0);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        Collection<String> activatedProfiles = this.collectActivatedProfiles(mavenProject);
        MavenServerExecutionResult.ProjectData data = new MavenServerExecutionResult.ProjectData(model, Maven2ModelConverter.convertToMap(mavenProject.getModel()), (NativeMavenProjectHolder)holder, activatedProfiles);
        MavenServerExecutionResult mavenServerExecutionResult = new MavenServerExecutionResult(data, problems, (Set)unresolvedArtifacts);
        if (mavenServerExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "createExecutionResult"));
        }
        return mavenServerExecutionResult;
    }

    private Collection<String> collectActivatedProfiles(MavenProject mavenProject) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        while (mavenProject != null) {
            if (profiles != null) {
                profiles.addAll(mavenProject.getActiveProfiles());
            }
            mavenProject = mavenProject.getParent();
        }
        return Maven2ServerEmbedderImpl.collectProfilesIds(profiles);
    }

    private static Collection<String> collectProfilesIds(List<Profile> profiles) {
        THashSet result = new THashSet();
        for (Profile each : profiles) {
            if (each.getId() == null) continue;
            result.add(each.getId());
        }
        return result;
    }

    @Nullable
    public String evaluateEffectivePom(@NotNull File file, @NotNull List<String> activeProfiles) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "evaluateEffectivePom"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "evaluateEffectivePom"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public MavenArtifact resolve(final @NotNull MavenArtifactInfo info, final @NotNull List<MavenRemoteRepository> remoteRepositories) throws MavenServerProcessCanceledException, RemoteException {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "resolve"));
        }
        if (remoteRepositories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "resolve"));
        }
        MavenArtifact mavenArtifact = this.doExecute(new Executor<MavenArtifact>(){

            @Override
            public MavenArtifact execute() throws Exception {
                return Maven2ServerEmbedderImpl.this.doResolve(info, remoteRepositories);
            }
        });
        if (mavenArtifact == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "resolve"));
        }
        return mavenArtifact;
    }

    @NotNull
    public List<MavenArtifact> resolveTransitively(@NotNull List<MavenArtifactInfo> artifacts, @NotNull List<MavenRemoteRepository> remoteRepositories) throws RemoteException {
        List<MavenArtifact> list;
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "resolveTransitively"));
        }
        if (remoteRepositories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "resolveTransitively"));
        }
        try {
            LinkedHashSet<Artifact> toResolve = new LinkedHashSet<Artifact>();
            for (MavenArtifactInfo each : artifacts) {
                toResolve.add(this.createArtifact(each));
            }
            list = Maven2ModelConverter.convertArtifacts(this.myImpl.resolveTransitively(toResolve, this.convertRepositories(remoteRepositories)), (Map<Artifact, MavenArtifact>)new THashMap(), this.getLocalRepositoryFile());
        }
        catch (ArtifactResolutionException e) {
            Maven2ServerGlobals.getLogger().info(e);
        }
        catch (ArtifactNotFoundException e) {
            Maven2ServerGlobals.getLogger().info(e);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "resolveTransitively"));
        }
        return list;
        List<MavenArtifact> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "resolveTransitively"));
        }
        return list2;
    }

    private MavenArtifact doResolve(MavenArtifactInfo info, List<MavenRemoteRepository> remoteRepositories) throws RemoteException {
        Artifact resolved = this.doResolve(this.createArtifact(info), this.convertRepositories(remoteRepositories));
        return Maven2ModelConverter.convertArtifact(resolved, this.getLocalRepositoryFile());
    }

    private Artifact createArtifact(MavenArtifactInfo info) {
        return this.getComponent(ArtifactFactory.class).createArtifactWithClassifier(info.getGroupId(), info.getArtifactId(), info.getVersion(), info.getPackaging(), info.getClassifier());
    }

    private Artifact doResolve(Artifact artifact, List<ArtifactRepository> remoteRepositories) throws RemoteException {
        try {
            this.myImpl.resolve(artifact, remoteRepositories);
            return artifact;
        }
        catch (Exception e) {
            Maven2ServerGlobals.getLogger().info(e);
            return artifact;
        }
    }

    private List<ArtifactRepository> convertRepositories(List<MavenRemoteRepository> repositories) throws RemoteException {
        ArrayList<ArtifactRepository> result = new ArrayList<ArtifactRepository>();
        for (MavenRemoteRepository each : repositories) {
            try {
                ArtifactRepositoryFactory factory = this.getComponent(ArtifactRepositoryFactory.class);
                result.add(ProjectUtils.buildArtifactRepository((Repository)Maven2ModelConverter.toNativeRepository(each), (ArtifactRepositoryFactory)factory, (PlexusContainer)this.getContainer()));
            }
            catch (InvalidRepositoryException e) {
                Maven2ServerGlobals.getLogger().warn(e);
            }
        }
        return result;
    }

    public Collection<MavenArtifact> resolvePlugin(final @NotNull MavenPlugin plugin, final @NotNull List<MavenRemoteRepository> repositories, final int nativeMavenProjectId, final boolean transitive) throws MavenServerProcessCanceledException, RemoteException {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "resolvePlugin"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "resolvePlugin"));
        }
        return this.doExecute(new Executor<Collection<MavenArtifact>>(){

            @Override
            public Collection<MavenArtifact> execute() throws Exception {
                try {
                    Plugin mavenPlugin = new Plugin();
                    mavenPlugin.setGroupId(plugin.getGroupId());
                    mavenPlugin.setArtifactId(plugin.getArtifactId());
                    mavenPlugin.setVersion(plugin.getVersion());
                    MavenProject project = RemoteNativeMavenProjectHolder.findProjectById(nativeMavenProjectId);
                    PluginDescriptor result = Maven2ServerEmbedderImpl.this.getComponent(PluginManager.class).verifyPlugin(mavenPlugin, project, Maven2ServerEmbedderImpl.this.myImpl.getSettings(), Maven2ServerEmbedderImpl.this.myImpl.getLocalRepository());
                    THashMap resolvedArtifacts = new THashMap();
                    Artifact pluginArtifact = result.getPluginArtifact();
                    MavenArtifactInfo artifactInfo = new MavenArtifactInfo(pluginArtifact.getGroupId(), pluginArtifact.getArtifactId(), pluginArtifact.getVersion(), pluginArtifact.getType(), null);
                    Maven2ServerEmbedderImpl.this.resolveIfNecessary(artifactInfo, repositories, (Map)resolvedArtifacts);
                    if (transitive) {
                        for (Artifact each : result.getIntroducedDependencyArtifacts()) {
                            Maven2ServerEmbedderImpl.this.resolveIfNecessary(new MavenArtifactInfo(each.getGroupId(), each.getArtifactId(), each.getVersion(), each.getType(), null), repositories, (Map)resolvedArtifacts);
                        }
                        for (Artifact each : result.getDependencies()) {
                            Maven2ServerEmbedderImpl.this.resolveIfNecessary(new MavenArtifactInfo(each.getGroupId(), each.getArtifactId(), each.getVersion(), each.getType(), null), repositories, (Map)resolvedArtifacts);
                        }
                    }
                    return new THashSet(resolvedArtifacts.values());
                }
                catch (Exception e) {
                    Maven2ServerGlobals.getLogger().info(e);
                    return Collections.emptyList();
                }
            }
        });
    }

    private void resolveIfNecessary(MavenArtifactInfo info, List<MavenRemoteRepository> repos, Map<MavenArtifactInfo, MavenArtifact> resolvedArtifacts) throws RemoteException {
        if (resolvedArtifacts.containsKey(info)) {
            return;
        }
        resolvedArtifacts.put(info, this.doResolve(info, repos));
    }

    @NotNull
    public MavenServerExecutionResult execute(final @NotNull File file, final @NotNull Collection<String> activeProfiles, final @NotNull Collection<String> inactiveProfiles, final @NotNull List<String> goals, final @NotNull List<String> selectedProjects, final boolean alsoMake, final boolean alsoMakeDependents) throws RemoteException, MavenServerProcessCanceledException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "execute"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "execute"));
        }
        if (inactiveProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "execute"));
        }
        if (goals == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "execute"));
        }
        if (selectedProjects == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "execute"));
        }
        MavenServerExecutionResult mavenServerExecutionResult = this.doExecute(new Executor<MavenServerExecutionResult>(){

            @Override
            public MavenServerExecutionResult execute() throws Exception {
                MavenExecutionResult result = Maven2ServerEmbedderImpl.this.myImpl.execute(file, new ArrayList<String>(activeProfiles), new ArrayList<String>(inactiveProfiles), goals, selectedProjects, alsoMake, alsoMakeDependents);
                return Maven2ServerEmbedderImpl.this.createExecutionResult(file, result, null);
            }
        });
        if (mavenServerExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "execute"));
        }
        return mavenServerExecutionResult;
    }

    private void validate(File file, Collection<Exception> exceptions, Collection<MavenProjectProblem> problems, Collection<MavenId> unresolvedArtifacts) throws RemoteException {
        for (Exception each : exceptions) {
            Maven2ServerGlobals.getLogger().info(each);
            if (each instanceof InvalidProjectModelException) {
                ModelValidationResult modelValidationResult = ((InvalidProjectModelException)each).getValidationResult();
                if (modelValidationResult != null) {
                    for (Object eachValidationProblem : modelValidationResult.getMessages()) {
                        problems.add(MavenProjectProblem.createStructureProblem((String)file.getPath(), (String)((String)eachValidationProblem)));
                    }
                    continue;
                }
                problems.add(MavenProjectProblem.createStructureProblem((String)file.getPath(), (String)each.getCause().getMessage()));
                continue;
            }
            if (each instanceof ProjectBuildingException) {
                String causeMessage = each.getCause() != null ? each.getCause().getMessage() : each.getMessage();
                problems.add(MavenProjectProblem.createStructureProblem((String)file.getPath(), (String)causeMessage));
                continue;
            }
            problems.add(MavenProjectProblem.createStructureProblem((String)file.getPath(), (String)each.getMessage()));
        }
        unresolvedArtifacts.addAll(this.retrieveUnresolvedArtifactIds());
    }

    private Set<MavenId> retrieveUnresolvedArtifactIds() {
        THashSet result = new THashSet();
        ((CustomWagonManager)this.getComponent(WagonManager.class)).getUnresolvedCollector().retrieveUnresolvedIds((Set<MavenId>)result);
        ((CustomArtifactResolver)this.getComponent(ArtifactResolver.class)).getUnresolvedCollector().retrieveUnresolvedIds((Set<MavenId>)result);
        return result;
    }

    public static MavenModel interpolateAndAlignModel(MavenModel model, File basedir) throws RemoteException {
        Model result = Maven2ModelConverter.toNativeModel(model);
        result = Maven2ServerEmbedderImpl.doInterpolate(result, basedir);
        DefaultPathTranslator pathTranslator = new DefaultPathTranslator();
        pathTranslator.alignToBaseDirectory(result, basedir);
        return Maven2ModelConverter.convertModel(result, null);
    }

    private static Model doInterpolate(Model result, File basedir) throws RemoteException {
        try {
            CustomModelInterpolator interpolator = new CustomModelInterpolator(new DefaultPathTranslator());
            interpolator.initialize();
            Properties props = MavenServerUtil.collectSystemProperties();
            ProjectBuilderConfiguration config = new DefaultProjectBuilderConfiguration().setExecutionProperties(props);
            result = interpolator.interpolate(result, basedir, config, false);
        }
        catch (ModelInterpolationException e) {
            Maven2ServerGlobals.getLogger().warn(e);
        }
        catch (InitializationException e) {
            Maven2ServerGlobals.getLogger().error(e);
        }
        return result;
    }

    public static MavenModel assembleInheritance(MavenModel model, MavenModel parentModel) throws RemoteException {
        Model result = Maven2ModelConverter.toNativeModel(model);
        new DefaultModelInheritanceAssembler().assembleModelInheritance(result, Maven2ModelConverter.toNativeModel(parentModel));
        return Maven2ModelConverter.convertModel(result, null);
    }

    public static ProfileApplicationResult applyProfiles(MavenModel model, File basedir, Collection<String> explicitProfiles, Collection<String> alwaysOnProfiles) throws RemoteException {
        Model nativeModel = Maven2ModelConverter.toNativeModel(model);
        ArrayList<Profile> activatedPom = new ArrayList<Profile>();
        ArrayList<Profile> activatedExternal = new ArrayList<Profile>();
        ArrayList<Profile> activeByDefault = new ArrayList<Profile>();
        List rawProfiles = nativeModel.getProfiles();
        List expandedProfilesCache = null;
        for (int i = 0; i < rawProfiles.size(); ++i) {
            Profile eachRawProfile = (Profile)rawProfiles.get(i);
            boolean shouldAdd = explicitProfiles.contains(eachRawProfile.getId()) || alwaysOnProfiles.contains(eachRawProfile.getId());
            Activation activation = eachRawProfile.getActivation();
            if (activation != null) {
                if (activation.isActiveByDefault()) {
                    activeByDefault.add(eachRawProfile);
                }
                if (expandedProfilesCache == null) {
                    expandedProfilesCache = Maven2ServerEmbedderImpl.doInterpolate(nativeModel, basedir).getProfiles();
                }
                Profile eachExpandedProfile = (Profile)expandedProfilesCache.get(i);
                for (ProfileActivator eachActivator : Maven2ServerEmbedderImpl.getProfileActivators(basedir)) {
                    try {
                        if (!eachActivator.canDetermineActivation(eachExpandedProfile) || !eachActivator.isActive(eachExpandedProfile)) continue;
                        shouldAdd = true;
                        break;
                    }
                    catch (ProfileActivationException e) {
                        Maven2ServerGlobals.getLogger().warn(e);
                    }
                }
            }
            if (!shouldAdd) continue;
            if ("pom".equals(eachRawProfile.getSource())) {
                activatedPom.add(eachRawProfile);
                continue;
            }
            activatedExternal.add(eachRawProfile);
        }
        ArrayList<Profile> activatedProfiles = new ArrayList<Profile>(activatedPom.isEmpty() ? activeByDefault : activatedPom);
        activatedProfiles.addAll(activatedExternal);
        for (Profile each : activatedProfiles) {
            new DefaultProfileInjector().inject(each, nativeModel);
        }
        return new ProfileApplicationResult(Maven2ModelConverter.convertModel(nativeModel, null), Maven2ServerEmbedderImpl.collectProfilesIds(activatedProfiles));
    }

    private static ProfileActivator[] getProfileActivators(File basedir) throws RemoteException {
        SystemPropertyProfileActivator sysPropertyActivator = new SystemPropertyProfileActivator();
        DefaultContext context = new DefaultContext();
        context.put((Object)"SystemProperties", (Object)MavenServerUtil.collectSystemProperties());
        try {
            sysPropertyActivator.contextualize((Context)context);
        }
        catch (ContextException e) {
            Maven2ServerGlobals.getLogger().error(e);
            return new ProfileActivator[0];
        }
        return new ProfileActivator[]{new MyFileProfileActivator(basedir), sysPropertyActivator, new JdkPrefixProfileActivator(), new OperatingSystemProfileActivator()};
    }

    @NotNull
    public File getLocalRepositoryFile() {
        File file = this.myImpl.getLocalRepositoryFile();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "getLocalRepositoryFile"));
        }
        return file;
    }

    public <T> T getComponent(Class<T> clazz) {
        return this.myImpl.getComponent(clazz);
    }

    public <T> T getComponent(Class<T> clazz, String roleHint) {
        return this.myImpl.getComponent(clazz, roleHint);
    }

    public PlexusContainer getContainer() {
        return this.myImpl.getContainer();
    }

    private <T> T doExecute(final Executor<T> executor) throws MavenServerProcessCanceledException, RemoteException {
        final Ref result = new Ref();
        final boolean[] cancelled = new boolean[1];
        final Throwable[] exception = new Throwable[1];
        Future<?> future = ExecutorManager.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    result.set(executor.execute());
                }
                catch (ProcessCanceledException e) {
                    cancelled[0] = true;
                }
                catch (Throwable e) {
                    exception[0] = e;
                }
            }
        });
        MavenServerProgressIndicator indicator = this.myCurrentIndicator;
        do {
            if (indicator.isCanceled()) {
                throw new MavenServerProcessCanceledException();
            }
            try {
                future.get(50L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException ignore) {
            }
            catch (ExecutionException e) {
                throw this.rethrowException(e);
            }
            catch (InterruptedException e) {
                throw new MavenServerProcessCanceledException();
            }
        } while (!future.isDone());
        if (cancelled[0]) {
            throw new MavenServerProcessCanceledException();
        }
        if (exception[0] != null) {
            if (exception[0] instanceof RuntimeRemoteException) {
                throw ((RuntimeRemoteException)exception[0]).getCause();
            }
            throw this.getRethrowable(exception[0]);
        }
        return (T)result.get();
    }

    private RuntimeException getRethrowable(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = throwable.getCause();
        }
        return this.rethrowException(throwable);
    }

    private static void setupContainer(PlexusContainer c) {
        MavenEmbedder.setImplementation(c, ArtifactFactory.class, CustomArtifactFactory.class);
        MavenEmbedder.setImplementation(c, ProjectArtifactFactory.class, CustomArtifactFactory.class);
        MavenEmbedder.setImplementation(c, ArtifactResolver.class, CustomArtifactResolver.class);
        MavenEmbedder.setImplementation(c, RepositoryMetadataManager.class, CustomRepositoryMetadataManager.class);
        MavenEmbedder.setImplementation(c, WagonManager.class, CustomWagonManager.class);
        MavenEmbedder.setImplementation(c, ModelInterpolator.class, CustomModelInterpolator.class);
    }

    public void customize(@Nullable MavenWorkspaceMap workspaceMap, boolean failOnUnresolvedDependency, @NotNull MavenServerConsole console, @NotNull MavenServerProgressIndicator indicator, boolean alwaysUpdateSnapshots) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "customize"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl", "customize"));
        }
        try {
            ((CustomArtifactFactory)this.getComponent(ArtifactFactory.class)).customize();
            ((CustomArtifactFactory)this.getComponent(ProjectArtifactFactory.class)).customize();
            ((CustomArtifactResolver)this.getComponent(ArtifactResolver.class)).customize(workspaceMap, failOnUnresolvedDependency);
            ((CustomRepositoryMetadataManager)this.getComponent(RepositoryMetadataManager.class)).customize(workspaceMap);
            ((CustomWagonManager)this.getComponent(WagonManager.class)).customize(failOnUnresolvedDependency);
            this.setConsoleAndIndicator(console, indicator);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    private void setConsoleAndIndicator(MavenServerConsole console, MavenServerProgressIndicator indicator) {
        this.myConsoleWrapper.setWrappee(console);
        this.myCurrentIndicator = indicator;
        WagonManager wagon = this.getComponent(WagonManager.class);
        wagon.setDownloadMonitor((TransferListener)(indicator == null ? null : new TransferListenerAdapter(indicator)));
    }

    public void reset() {
        try {
            this.setConsoleAndIndicator(null, null);
            ((CustomArtifactFactory)this.getComponent(ProjectArtifactFactory.class)).reset();
            ((CustomArtifactFactory)this.getComponent(ArtifactFactory.class)).reset();
            ((CustomArtifactResolver)this.getComponent(ArtifactResolver.class)).reset();
            ((CustomRepositoryMetadataManager)this.getComponent(RepositoryMetadataManager.class)).reset();
            ((CustomWagonManager)this.getComponent(WagonManager.class)).reset();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    public void release() {
        try {
            this.myImpl.release();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    public void clearCaches() throws RemoteException {
        this.withProjectCachesDo(new Function<Map, Object>(){

            public Object fun(Map map) {
                map.clear();
                return null;
            }
        });
    }

    public void clearCachesFor(final MavenId projectId) throws RemoteException {
        this.withProjectCachesDo(new Function<Map, Object>(){

            public Object fun(Map map) {
                map.remove(projectId.getKey());
                return null;
            }
        });
    }

    private void withProjectCachesDo(Function<Map, ?> func) throws RemoteException {
        MavenProjectBuilder builder = this.myImpl.getComponent(MavenProjectBuilder.class);
        try {
            Field field = builder.getClass().getDeclaredField("rawProjectCache");
            field.setAccessible(true);
            func.fun((Object)((Map)field.get(builder)));
            field = builder.getClass().getDeclaredField("processedProjectCache");
            field.setAccessible(true);
            func.fun((Object)((Map)field.get(builder)));
        }
        catch (NoSuchFieldException e) {
            Maven2ServerGlobals.getLogger().info(e);
        }
        catch (IllegalAccessException e) {
            Maven2ServerGlobals.getLogger().info(e);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    private static interface Executor<T> {
        public T execute() throws Exception;
    }
}

