/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public abstract class AndroidBuildTargetType<T extends AndroidBuildTarget>
extends BuildTargetType<T> {
    private final String myPresentableName;

    AndroidBuildTargetType(@NotNull String typeId, @NotNull String presentableName) {
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/android/builder/AndroidBuildTargetType", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/android/builder/AndroidBuildTargetType", "<init>"));
        }
        super(typeId);
        this.myPresentableName = presentableName;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myPresentableName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidBuildTargetType", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public List<T> computeAllTargets(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/android/builder/AndroidBuildTargetType", "computeAllTargets"));
        }
        if (!AndroidJpsUtil.isAndroidProjectWithoutGradleFacet(model.getProject())) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidBuildTargetType", "computeAllTargets"));
            }
            return list;
        }
        ArrayList<T> targets = new ArrayList<T>();
        for (JpsModule module : model.getProject().getModules()) {
            T target;
            JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
            if (extension == null || (target = this.createBuildTarget(extension)) == null) continue;
            targets.add(target);
        }
        ArrayList<T> arrayList = targets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidBuildTargetType", "computeAllTargets"));
        }
        return arrayList;
    }

    @Nullable
    public abstract T createBuildTarget(@NotNull JpsAndroidModuleExtension var1);

    @NotNull
    public BuildTargetLoader<T> createLoader(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/android/builder/AndroidBuildTargetType", "createLoader"));
        }
        final HashMap<String, AndroidBuildTarget> targetMap = new HashMap<String, AndroidBuildTarget>();
        for (AndroidBuildTarget target : this.computeAllTargets(model)) {
            targetMap.put(target.getId(), target);
        }
        BuildTargetLoader buildTargetLoader = new BuildTargetLoader<T>(){

            @Nullable
            public T createTarget(@NotNull String targetId) {
                if (targetId == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/android/builder/AndroidBuildTargetType$1", "createTarget"));
                }
                return (Object)((AndroidBuildTarget)((Object)targetMap.get(targetId)));
            }
        };
        if (buildTargetLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidBuildTargetType", "createLoader"));
        }
        return buildTargetLoader;
    }
}

