/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidFileSetState;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public class AndroidGenSourcesCopyingStorage
implements StorageOwner {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.android.AndroidGenSourcesCopyingStorage");
    public static final StorageProvider<AndroidGenSourcesCopyingStorage> PROVIDER = new StorageProvider<AndroidGenSourcesCopyingStorage>(){

        @NotNull
        public AndroidGenSourcesCopyingStorage createStorage(File targetDataDir) throws IOException {
            AndroidGenSourcesCopyingStorage androidGenSourcesCopyingStorage = new AndroidGenSourcesCopyingStorage(new File(targetDataDir, "gen_sources_copying" + File.separator + "data"));
            if (androidGenSourcesCopyingStorage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidGenSourcesCopyingStorage$1", "createStorage"));
            }
            return androidGenSourcesCopyingStorage;
        }
    };
    private final File myFile;

    private AndroidGenSourcesCopyingStorage(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/android/AndroidGenSourcesCopyingStorage", "<init>"));
        }
        this.myFile = file;
    }

    public void flush(boolean memoryCachesOnly) {
    }

    public void clean() throws IOException {
        FileUtil.delete((File)this.myFile);
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AndroidFileSetState read() {
        block6: {
            AndroidFileSetState androidFileSetState;
            DataInputStream input = new DataInputStream(new FileInputStream(this.myFile));
            try {
                androidFileSetState = new AndroidFileSetState(input);
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                    throw throwable;
                }
                catch (FileNotFoundException ignored) {
                    break block6;
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
            input.close();
            return androidFileSetState;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(@NotNull AndroidFileSetState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/android/AndroidGenSourcesCopyingStorage", "saveState"));
        }
        FileUtil.createParentDirs((File)this.myFile);
        try {
            DataOutputStream output = new DataOutputStream(new FileOutputStream(this.myFile));
            try {
                state.save(output);
            }
            finally {
                output.close();
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }
}

