/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidBuildConfigState;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;

public class AndroidBuildConfigStateStorage
extends AbstractStateStorage<String, AndroidBuildConfigState> {
    public static final StorageProvider<AndroidBuildConfigStateStorage> PROVIDER = new StorageProvider<AndroidBuildConfigStateStorage>(){

        @NotNull
        public AndroidBuildConfigStateStorage createStorage(File targetDataDir) throws IOException {
            AndroidBuildConfigStateStorage androidBuildConfigStateStorage = new AndroidBuildConfigStateStorage(targetDataDir);
            if (androidBuildConfigStateStorage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidBuildConfigStateStorage$1", "createStorage"));
            }
            return androidBuildConfigStateStorage;
        }
    };
    @NonNls
    private static final String BUILD_CONFIG_STORAGE = "build_config";

    private AndroidBuildConfigStateStorage(@NotNull File dataStorageRoot) throws IOException {
        if (dataStorageRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/android/AndroidBuildConfigStateStorage", "<init>"));
        }
        super(AndroidJpsUtil.getStorageFile(dataStorageRoot, BUILD_CONFIG_STORAGE), (KeyDescriptor)new EnumeratorStringDescriptor(), (DataExternalizer)new MyDataExternalizer());
    }

    private static class MyDataExternalizer
    implements DataExternalizer<AndroidBuildConfigState> {
        private MyDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, AndroidBuildConfigState value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/android/AndroidBuildConfigStateStorage$MyDataExternalizer", "save"));
            }
            value.save(out);
        }

        public AndroidBuildConfigState read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/android/AndroidBuildConfigStateStorage$MyDataExternalizer", "read"));
            }
            return new AndroidBuildConfigState(in);
        }
    }
}

