/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.vfs.VirtualFile;
import icons.MavenIcons;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryEditor;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public class RepositoryLibraryType
extends LibraryType<RepositoryLibraryProperties> {
    private static final PersistentLibraryKind<RepositoryLibraryProperties> LIBRARY_KIND = new PersistentLibraryKind<RepositoryLibraryProperties>("repository"){

        @NotNull
        public RepositoryLibraryProperties createDefaultProperties() {
            RepositoryLibraryProperties repositoryLibraryProperties = new RepositoryLibraryProperties();
            if (repositoryLibraryProperties == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryType$1", "createDefaultProperties"));
            }
            return repositoryLibraryProperties;
        }
    };

    public static RepositoryLibraryType getInstance() {
        return (RepositoryLibraryType)((Object)EP_NAME.findExtension(RepositoryLibraryType.class));
    }

    public RepositoryLibraryType() {
        super(LIBRARY_KIND);
    }

    public String getCreateActionName() {
        return "From Maven...";
    }

    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, @Nullable VirtualFile contextDirectory, @NotNull Project project) {
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryType", "createNewLibrary"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryType", "createNewLibrary"));
        }
        return RepositoryAttachHandler.chooseLibraryAndDownload(project, null, parentComponent);
    }

    public LibraryPropertiesEditor createPropertiesEditor(@NotNull LibraryEditorComponent<RepositoryLibraryProperties> component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryType", "createPropertiesEditor"));
        }
        return new RepositoryLibraryEditor(component, this);
    }

    public String getDescription(@NotNull RepositoryLibraryProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryType", "getDescription"));
        }
        String mavenIdKey = properties.getMavenId();
        return "Library " + (mavenIdKey != null ? mavenIdKey + " " : "") + "from Maven repository";
    }

    public Icon getIcon() {
        return MavenIcons.MavenLogo;
    }
}

