/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.services.MavenRepositoryServicesManager;
import org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryType;

public class RepositoryLibrarySynchronizer
implements StartupActivity,
DumbAware {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySynchronizer", "runActivity"));
        }
        StartupManager.getInstance((Project)project).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                    public void run() {
                        final MultiMap libraries = RepositoryLibrarySynchronizer.collectLibraries(project);
                        if (libraries.isEmpty()) {
                            return;
                        }
                        Task.Backgroundable task = new Task.Backgroundable(project, "Maven", false){

                            public void run(@NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySynchronizer$1$1$1", "run"));
                                }
                                RepositoryLibrarySynchronizer.ensureLibrariesAreDownloaded(project, (MultiMap<Library, Module>)libraries, indicator);
                            }
                        };
                        ProgressManager.getInstance().run((Task)task);
                    }
                }, project.getDisposed());
            }
        });
    }

    private static MultiMap<Library, Module> collectLibraries(final Project project) {
        final PersistentLibraryKind libraryKind = RepositoryLibraryType.getInstance().getKind();
        final MultiMap result = new MultiMap();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (final Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    OrderEnumerator.orderEntries((Module)module).withoutSdk().forEachLibrary((Processor)new Processor<Library>(){

                        public boolean process(Library library) {
                            if (((LibraryEx)library).getKind() == libraryKind) {
                                result.putValue((Object)library, (Object)module);
                            }
                            return true;
                        }
                    });
                }
                for (Module module : ProjectLibraryTable.getInstance((Project)project).getLibraries()) {
                    if (result.containsKey((Object)module) || ((LibraryEx)module).getKind() != libraryKind) continue;
                    result.put((Object)module, Collections.emptyList());
                }
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureLibrariesAreDownloaded(final Project project, MultiMap<Library, Module> libraries, ProgressIndicator indicator) {
        THashMap libsToSync = new THashMap();
        String localRepositoryPath = FileUtil.toSystemIndependentName((String)MavenProjectsManager.getInstance(project).getLocalRepository().getPath());
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            for (Library library : libraries.keySet()) {
                String firstUrl;
                VirtualFile[] files;
                String[] urls = library.getUrls(OrderRootType.CLASSES);
                if (urls.length <= (files = library.getFiles(OrderRootType.CLASSES)).length) continue;
                int flag = 0;
                if (library.getUrls(OrderRootType.SOURCES).length > 0) {
                    flag |= 1;
                }
                if (library.getUrls(JavadocOrderRootType.getInstance()).length > 0) {
                    flag |= 2;
                }
                String storagePath = (firstUrl = StringUtil.trimStart((String)PathUtil.getLocalPath((String)urls[0]), (String)"jar://")).startsWith(localRepositoryPath) ? null : FileUtil.toSystemDependentName((String)PathUtil.getParentPath((String)firstUrl));
                libsToSync.put((Object)library, (Object)Pair.create((Object)flag, (Object)storagePath));
            }
        }
        finally {
            token.finish();
        }
        if (libsToSync.isEmpty()) {
            return;
        }
        THashMap repoMap = new THashMap();
        for (String url : MavenRepositoryServicesManager.getServiceUrls()) {
            for (MavenRepositoryInfo info : MavenRepositoryServicesManager.getRepositories(url)) {
                repoMap.put(info.getId(), info);
            }
        }
        final ArrayList<MavenArtifact> dowloaded = new ArrayList<MavenArtifact>();
        for (final Library library : libsToSync.keySet()) {
            int flag = (Integer)((Pair)libsToSync.get((Object)library)).first;
            final String storagePath = (String)((Pair)libsToSync.get((Object)library)).second;
            SmartList extraTypes = new SmartList();
            if ((flag & 1) != 0) {
                extraTypes.add((Object)MavenExtraArtifactType.SOURCES);
            }
            if ((flag & 2) != 0) {
                extraTypes.add((Object)MavenExtraArtifactType.DOCS);
            }
            RepositoryLibraryProperties properties = (RepositoryLibraryProperties)((LibraryEx)library).getProperties();
            MavenId mavenId = RepositoryAttachHandler.getMavenId(properties.getMavenId());
            List<MavenId> idsToResolve = Collections.singletonList(mavenId);
            indicator.setText("Synchronizing " + mavenId.getDisplayString() + "...");
            ArrayList<MavenRepositoryInfo> repositories = new ArrayList<MavenRepositoryInfo>();
            for (String url : MavenRepositoryServicesManager.getServiceUrls()) {
                List<MavenArtifactInfo> artifacts = MavenRepositoryServicesManager.findArtifacts(new MavenArtifactInfo(mavenId, "jar", null), url);
                for (MavenArtifactInfo artifact : artifacts) {
                    ContainerUtil.addIfNotNull(repositories, repoMap.get(artifact.getRepositoryId()));
                }
            }
            RepositoryAttachHandler.doResolveInner(project, idsToResolve, (List<MavenExtraArtifactType>)extraTypes, repositories, new Processor<List<MavenArtifact>>(){

                public boolean process(final List<MavenArtifact> artifacts) {
                    dowloaded.addAll(artifacts);
                    ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            if (((LibraryEx)library).isDisposed()) {
                                return;
                            }
                            AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(RepositoryLibrarySynchronizer.class);
                            try {
                                List<OrderRoot> roots = RepositoryAttachHandler.createRoots(artifacts, storagePath);
                                Library.ModifiableModel model = library.getModifiableModel();
                                for (OrderRoot root : roots) {
                                    String fileName = PathUtil.getFileName((String)PathUtil.getLocalPath((String)root.getFile().getUrl()));
                                    for (String existingUrl : model.getUrls(root.getType())) {
                                        if (!Comparing.equal((String)PathUtil.getFileName((String)PathUtil.getLocalPath((String)existingUrl)), (String)fileName)) continue;
                                        model.removeRoot(existingUrl, root.getType());
                                    }
                                    model.addRoot(root.getFile(), root.getType());
                                }
                                model.commit();
                            }
                            finally {
                                token.finish();
                            }
                        }
                    }, project.getDisposed());
                    return true;
                }
            }, indicator);
        }
        RepositoryAttachHandler.notifyArtifactsDownloaded(project, dowloaded);
    }
}

