/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.actions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenActionUtil {
    private MavenActionUtil() {
    }

    public static boolean hasProject(DataContext context) {
        return CommonDataKeys.PROJECT.getData(context) != null;
    }

    @NotNull
    public static Project getProject(DataContext context) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/actions/MavenActionUtil", "getProject"));
        }
        return project;
    }

    public static boolean isMavenizedProject(DataContext context) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        return project != null && MavenProjectsManager.getInstance(project).isMavenizedProject();
    }

    @Nullable
    public static MavenProject getMavenProject(DataContext context) {
        MavenProject result;
        MavenProjectsManager manager = MavenActionUtil.getProjectsManager(context);
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        if (file != null && (result = manager.findProject(file)) != null) {
            return result;
        }
        Module module = MavenActionUtil.getModule(context);
        if (module != null && (result = manager.findProject(module)) != null) {
            return result;
        }
        return null;
    }

    @Nullable
    private static Module getModule(DataContext context) {
        Module module = (Module)DataKeys.MODULE.getData(context);
        return module != null ? module : (Module)DataKeys.MODULE_CONTEXT.getData(context);
    }

    @NotNull
    public static MavenProjectsManager getProjectsManager(DataContext context) {
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(MavenActionUtil.getProject(context));
        if (mavenProjectsManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/actions/MavenActionUtil", "getProjectsManager"));
        }
        return mavenProjectsManager;
    }

    public static boolean isMavenProjectFile(VirtualFile file) {
        return file != null && !file.isDirectory() && "pom.xml".equals(file.getName()) && file.isInLocalFileSystem();
    }

    public static List<MavenProject> getMavenProjects(DataContext context) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return Collections.emptyList();
        }
        VirtualFile[] virtualFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
        if (virtualFiles == null || virtualFiles.length == 0) {
            return Collections.emptyList();
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project);
        if (!projectsManager.isMavenizedProject()) {
            return Collections.emptyList();
        }
        LinkedHashSet<MavenProject> res = new LinkedHashSet<MavenProject>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (VirtualFile file : virtualFiles) {
            MavenProject mavenProject;
            if (file.isDirectory()) {
                VirtualFile contentRoot = fileIndex.getContentRootForFile(file);
                if (!file.equals(contentRoot)) {
                    return Collections.emptyList();
                }
                Module module = fileIndex.getModuleForFile(file);
                if (module == null || !projectsManager.isMavenizedModule(module)) {
                    return Collections.emptyList();
                }
                mavenProject = projectsManager.findProject(module);
            } else {
                mavenProject = projectsManager.findProject(file);
            }
            if (mavenProject == null) {
                return Collections.emptyList();
            }
            res.add(mavenProject);
        }
        return new ArrayList<MavenProject>(res);
    }

    public static List<VirtualFile> getMavenProjectsFiles(DataContext context) {
        return MavenUtil.collectFiles(MavenActionUtil.getMavenProjects(context));
    }
}

