/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.DisposeAwareRunnable;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import icons.MavenIcons;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.CRC32;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenConstants;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenTask;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MavenUtil {
    public static final String MAVEN_NOTIFICATION_GROUP = "Maven";
    public static final String SETTINGS_XML = "settings.xml";
    public static final String DOT_M2_DIR = ".m2";
    public static final String PROP_USER_HOME = "user.home";
    public static final String ENV_M2_HOME = "M2_HOME";
    public static final String M2_DIR = "m2";
    public static final String BIN_DIR = "bin";
    public static final String CONF_DIR = "conf";
    public static final String M2_CONF_FILE = "m2.conf";
    public static final String REPOSITORY_DIR = "repository";
    public static final String LIB_DIR = "lib";
    private static final Pair<Pattern, String>[] SUPER_POM_PATHS = new Pair[]{Pair.create((Object)Pattern.compile("maven-\\d+\\.\\d+\\.\\d+-uber\\.jar"), (Object)"org/apache/maven/project/pom-4.0.0.xml"), Pair.create((Object)Pattern.compile("maven-model-builder-\\d+\\.\\d+\\.\\d+\\.jar"), (Object)"org/apache/maven/model/pom-4.0.0.xml")};
    private static volatile Map<String, String> ourPropertiesFromMvnOpts;

    public static Map<String, String> getPropertiesFromMavenOpts() {
        Map<String, String> res = ourPropertiesFromMvnOpts;
        if (res == null) {
            String mavenOpts = System.getenv("MAVEN_OPTS");
            if (mavenOpts != null) {
                ParametersList mavenOptsList = new ParametersList();
                mavenOptsList.addParametersString(mavenOpts);
                res = mavenOptsList.getProperties();
            } else {
                res = Collections.emptyMap();
            }
            ourPropertiesFromMvnOpts = res;
        }
        return res;
    }

    public static void invokeLater(Project p, Runnable r) {
        MavenUtil.invokeLater(p, ModalityState.defaultModalityState(), r);
    }

    public static void invokeLater(Project p, ModalityState state, Runnable r) {
        if (MavenUtil.isNoBackgroundMode()) {
            r.run();
        } else {
            ApplicationManager.getApplication().invokeLater(DisposeAwareRunnable.create((Runnable)r, (Project)p), state);
        }
    }

    public static void invokeAndWait(Project p, Runnable r) {
        MavenUtil.invokeAndWait(p, ModalityState.defaultModalityState(), r);
    }

    public static void invokeAndWait(Project p, ModalityState state, Runnable r) {
        if (MavenUtil.isNoBackgroundMode()) {
            r.run();
        } else if (ApplicationManager.getApplication().isDispatchThread()) {
            r.run();
        } else {
            ApplicationManager.getApplication().invokeAndWait(DisposeAwareRunnable.create((Runnable)r, (Project)p), state);
        }
    }

    public static void invokeAndWaitWriteAction(Project p, final Runnable r) {
        MavenUtil.invokeAndWait(p, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(r);
            }
        });
    }

    public static void runDumbAware(Project project, Runnable r) {
        if (DumbService.isDumbAware((Object)r)) {
            r.run();
        } else {
            DumbService.getInstance((Project)project).runWhenSmart(DisposeAwareRunnable.create((Runnable)r, (Project)project));
        }
    }

    public static void runWhenInitialized(Project project, Runnable r) {
        if (project.isDisposed()) {
            return;
        }
        if (MavenUtil.isNoBackgroundMode()) {
            r.run();
            return;
        }
        if (!project.isInitialized()) {
            StartupManager.getInstance((Project)project).registerPostStartupActivity(DisposeAwareRunnable.create((Runnable)r, (Project)project));
            return;
        }
        MavenUtil.runDumbAware(project, r);
    }

    public static boolean isNoBackgroundMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public static boolean isInModalContext() {
        if (MavenUtil.isNoBackgroundMode()) {
            return false;
        }
        return LaterInvocator.isInModalContext();
    }

    public static void showError(Project project, String title, Throwable e) {
        MavenLog.LOG.warn(title, e);
        Notifications.Bus.notify((Notification)new Notification(MAVEN_NOTIFICATION_GROUP, title, e.getMessage(), NotificationType.ERROR), (Project)project);
    }

    public static File getPluginSystemDir(String folder) {
        return new File(PathManager.getSystemPath(), "Maven/" + folder).getAbsoluteFile();
    }

    public static VirtualFile findProfilesXmlFile(VirtualFile pomFile) {
        return pomFile.getParent().findChild("profiles.xml");
    }

    public static File getProfilesXmlIoFile(VirtualFile pomFile) {
        return new File(pomFile.getParent().getPath(), "profiles.xml");
    }

    public static <T, U> List<T> collectFirsts(List<Pair<T, U>> pairs) {
        ArrayList<Object> result = new ArrayList<Object>(pairs.size());
        for (Pair<T, U> each : pairs) {
            result.add(each.first);
        }
        return result;
    }

    public static <T, U> List<U> collectSeconds(List<Pair<T, U>> pairs) {
        ArrayList<Object> result = new ArrayList<Object>(pairs.size());
        for (Pair<T, U> each : pairs) {
            result.add(each.second);
        }
        return result;
    }

    public static List<String> collectPaths(List<VirtualFile> files) {
        return ContainerUtil.map(files, (Function)new Function<VirtualFile, String>(){

            public String fun(VirtualFile file) {
                return file.getPath();
            }
        });
    }

    public static List<VirtualFile> collectFiles(Collection<MavenProject> projects) {
        return ContainerUtil.map(projects, (Function)new Function<MavenProject, VirtualFile>(){

            public VirtualFile fun(MavenProject project) {
                return project.getFile();
            }
        });
    }

    public static <T> boolean equalAsSets(Collection<T> collection1, Collection<T> collection2) {
        return ((Object)MavenUtil.toSet(collection1)).equals(MavenUtil.toSet(collection2));
    }

    private static <T> Collection<T> toSet(Collection<T> collection) {
        return collection instanceof Set ? collection : new THashSet((Collection)collection);
    }

    public static <T, U> List<Pair<T, U>> mapToList(Map<T, U> map) {
        return ContainerUtil.map2List(map.entrySet(), (Function)new Function<Map.Entry<T, U>, Pair<T, U>>(){

            public Pair<T, U> fun(Map.Entry<T, U> tuEntry) {
                return Pair.create(tuEntry.getKey(), tuEntry.getValue());
            }
        });
    }

    public static String formatHtmlImage(URL url) {
        return "<img src=\"" + url + "\"> ";
    }

    public static void runOrApplyMavenProjectFileTemplate(Project project, VirtualFile file, @NotNull MavenId projectId, boolean interactive) throws IOException {
        if (projectId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/maven/utils/MavenUtil", "runOrApplyMavenProjectFileTemplate"));
        }
        MavenUtil.runOrApplyMavenProjectFileTemplate(project, file, projectId, null, null, interactive);
    }

    public static void runOrApplyMavenProjectFileTemplate(Project project, VirtualFile file, @NotNull MavenId projectId, MavenId parentId, VirtualFile parentFile, boolean interactive) throws IOException {
        if (projectId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/maven/utils/MavenUtil", "runOrApplyMavenProjectFileTemplate"));
        }
        Properties properties = new Properties();
        Properties conditions = new Properties();
        properties.setProperty("GROUP_ID", projectId.getGroupId());
        properties.setProperty("ARTIFACT_ID", projectId.getArtifactId());
        properties.setProperty("VERSION", projectId.getVersion());
        if (parentId != null) {
            conditions.setProperty("HAS_PARENT", "true");
            properties.setProperty("PARENT_GROUP_ID", parentId.getGroupId());
            properties.setProperty("PARENT_ARTIFACT_ID", parentId.getArtifactId());
            properties.setProperty("PARENT_VERSION", parentId.getVersion());
            if (parentFile != null) {
                String relativePath;
                VirtualFile modulePath = file.getParent();
                VirtualFile parentModulePath = parentFile.getParent();
                if (!Comparing.equal((Object)modulePath.getParent(), (Object)parentModulePath) && (relativePath = VfsUtil.getPath((VirtualFile)file, (VirtualFile)parentModulePath, (char)'/')) != null) {
                    if (relativePath.endsWith("/")) {
                        relativePath = relativePath.substring(0, relativePath.length() - 1);
                    }
                    conditions.setProperty("HAS_RELATIVE_PATH", "true");
                    properties.setProperty("PARENT_RELATIVE_PATH", relativePath);
                }
            }
        }
        MavenUtil.runOrApplyFileTemplate(project, file, "Maven Project.xml", properties, conditions, interactive);
    }

    public static void runFileTemplate(Project project, VirtualFile file, String templateName) throws IOException {
        MavenUtil.runOrApplyFileTemplate(project, file, templateName, new Properties(), new Properties(), true);
    }

    private static void runOrApplyFileTemplate(Project project, VirtualFile file, String templateName, Properties properties, Properties conditions, boolean interactive) throws IOException {
        FileTemplateManager manager = FileTemplateManager.getInstance();
        FileTemplate fileTemplate = manager.getJ2eeTemplate(templateName);
        Properties allProperties = manager.getDefaultProperties(project);
        if (!interactive) {
            allProperties.putAll((Map<?, ?>)properties);
        }
        allProperties.putAll((Map<?, ?>)conditions);
        String text = fileTemplate.getText(allProperties);
        Pattern pattern = Pattern.compile("\\$\\{(.*)\\}");
        Matcher matcher = pattern.matcher(text);
        StringBuffer builder = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(builder, "\\$" + matcher.group(1).toUpperCase() + "\\$");
        }
        matcher.appendTail(builder);
        text = builder.toString();
        TemplateImpl template = (TemplateImpl)TemplateManager.getInstance((Project)project).createTemplate("", "", text);
        for (int i = 0; i < template.getSegmentsCount(); ++i) {
            if (i == template.getEndSegmentNumber()) continue;
            String name = template.getSegmentName(i);
            String value = "\"" + properties.getProperty(name, "") + "\"";
            template.addVariable(name, value, value, true);
        }
        if (interactive) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file);
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
            editor.getDocument().setText((CharSequence)"");
            TemplateManager.getInstance((Project)project).startTemplate(editor, (Template)template);
        } else {
            VfsUtil.saveText((VirtualFile)file, (String)template.getTemplateText());
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile != null) {
                new ReformatCodeProcessor(project, psiFile, null, false).run();
            }
        }
    }

    public static <T extends Collection<Pattern>> T collectPattern(String text, T result) {
        String antPattern = FileUtil.convertAntToRegexp((String)text.trim());
        try {
            result.add((Pattern)Pattern.compile(antPattern));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isIncluded(String relativeName, List<Pattern> includes, List<Pattern> excludes) {
        boolean result = false;
        for (Pattern each : includes) {
            if (!each.matcher(relativeName).matches()) continue;
            result = true;
            break;
        }
        if (!result) {
            return false;
        }
        for (Pattern each : excludes) {
            if (!each.matcher(relativeName).matches()) continue;
            return false;
        }
        return true;
    }

    public static void run(Project project, String title, final MavenTask task) throws MavenProcessCanceledException {
        final Exception[] canceledEx = new Exception[1];
        final RuntimeException[] runtimeEx = new RuntimeException[1];
        final Error[] errorEx = new Error[1];
        ProgressManager.getInstance().run((Task)new Task.Modal(project, title, true){

            public void run(@NotNull ProgressIndicator i) {
                if (i == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/utils/MavenUtil$5", "run"));
                }
                try {
                    task.run(new MavenProgressIndicator(i));
                }
                catch (MavenProcessCanceledException e) {
                    canceledEx[0] = e;
                }
                catch (ProcessCanceledException e) {
                    canceledEx[0] = e;
                }
                catch (RuntimeException e) {
                    runtimeEx[0] = e;
                }
                catch (Error e) {
                    errorEx[0] = e;
                }
            }
        });
        if (canceledEx[0] instanceof MavenProcessCanceledException) {
            throw (MavenProcessCanceledException)canceledEx[0];
        }
        if (canceledEx[0] instanceof ProcessCanceledException) {
            throw new MavenProcessCanceledException();
        }
        if (runtimeEx[0] != null) {
            throw runtimeEx[0];
        }
        if (errorEx[0] != null) {
            throw errorEx[0];
        }
    }

    public static MavenTaskHandler runInBackground(final Project project, final String title, final boolean cancellable, final MavenTask task) {
        final MavenProgressIndicator indicator = new MavenProgressIndicator();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                try {
                    task.run(indicator);
                }
                catch (MavenProcessCanceledException ignore) {
                    indicator.cancel();
                }
                catch (ProcessCanceledException ignore) {
                    indicator.cancel();
                }
            }
        };
        if (MavenUtil.isNoBackgroundMode()) {
            runnable.run();
            return new MavenTaskHandler(){

                @Override
                public void waitFor() {
                }
            };
        }
        final Future future = ApplicationManager.getApplication().executeOnPooledThread(runnable);
        final MavenTaskHandler handler = new MavenTaskHandler(){

            @Override
            public void waitFor() {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    MavenLog.LOG.error((Throwable)e);
                }
                catch (ExecutionException e) {
                    MavenLog.LOG.error((Throwable)e);
                }
            }
        };
        MavenUtil.invokeLater(project, new Runnable(){

            @Override
            public void run() {
                if (future.isDone()) {
                    return;
                }
                new Task.Backgroundable(project, title, cancellable){

                    public void run(@NotNull ProgressIndicator i) {
                        if (i == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/utils/MavenUtil$9$1", "run"));
                        }
                        indicator.setIndicator(i);
                        handler.waitFor();
                    }
                }.queue();
            }
        });
        return handler;
    }

    @Nullable
    public static File resolveMavenHomeDirectory(@Nullable String overrideMavenHome) {
        File home;
        File underUserHome;
        File mavenHomeFile;
        File homeFromEnv;
        if (!MavenUtil.isEmptyOrSpaces(overrideMavenHome)) {
            return new File(overrideMavenHome);
        }
        String m2home = System.getenv(ENV_M2_HOME);
        if (!MavenUtil.isEmptyOrSpaces(m2home) && MavenUtil.isValidMavenHome(homeFromEnv = new File(m2home))) {
            return homeFromEnv;
        }
        String mavenHome = System.getenv("MAVEN_HOME");
        if (!MavenUtil.isEmptyOrSpaces(mavenHome) && MavenUtil.isValidMavenHome(mavenHomeFile = new File(mavenHome))) {
            return mavenHomeFile;
        }
        String userHome = SystemProperties.getUserHome();
        if (!MavenUtil.isEmptyOrSpaces(userHome) && MavenUtil.isValidMavenHome(underUserHome = new File(userHome, M2_DIR))) {
            return underUserHome;
        }
        if (SystemInfo.isMac) {
            home = MavenUtil.fromBrew();
            if (home != null) {
                return home;
            }
            home = MavenUtil.fromMacSystemJavaTools();
            if (home != null) {
                return home;
            }
        } else if (SystemInfo.isLinux) {
            home = new File("/usr/share/maven");
            if (MavenUtil.isValidMavenHome(home)) {
                return home;
            }
            home = new File("/usr/share/maven2");
            if (MavenUtil.isValidMavenHome(home)) {
                return home;
            }
        }
        return null;
    }

    @Nullable
    private static File fromMacSystemJavaTools() {
        File file;
        File symlinkDir = new File("/usr/share/maven");
        if (MavenUtil.isValidMavenHome(symlinkDir)) {
            return symlinkDir;
        }
        File dir = new File("/usr/share/java");
        String[] list = dir.list();
        if (list == null || list.length == 0) {
            return null;
        }
        String home = null;
        String prefix = "maven-";
        int versionIndex = "maven-".length();
        for (String path : list) {
            if (!path.startsWith("maven-") || home != null && StringUtil.compareVersionNumbers((String)path.substring(versionIndex), (String)home.substring(versionIndex)) <= 0) continue;
            home = path;
        }
        if (home != null && MavenUtil.isValidMavenHome(file = new File(dir, home))) {
            return file;
        }
        return null;
    }

    @Nullable
    private static File fromBrew() {
        File file;
        File brewDir = new File("/usr/local/Cellar/maven");
        String[] list = brewDir.list();
        if (list == null || list.length == 0) {
            return null;
        }
        if (list.length > 1) {
            Arrays.sort(list, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return StringUtil.compareVersionNumbers((String)o2, (String)o1);
                }
            });
        }
        return MavenUtil.isValidMavenHome(file = new File(brewDir, list[0] + "/libexec")) ? file : null;
    }

    public static boolean isEmptyOrSpaces(@Nullable String str) {
        return str == null || str.length() == 0 || str.trim().length() == 0;
    }

    public static boolean isValidMavenHome(File home) {
        return MavenUtil.getMavenConfFile(home).exists();
    }

    public static File getMavenConfFile(File mavenHome) {
        return new File(new File(mavenHome, BIN_DIR), M2_CONF_FILE);
    }

    @Nullable
    public static String getMavenVersion(String mavenHome) {
        String[] libs = new File(mavenHome, LIB_DIR).list();
        if (libs != null) {
            for (String lib : libs) {
                if (!lib.startsWith("maven-core-") || !lib.endsWith(".jar")) continue;
                return lib.substring("maven-core-".length(), lib.length() - ".jar".length());
            }
        }
        return null;
    }

    public static boolean isMaven3(String mavenHome) {
        String version = MavenUtil.getMavenVersion(mavenHome);
        return version != null && version.compareTo("3.0.0") >= 0;
    }

    @Nullable
    public static File resolveGlobalSettingsFile(@Nullable String overriddenMavenHome) {
        File directory = MavenUtil.resolveMavenHomeDirectory(overriddenMavenHome);
        if (directory == null) {
            return null;
        }
        return new File(new File(directory, CONF_DIR), SETTINGS_XML);
    }

    @NotNull
    public static File resolveUserSettingsFile(@Nullable String overriddenUserSettingsFile) {
        if (!MavenUtil.isEmptyOrSpaces(overriddenUserSettingsFile)) {
            File file = new File(overriddenUserSettingsFile);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/MavenUtil", "resolveUserSettingsFile"));
            }
            return file;
        }
        File file = new File(MavenUtil.resolveM2Dir(), SETTINGS_XML);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/MavenUtil", "resolveUserSettingsFile"));
        }
        return file;
    }

    @NotNull
    public static File resolveM2Dir() {
        File file = new File(SystemProperties.getUserHome(), DOT_M2_DIR);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/MavenUtil", "resolveM2Dir"));
        }
        return file;
    }

    @NotNull
    public static File resolveLocalRepository(@Nullable String overriddenLocalRepository, @Nullable String overriddenMavenHome, @Nullable String overriddenUserSettingsFile) {
        File file;
        File result = null;
        if (!MavenUtil.isEmptyOrSpaces(overriddenLocalRepository)) {
            result = new File(overriddenLocalRepository);
        }
        if (result == null) {
            result = MavenUtil.doResolveLocalRepository(MavenUtil.resolveUserSettingsFile(overriddenUserSettingsFile), MavenUtil.resolveGlobalSettingsFile(overriddenMavenHome));
        }
        try {
            file = result.getCanonicalFile();
        }
        catch (IOException e) {
            File file2 = result;
            if (file2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/MavenUtil", "resolveLocalRepository"));
            }
            return file2;
        }
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/MavenUtil", "resolveLocalRepository"));
        }
        return file;
    }

    @NotNull
    public static File doResolveLocalRepository(@Nullable File userSettingsFile, @Nullable File globalSettingsFile) {
        String fromGlobalSettings;
        String fromUserSettings;
        if (userSettingsFile != null && !StringUtil.isEmpty((String)(fromUserSettings = MavenUtil.getRepositoryFromSettings(userSettingsFile)))) {
            File file = new File(fromUserSettings);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/MavenUtil", "doResolveLocalRepository"));
            }
            return file;
        }
        if (globalSettingsFile != null && !StringUtil.isEmpty((String)(fromGlobalSettings = MavenUtil.getRepositoryFromSettings(globalSettingsFile)))) {
            File file = new File(fromGlobalSettings);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/MavenUtil", "doResolveLocalRepository"));
            }
            return file;
        }
        File file = new File(MavenUtil.resolveM2Dir(), REPOSITORY_DIR);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/MavenUtil", "doResolveLocalRepository"));
        }
        return file;
    }

    @Nullable
    public static String getRepositoryFromSettings(File file) {
        try {
            byte[] bytes = FileUtil.loadFileBytes((File)file);
            return MavenUtil.expandProperties(MavenJDOMUtil.findChildValueByPath(MavenJDOMUtil.read(bytes, null), "localRepository", null));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String expandProperties(String text) {
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return text;
        }
        Properties props = MavenServerUtil.collectSystemProperties();
        for (Map.Entry<Object, Object> each : props.entrySet()) {
            Object val = each.getValue();
            text = text.replace("${" + each.getKey() + "}", val instanceof CharSequence ? (CharSequence)val : val.toString());
        }
        return text;
    }

    @NotNull
    public static VirtualFile resolveSuperPomFile(@Nullable File mavenHome) {
        VirtualFile result = null;
        if (mavenHome != null) {
            result = MavenUtil.doResolveSuperPomFile(new File(mavenHome, LIB_DIR));
        }
        if (result == null) {
            result = MavenUtil.doResolveSuperPomFile(MavenServerManager.getMavenLibDirectory());
            assert (result != null) : "Super pom not found in: " + MavenServerManager.getMavenLibDirectory();
        }
        VirtualFile virtualFile = result;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/MavenUtil", "resolveSuperPomFile"));
        }
        return virtualFile;
    }

    @Nullable
    public static VirtualFile doResolveSuperPomFile(@NotNull File mavenHome) {
        if (mavenHome == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/utils/MavenUtil", "doResolveSuperPomFile"));
        }
        File[] files = mavenHome.listFiles();
        if (files == null) {
            return null;
        }
        for (File library : files) {
            for (Pair<Pattern, String> path : SUPER_POM_PATHS) {
                VirtualFile pomFile;
                VirtualFile root;
                VirtualFile libraryVirtualFile;
                if (!((Pattern)path.first).matcher(library.getName()).matches() || (libraryVirtualFile = LocalFileSystem.getInstance().findFileByIoFile(library)) == null || (root = JarFileSystem.getInstance().getJarRootForLocalFile(libraryVirtualFile)) == null || (pomFile = root.findFileByRelativePath((String)path.second)) == null) continue;
                return pomFile;
            }
        }
        return null;
    }

    public static List<LookupElement> getPhaseVariants(MavenProjectsManager manager) {
        HashSet<String> goals = new HashSet<String>();
        goals.addAll(MavenConstants.PHASES);
        for (MavenProject mavenProject : manager.getProjects()) {
            for (MavenPlugin plugin : mavenProject.getPlugins()) {
                MavenPluginInfo pluginInfo = MavenArtifactUtil.readPluginInfo(manager.getLocalRepository(), plugin.getMavenId());
                if (pluginInfo == null) continue;
                for (MavenPluginInfo.Mojo mojo : pluginInfo.getMojos()) {
                    goals.add(mojo.getDisplayName());
                }
            }
        }
        ArrayList<LookupElement> res = new ArrayList<LookupElement>(goals.size());
        for (String goal : goals) {
            res.add((LookupElement)LookupElementBuilder.create((String)goal).withIcon(MavenIcons.Phase));
        }
        return res;
    }

    public static int crcWithoutSpaces(@NotNull InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/utils/MavenUtil", "crcWithoutSpaces"));
        }
        try {
            final CRC32 crc = new CRC32();
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(in, new DefaultHandler(){
                boolean textContentOccur = false;
                int spacesCrc;

                private void putString(@Nullable String string) {
                    if (string == null) {
                        return;
                    }
                    int end = string.length();
                    for (int i = 0; i < end; ++i) {
                        crc.update(string.charAt(i));
                    }
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    this.textContentOccur = false;
                    crc.update(1);
                    this.putString(qName);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        this.putString(attributes.getQName(i));
                        this.putString(attributes.getValue(i));
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    this.textContentOccur = false;
                    crc.update(2);
                    this.putString(qName);
                }

                private void processTextOrSpaces(char[] ch, int start, int length) {
                    int end = start + length;
                    for (int i = start; i < end; ++i) {
                        char a = ch[i];
                        if (Character.isWhitespace(a)) {
                            if (!this.textContentOccur) continue;
                            this.spacesCrc = this.spacesCrc * 31 + a;
                            continue;
                        }
                        if (this.textContentOccur && this.spacesCrc != 0) {
                            crc.update(this.spacesCrc);
                            crc.update(this.spacesCrc >> 8);
                        }
                        crc.update(a);
                        this.textContentOccur = true;
                        this.spacesCrc = 0;
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    this.processTextOrSpaces(ch, start, length);
                }

                @Override
                public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
                    this.processTextOrSpaces(ch, start, length);
                }

                @Override
                public void processingInstruction(String target, String data) throws SAXException {
                    this.putString(target);
                    this.putString(data);
                }

                @Override
                public void skippedEntity(String name) throws SAXException {
                    this.putString(name);
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    crc.update(100);
                }
            });
            return (int)crc.getValue();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int crcWithoutSpaces(@NotNull VirtualFile xmlFile) throws IOException {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/utils/MavenUtil", "crcWithoutSpaces"));
        }
        InputStream inputStream = xmlFile.getInputStream();
        try {
            int n = MavenUtil.crcWithoutSpaces(inputStream);
            return n;
        }
        finally {
            inputStream.close();
        }
    }

    public static String getSdkPath(@Nullable Sdk sdk) {
        VirtualFile jreDir;
        if (sdk == null) {
            return null;
        }
        VirtualFile homeDirectory = sdk.getHomeDirectory();
        if (homeDirectory == null) {
            return null;
        }
        if (!"jre".equals(homeDirectory.getName()) && (jreDir = homeDirectory.findChild("jre")) != null) {
            homeDirectory = jreDir;
        }
        return homeDirectory.getPath();
    }

    @Nullable
    public static String getModuleJreHome(@NotNull MavenProjectsManager mavenProjectsManager, @NotNull MavenProject mavenProject) {
        if (mavenProjectsManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/utils/MavenUtil", "getModuleJreHome"));
        }
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/utils/MavenUtil", "getModuleJreHome"));
        }
        return MavenUtil.getSdkPath(MavenUtil.getModuleJdk(mavenProjectsManager, mavenProject));
    }

    @Nullable
    public static String getModuleJavaVersion(@NotNull MavenProjectsManager mavenProjectsManager, @NotNull MavenProject mavenProject) {
        if (mavenProjectsManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/utils/MavenUtil", "getModuleJavaVersion"));
        }
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/utils/MavenUtil", "getModuleJavaVersion"));
        }
        Sdk sdk = MavenUtil.getModuleJdk(mavenProjectsManager, mavenProject);
        if (sdk == null) {
            return null;
        }
        return sdk.getVersionString();
    }

    @Nullable
    public static Sdk getModuleJdk(@NotNull MavenProjectsManager mavenProjectsManager, @NotNull MavenProject mavenProject) {
        if (mavenProjectsManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/utils/MavenUtil", "getModuleJdk"));
        }
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/utils/MavenUtil", "getModuleJdk"));
        }
        Module module = mavenProjectsManager.findModule(mavenProject);
        if (module == null) {
            return null;
        }
        return ModuleRootManager.getInstance((Module)module).getSdk();
    }

    @NotNull
    public static <K, V extends Map> V getOrCreate(Map map, K key) {
        HashMap res = (HashMap)map.get(key);
        if (res == null) {
            res = new HashMap();
            map.put(key, res);
        }
        HashMap hashMap = res;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/MavenUtil", "getOrCreate"));
        }
        return (V)hashMap;
    }

    public static String getArtifactName(String packaging, Module module, boolean exploded) {
        return module.getName() + ":" + packaging + (exploded ? " exploded" : "");
    }

    public static String getEjbClientArtifactName(Module module) {
        return module.getName() + ":ejb-client";
    }

    public static String getIdeaVersionToPassToMavenProcess() {
        return ApplicationInfoImpl.getShadowInstance().getMajorVersion() + "." + ApplicationInfoImpl.getShadowInstance().getMinorVersion();
    }

    public static interface MavenTaskHandler {
        public void waitFor();
    }
}

