/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashMap;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.tasks.MavenKeymapExtension;
import org.jetbrains.idea.maven.utils.MavenMergingUpdateQueue;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenShortcutsManager
extends MavenSimpleProjectComponent {
    private static final String ACTION_ID_PREFIX = "Maven_";
    private final AtomicBoolean isInitialized = new AtomicBoolean();
    private final MavenProjectsManager myProjectsManager;
    private MyKeymapListener myKeymapListener;
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    @NotNull
    public static MavenShortcutsManager getInstance(Project project) {
        MavenShortcutsManager mavenShortcutsManager = (MavenShortcutsManager)((Object)project.getComponent(MavenShortcutsManager.class));
        if (mavenShortcutsManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/tasks/MavenShortcutsManager", "getInstance"));
        }
        return mavenShortcutsManager;
    }

    public MavenShortcutsManager(Project project, MavenProjectsManager projectsManager, MavenRunner runner) {
        super(project);
        this.myProjectsManager = projectsManager;
    }

    public void initComponent() {
        if (!this.isNormalProject()) {
            return;
        }
        MavenUtil.runWhenInitialized(this.myProject, (Runnable)new DumbAwareRunnable(){

            public void run() {
                MavenShortcutsManager.this.doInit();
            }
        });
    }

    public void doInit() {
        if (this.isInitialized.getAndSet(true)) {
            return;
        }
        MyProjectsTreeListener listener = new MyProjectsTreeListener();
        this.myProjectsManager.addManagerListener(listener);
        this.myProjectsManager.addProjectsTreeListener(listener);
        this.myKeymapListener = new MyKeymapListener();
    }

    public void disposeComponent() {
        if (!this.isInitialized.getAndSet(false)) {
            return;
        }
        this.myKeymapListener.stopListen();
        MavenKeymapExtension.clearActions(this.myProject);
    }

    public String getActionId(@Nullable String projectPath, @Nullable String goal) {
        StringBuilder result = new StringBuilder(ACTION_ID_PREFIX);
        result.append(this.myProject.getLocationHash());
        if (projectPath != null) {
            String portablePath = FileUtil.toSystemIndependentName((String)projectPath);
            result.append(new File(portablePath).getParentFile().getName());
            result.append(Integer.toHexString(portablePath.hashCode()));
            if (goal != null) {
                result.append(goal);
            }
        }
        return result.toString();
    }

    public String getDescription(MavenProject project, String goal) {
        String actionId = this.getActionId(project.getPath(), goal);
        if (actionId == null) {
            return "";
        }
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = activeKeymap.getShortcuts(actionId);
        if (shortcuts == null || shortcuts.length == 0) {
            return "";
        }
        return KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
    }

    private void fireShortcutsUpdated() {
        for (Listener listener : this.myListeners) {
            listener.shortcutsUpdated();
        }
    }

    public void addListener(Listener listener) {
        this.myListeners.add(listener);
    }

    static /* synthetic */ Project access$200(MavenShortcutsManager x0) {
        return x0.myProject;
    }

    private class MyProjectsTreeListener
    extends MavenProjectsTree.ListenerAdapter
    implements MavenProjectsManager.Listener {
        private final Map<MavenProject, Boolean> mySheduledProjects = new THashMap();
        private final MergingUpdateQueue myUpdateQueue = new MavenMergingUpdateQueue(MavenShortcutsManager.this.getComponentName() + ": Keymap Update", 500, true, (Disposable)MavenShortcutsManager.access$200(MavenShortcutsManager.this));

        private MyProjectsTreeListener() {
        }

        @Override
        public void activated() {
            this.scheduleKeymapUpdate(MavenShortcutsManager.this.myProjectsManager.getNonIgnoredProjects(), true);
        }

        @Override
        public void projectsScheduled() {
        }

        @Override
        public void importAndResolveScheduled() {
        }

        @Override
        public void projectsIgnoredStateChanged(List<MavenProject> ignored, List<MavenProject> unignored, boolean fromImport) {
            this.scheduleKeymapUpdate(unignored, true);
            this.scheduleKeymapUpdate(ignored, false);
        }

        @Override
        public void projectsUpdated(List<Pair<MavenProject, MavenProjectChanges>> updated, List<MavenProject> deleted) {
            this.scheduleKeymapUpdate(MavenUtil.collectFirsts(updated), true);
            this.scheduleKeymapUpdate(deleted, false);
        }

        @Override
        public void projectResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, NativeMavenProjectHolder nativeMavenProject) {
            this.scheduleKeymapUpdate(Collections.singletonList(projectWithChanges.first), true);
        }

        @Override
        public void pluginsResolved(MavenProject project) {
            this.scheduleKeymapUpdate(Collections.singletonList(project), true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleKeymapUpdate(List<MavenProject> mavenProjects, boolean forUpdate) {
            Map<MavenProject, Boolean> map = this.mySheduledProjects;
            synchronized (map) {
                for (MavenProject each : mavenProjects) {
                    this.mySheduledProjects.put(each, forUpdate);
                }
            }
            this.myUpdateQueue.queue(new Update((Object)MavenShortcutsManager.this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    List projectToDelete;
                    List projectToUpdate;
                    Map map = MyProjectsTreeListener.this.mySheduledProjects;
                    synchronized (map) {
                        projectToUpdate = MyProjectsTreeListener.this.selectScheduledProjects(true);
                        projectToDelete = MyProjectsTreeListener.this.selectScheduledProjects(false);
                        MyProjectsTreeListener.this.mySheduledProjects.clear();
                    }
                    MavenKeymapExtension.clearActions(MavenShortcutsManager.this.myProject, projectToDelete);
                    MavenKeymapExtension.updateActions(MavenShortcutsManager.this.myProject, projectToUpdate);
                }
            });
        }

        private List<MavenProject> selectScheduledProjects(final boolean forUpdate) {
            return ContainerUtil.mapNotNull(this.mySheduledProjects.entrySet(), (Function)new Function<Map.Entry<MavenProject, Boolean>, MavenProject>(){

                public MavenProject fun(Map.Entry<MavenProject, Boolean> eachEntry) {
                    return forUpdate == eachEntry.getValue() ? eachEntry.getKey() : null;
                }
            });
        }
    }

    private class MyKeymapListener
    implements KeymapManagerListener,
    Keymap.Listener {
        private Keymap myCurrentKeymap = null;

        public MyKeymapListener() {
            KeymapManager keymapManager = KeymapManager.getInstance();
            this.listenTo(keymapManager.getActiveKeymap());
            keymapManager.addKeymapManagerListener((KeymapManagerListener)this);
        }

        public void activeKeymapChanged(Keymap keymap) {
            this.listenTo(keymap);
            MavenShortcutsManager.this.fireShortcutsUpdated();
        }

        private void listenTo(Keymap keymap) {
            if (this.myCurrentKeymap != null) {
                this.myCurrentKeymap.removeShortcutChangeListener((Keymap.Listener)this);
            }
            this.myCurrentKeymap = keymap;
            if (this.myCurrentKeymap != null) {
                this.myCurrentKeymap.addShortcutChangeListener((Keymap.Listener)this);
            }
        }

        public void onShortcutChanged(String actionId) {
            MavenShortcutsManager.this.fireShortcutsUpdated();
        }

        public void stopListen() {
            this.listenTo(null);
            KeymapManagerEx.getInstanceEx().removeKeymapManagerListener((KeymapManagerListener)this);
        }
    }

    public static interface Listener {
        public void shortcutsUpdated();
    }
}

