/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorBasicTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public class MavenProjectsProcessorResolvingTask
extends MavenProjectsProcessorBasicTask {
    @NotNull
    private final MavenGeneralSettings myGeneralSettings;
    @Nullable
    private final Runnable myOnCompletion;
    @NotNull
    private final ResolveContext myContext;

    public MavenProjectsProcessorResolvingTask(@NotNull MavenProject project, @NotNull MavenProjectsTree tree, @NotNull MavenGeneralSettings generalSettings, @Nullable Runnable onCompletion, @NotNull ResolveContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/project/MavenProjectsProcessorResolvingTask", "<init>"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/project/MavenProjectsProcessorResolvingTask", "<init>"));
        }
        if (generalSettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/maven/project/MavenProjectsProcessorResolvingTask", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/idea/maven/project/MavenProjectsProcessorResolvingTask", "<init>"));
        }
        super(project, tree);
        this.myGeneralSettings = generalSettings;
        this.myOnCompletion = onCompletion;
        this.myContext = context;
    }

    @Override
    public void perform(Project project, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        this.myTree.resolve(project, this.myMavenProject, this.myGeneralSettings, embeddersManager, console, this.myContext, indicator);
        if (this.myOnCompletion != null) {
            this.myOnCompletion.run();
        }
    }
}

