/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenId;

public class MavenParentDesc {
    private final MavenId myParentId;
    private final String myParentRelativePath;

    public MavenParentDesc(@NotNull MavenId parentId, @NotNull String parentRelativePath) {
        if (parentId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/project/MavenParentDesc", "<init>"));
        }
        if (parentRelativePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/project/MavenParentDesc", "<init>"));
        }
        this.myParentId = parentId;
        this.myParentRelativePath = parentRelativePath;
    }

    @NotNull
    public MavenId getParentId() {
        MavenId mavenId = this.myParentId;
        if (mavenId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenParentDesc", "getParentId"));
        }
        return mavenId;
    }

    @NotNull
    public String getParentRelativePath() {
        String string = this.myParentRelativePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenParentDesc", "getParentRelativePath"));
        }
        return string;
    }
}

