/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.plugins.api.common;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ProcessingContext;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.model.MavenDomConfiguration;
import org.jetbrains.idea.maven.dom.references.MavenDependencyReferenceProvider;
import org.jetbrains.idea.maven.dom.references.MavenPathReferenceConverter;
import org.jetbrains.idea.maven.plugins.api.MavenCompletionReferenceProvider;
import org.jetbrains.idea.maven.plugins.api.MavenParamReferenceProvider;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenCommonParamReferenceProviders {
    private MavenCommonParamReferenceProviders() {
    }

    public static class Profile
    extends MavenCompletionReferenceProvider {
        @Override
        protected Object[] getVariants(@NotNull PsiReferenceBase reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/plugins/api/common/MavenCommonParamReferenceProviders$Profile", "getVariants"));
            }
            return MavenProjectsManager.getInstance(reference.getElement().getProject()).getAvailableProfiles().toArray();
        }
    }

    public static class Goal
    extends MavenCompletionReferenceProvider {
        @Override
        protected Object[] getVariants(@NotNull PsiReferenceBase reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/plugins/api/common/MavenCommonParamReferenceProviders$Goal", "getVariants"));
            }
            return MavenUtil.getPhaseVariants(MavenProjectsManager.getInstance(reference.getElement().getProject())).toArray();
        }
    }

    public static class Encoding
    extends MavenCompletionReferenceProvider {
        @Override
        protected Object[] getVariants(@NotNull PsiReferenceBase reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/plugins/api/common/MavenCommonParamReferenceProviders$Encoding", "getVariants"));
            }
            Charset[] charsets = CharsetToolkit.getAvailableCharsets();
            Object[] res = new LookupElement[charsets.length];
            for (int i = 0; i < charsets.length; ++i) {
                res[i] = LookupElementBuilder.create((String)charsets[i].name()).withCaseSensitivity(false);
            }
            return res;
        }
    }

    public static class DependencyWithoutVersion
    extends MavenDependencyReferenceProvider {
        public DependencyWithoutVersion() {
            this.setCanHasVersion(false);
        }
    }

    public static class DirPath
    implements MavenParamReferenceProvider {
        @Override
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull MavenDomConfiguration domCfg, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/plugins/api/common/MavenCommonParamReferenceProviders$DirPath", "getReferencesByElement"));
            }
            if (domCfg == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/plugins/api/common/MavenCommonParamReferenceProviders$DirPath", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/maven/plugins/api/common/MavenCommonParamReferenceProviders$DirPath", "getReferencesByElement"));
            }
            return MavenPathReferenceConverter.createReferences(domCfg, element, (Condition<PsiFileSystemItem>)FileReferenceSet.DIRECTORY_FILTER);
        }
    }

    public static class FilePath
    implements MavenParamReferenceProvider {
        @Override
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull MavenDomConfiguration domCfg, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/plugins/api/common/MavenCommonParamReferenceProviders$FilePath", "getReferencesByElement"));
            }
            if (domCfg == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/plugins/api/common/MavenCommonParamReferenceProviders$FilePath", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/maven/plugins/api/common/MavenCommonParamReferenceProviders$FilePath", "getReferencesByElement"));
            }
            return MavenPathReferenceConverter.createReferences(domCfg, element, (Condition<PsiFileSystemItem>)Condition.TRUE);
        }
    }
}

