/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.actions;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import javax.swing.Icon;
import org.jetbrains.idea.maven.utils.MavenDataKeys;

public class RemoveMavenRunConfigurationAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)MavenDataKeys.RUN_CONFIGURATION.getData(e.getDataContext());
        assert (settings != null && project != null);
        int res = Messages.showYesNoDialog((Project)project, (String)("Delete \"" + settings.getName() + "\"?"), (String)"Confirmation", (Icon)Messages.getQuestionIcon());
        if (res == 0) {
            ((RunManagerEx)RunManager.getInstance((Project)project)).removeConfiguration(settings);
        }
    }

    public void update(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)MavenDataKeys.RUN_CONFIGURATION.getData(e.getDataContext());
        boolean enabled = settings != null && project != null;
        e.getPresentation().setEnabledAndVisible(enabled);
    }
}

