/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.actions;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import org.jetbrains.idea.maven.utils.MavenDataKeys;

public class MavenRunConfigurationMenu
extends DefaultActionGroup
implements DumbAware {
    public void update(AnActionEvent e) {
        for (AnAction action : this.getChildActionsOrStubs()) {
            if (!(action instanceof ExecuteMavenRunConfigurationAction)) continue;
            this.remove(action);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)MavenDataKeys.RUN_CONFIGURATION.getData(e.getDataContext());
        if (settings == null || project == null) {
            return;
        }
        Executor[] executors = ExecutorRegistry.getInstance().getRegisteredExecutors();
        int i = executors.length;
        while (--i >= 0) {
            ProgramRunner runner = RunnerRegistry.getInstance().getRunner(executors[i].getId(), (RunProfile)settings.getConfiguration());
            ExecuteMavenRunConfigurationAction action = new ExecuteMavenRunConfigurationAction(executors[i], runner != null, project, settings);
            this.addAction(action, Constraints.FIRST);
        }
        super.update(e);
    }

    private static class ExecuteMavenRunConfigurationAction
    extends AnAction {
        private final Executor myExecutor;
        private final boolean myEnabled;
        private final Project myProject;
        private final RunnerAndConfigurationSettings mySettings;

        public ExecuteMavenRunConfigurationAction(Executor executor, boolean enabled, Project project, RunnerAndConfigurationSettings settings) {
            super(executor.getActionName(), null, executor.getIcon());
            this.myExecutor = executor;
            this.myEnabled = enabled;
            this.myProject = project;
            this.mySettings = settings;
        }

        public void actionPerformed(AnActionEvent event) {
            if (!this.myEnabled) {
                return;
            }
            ProgramRunnerUtil.executeConfiguration((Project)this.myProject, (RunnerAndConfigurationSettings)this.mySettings, (Executor)this.myExecutor);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(this.myEnabled);
        }
    }
}

