/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.options.CompileStepBeforeRunNoErrorCheck;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.DefaultJavaProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.MavenIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenRunConfigurationType
implements ConfigurationType {
    private final ConfigurationFactory myFactory = new ConfigurationFactory(this){

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new MavenRunConfiguration(project, this, "");
        }

        public RunConfiguration createTemplateConfiguration(Project project, RunManager runManager) {
            return new MavenRunConfiguration(project, this, "");
        }

        public RunConfiguration createConfiguration(String name, RunConfiguration template) {
            MavenRunConfiguration cfg = (MavenRunConfiguration)super.createConfiguration(name, template);
            if (!StringUtil.isEmptyOrSpaces((String)cfg.getRunnerParameters().getWorkingDirPath())) {
                return cfg;
            }
            Project project = cfg.getProject();
            if (project == null) {
                return cfg;
            }
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project);
            List<MavenProject> projects = projectsManager.getProjects();
            if (projects.size() != 1) {
                return cfg;
            }
            VirtualFile directory = projects.get(0).getDirectoryFile();
            cfg.getRunnerParameters().setWorkingDirPath(directory.getPath());
            return cfg;
        }

        public void configureBeforeRunTaskDefaults(Key<? extends BeforeRunTask> providerID, BeforeRunTask task) {
            if (providerID == CompileStepBeforeRun.ID || providerID == CompileStepBeforeRunNoErrorCheck.ID) {
                task.setEnabled(false);
            }
        }
    };
    private static final int MAX_NAME_LENGTH = 40;

    public static MavenRunConfigurationType getInstance() {
        return (MavenRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(MavenRunConfigurationType.class);
    }

    MavenRunConfigurationType() {
    }

    public String getDisplayName() {
        return RunnerBundle.message("maven.run.configuration.name", new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return RunnerBundle.message("maven.run.configuration.description", new Object[0]);
    }

    public Icon getIcon() {
        return MavenIcons.Phase;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    @NonNls
    @NotNull
    public String getId() {
        if ("MavenRunConfiguration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenRunConfigurationType", "getId"));
        }
        return "MavenRunConfiguration";
    }

    public static String generateName(Project project, MavenRunnerParameters runnerParameters) {
        StringBuilder stringBuilder = new StringBuilder();
        String name = MavenRunConfigurationType.getMavenProjectName(project, runnerParameters);
        if (!StringUtil.isEmptyOrSpaces((String)name)) {
            stringBuilder.append(name);
            stringBuilder.append(" ");
        }
        stringBuilder.append("[");
        MavenRunConfigurationType.listGoals(stringBuilder, runnerParameters.getGoals());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static void listGoals(StringBuilder stringBuilder, List<String> goals) {
        int index = 0;
        for (String goal : goals) {
            if (index != 0) {
                if (stringBuilder.length() + goal.length() < 40) {
                    stringBuilder.append(",");
                } else {
                    stringBuilder.append("...");
                    break;
                }
            }
            stringBuilder.append(goal);
            ++index;
        }
    }

    @Nullable
    private static String getMavenProjectName(Project project, MavenRunnerParameters runnerParameters) {
        MavenProject mavenProject;
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(runnerParameters.getWorkingDirPath() + "/pom.xml");
        if (virtualFile != null && (mavenProject = MavenProjectsManager.getInstance(project).findProject(virtualFile)) != null && !StringUtil.isEmptyOrSpaces((String)mavenProject.getMavenId().getArtifactId())) {
            return mavenProject.getMavenId().getArtifactId();
        }
        return null;
    }

    public static void runConfiguration(Project project, MavenRunnerParameters params, @Nullable ProgramRunner.Callback callback) {
        MavenRunConfigurationType.runConfiguration(project, params, null, null, callback);
    }

    public static void runConfiguration(Project project, @NotNull MavenRunnerParameters params, @Nullable MavenGeneralSettings settings, @Nullable MavenRunnerSettings runnerSettings, @Nullable ProgramRunner.Callback callback) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/execution/MavenRunConfigurationType", "runConfiguration"));
        }
        RunnerAndConfigurationSettings configSettings = MavenRunConfigurationType.createRunnerAndConfigurationSettings(settings, runnerSettings, params, project);
        ProgramRunner runner = DefaultJavaProgramRunner.getInstance();
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        ExecutionEnvironment env = new ExecutionEnvironment(executor, runner, configSettings, project);
        try {
            runner.execute(env, callback);
        }
        catch (ExecutionException e) {
            MavenUtil.showError(project, "Failed to execute Maven goal", e);
        }
    }

    public static RunnerAndConfigurationSettings createRunnerAndConfigurationSettings(@Nullable MavenGeneralSettings generalSettings, @Nullable MavenRunnerSettings runnerSettings, MavenRunnerParameters params, Project project) {
        MavenRunConfigurationType type = (MavenRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(MavenRunConfigurationType.class);
        RunnerAndConfigurationSettings settings = RunManagerEx.getInstanceEx((Project)project).createConfiguration(MavenRunConfigurationType.generateName(project, params), type.myFactory);
        MavenRunConfiguration runConfiguration = (MavenRunConfiguration)settings.getConfiguration();
        runConfiguration.setRunnerParameters(params);
        runConfiguration.setGeneralSettings(generalSettings);
        runConfiguration.setRunnerSettings(runnerSettings);
        return settings;
    }
}

