/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import org.jetbrains.idea.maven.server.MavenServerSettings;

public class MavenExecutionOptions {

    public static enum PluginUpdatePolicy {
        UPDATE("Check For Updates", "--check-plugin-updates", MavenServerSettings.UpdatePolicy.ALWAYS_UPDATE),
        DO_NOT_UPDATE("Do Not Update", "--no-plugin-updates", MavenServerSettings.UpdatePolicy.DO_NOT_UPDATE),
        DEFAULT("Default", "", MavenServerSettings.UpdatePolicy.DO_NOT_UPDATE);

        private final String myDisplayString;
        private final String myCommandLineOption;
        private final MavenServerSettings.UpdatePolicy myServerPolicy;

        private PluginUpdatePolicy(String displayString, String commandLineOption, MavenServerSettings.UpdatePolicy policy) {
            this.myDisplayString = displayString;
            this.myCommandLineOption = commandLineOption;
            this.myServerPolicy = policy;
        }

        public String getDisplayString() {
            return this.myDisplayString;
        }

        public String getCommandLineOption() {
            return this.myCommandLineOption;
        }

        public MavenServerSettings.UpdatePolicy getServerPolicy() {
            return this.myServerPolicy;
        }
    }

    public static enum ChecksumPolicy {
        NOT_SET("No Global Policy", ""),
        FAIL("Fail", "--strict-checksums"),
        WARN("Warn", "--lax-checksums");

        private final String myDisplayString;
        private final String myCommandLineOption;

        private ChecksumPolicy(String displayString, String commandLineOption) {
            this.myDisplayString = displayString;
            this.myCommandLineOption = commandLineOption;
        }

        public String getDisplayString() {
            return this.myDisplayString;
        }

        public String getCommandLineOption() {
            return this.myCommandLineOption;
        }
    }

    public static enum FailureMode {
        NOT_SET("Default", ""),
        FAST("Fail Fast", "--fail-fast"),
        AT_END("Fail At End", "--fail-at-end"),
        NEVER("Never Fail", "--fail-never");

        private final String myDisplayString;
        private final String myCommandLineOption;

        private FailureMode(String displayString, String commandLineOption) {
            this.myDisplayString = displayString;
            this.myCommandLineOption = commandLineOption;
        }

        public String getDisplayString() {
            return this.myDisplayString;
        }

        public String getCommandLineOption() {
            return this.myCommandLineOption;
        }
    }

    public static enum LoggingLevel {
        DEBUG("Debug", 0),
        INFO("Info", 1),
        WARN("Warn", 2),
        ERROR("Error", 3),
        FATAL("Fatal", 4),
        DISABLED("Disabled", 5);

        private final String myDisplayString;
        private final int myLevel;

        private LoggingLevel(String displayString, int level) {
            this.myDisplayString = displayString;
            this.myLevel = level;
        }

        public String getDisplayString() {
            return this.myDisplayString;
        }

        public int getLevel() {
            return this.myLevel;
        }
    }
}

