/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenContextlessPropertyReference
extends PsiReferenceBase<PsiElement> {
    private final XmlTag myProperties;

    public MavenContextlessPropertyReference(@NotNull XmlTag properties, @NotNull PsiElement element, @NotNull TextRange range, boolean isSoft) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/dom/references/MavenContextlessPropertyReference", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/dom/references/MavenContextlessPropertyReference", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/maven/dom/references/MavenContextlessPropertyReference", "<init>"));
        }
        super(element, range, isSoft);
        this.myProperties = properties;
    }

    @Nullable
    public PsiElement resolve() {
        String value = this.getValue();
        for (XmlTag subTag : this.myProperties.getSubTags()) {
            if (!value.equals(subTag.getName())) continue;
            return subTag;
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        String skippedPropertyName = null;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlTag.class, (boolean)false);
        if (xmlTag != null && this.myProperties == xmlTag.getParentTag()) {
            skippedPropertyName = xmlTag.getName();
        }
        ArrayList<String> res = new ArrayList<String>();
        for (XmlTag subTag : this.myProperties.getSubTags()) {
            String name = subTag.getName();
            if (name.equals(skippedPropertyName)) continue;
            res.add(name);
        }
        Object[] objectArray = res.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenContextlessPropertyReference", "getVariants"));
        }
        return objectArray;
    }
}

