/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import java.util.Set;
import org.jetbrains.idea.maven.dom.MavenDomProjectModelDescription;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;

public class MavenPomXmlCompletionTagListenerContributor
extends CompletionContributor {
    private final Set<String> myHandledTags = ImmutableSet.of((Object)"dependency");

    public void fillCompletionVariants(CompletionParameters parameters, final CompletionResultSet result) {
        if (TemplateManager.getInstance((Project)parameters.getOriginalFile().getProject()).getActiveTemplate(parameters.getEditor()) != null) {
            return;
        }
        PsiFile psiFile = parameters.getOriginalFile();
        if (!(psiFile instanceof XmlFile)) {
            return;
        }
        if (!MavenDomUtil.isProjectFile(psiFile)) {
            return;
        }
        DomFileDescription description = DomManager.getDomManager((Project)psiFile.getProject()).getDomFileDescription((XmlFile)psiFile);
        if (!(description instanceof MavenDomProjectModelDescription)) {
            return;
        }
        result.runRemainingContributors(parameters, (Consumer)new Consumer<CompletionResult>(){

            public void consume(CompletionResult r) {
                final LookupElement lookupElement = r.getLookupElement();
                if (MavenPomXmlCompletionTagListenerContributor.this.myHandledTags.contains(lookupElement.getLookupString())) {
                    LookupElementDecorator decorator = LookupElementDecorator.withInsertHandler((LookupElement)lookupElement, (InsertHandler)new InsertHandler<LookupElementDecorator<LookupElement>>(){

                        public void handleInsert(InsertionContext context, LookupElementDecorator<LookupElement> item) {
                            lookupElement.handleInsert(context);
                            Object object = lookupElement.getObject();
                            if ("dependency".equals(lookupElement.getLookupString()) && object instanceof XmlTag && "maven-4.0.0.xsd".equals(((XmlTag)object).getContainingFile().getName())) {
                                DomElement domElement;
                                context.commitDocument();
                                CaretModel caretModel = context.getEditor().getCaretModel();
                                PsiElement psiElement = context.getFile().findElementAt(caretModel.getOffset());
                                XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class);
                                if (xmlTag != null && (domElement = DomManager.getDomManager((Project)context.getProject()).getDomElement(xmlTag)) instanceof MavenDomDependency) {
                                    String s = "\n<groupId></groupId>\n<artifactId></artifactId>\n";
                                    context.getDocument().insertString(caretModel.getOffset(), (CharSequence)s);
                                    caretModel.moveToOffset(caretModel.getOffset() + s.length() - "</artifactId>\n".length());
                                    context.commitDocument();
                                    new ReformatCodeProcessor(context.getProject(), context.getFile(), xmlTag.getTextRange(), true).run();
                                    MavenDependencyCompletionUtil.invokeCompletion(context, CompletionType.BASIC);
                                }
                            }
                        }
                    });
                    r = r.withLookupElement((LookupElement)decorator);
                }
                result.passResult(r);
            }
        });
    }
}

