/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.trans.XPathException;
import org.intellij.plugins.xsltDebugger.rt.engine.local.OutputEventQueueImpl;

final class TracingOutputter
extends Emitter {
    private final OutputEventQueueImpl myEventQueue;
    private final Emitter myEmitter;

    public TracingOutputter(OutputEventQueueImpl queue, Emitter emitter) {
        this.myEmitter = emitter;
        this.myEventQueue = queue;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.myEmitter.setPipelineConfiguration(pipe);
    }

    public void setSystemId(String systemId) {
        this.myEmitter.setSystemId(systemId);
    }

    public void setOutputProperties(Properties details) throws XPathException {
        this.myEmitter.setOutputProperties(details);
    }

    public void setStreamResult(StreamResult result) throws XPathException {
        this.myEmitter.setStreamResult(result);
    }

    public void setWriter(Writer writer) throws XPathException {
        this.myEmitter.setWriter(writer);
    }

    public void setOutputStream(OutputStream stream) throws XPathException {
        this.myEmitter.setOutputStream(stream);
    }

    public void setUnparsedEntity(String name, String uri, String publicId) throws XPathException {
        this.myEmitter.setUnparsedEntity(name, uri, publicId);
    }

    public void open() throws XPathException {
        this.myEmitter.open();
    }

    public void startDocument(int properties) throws XPathException {
        this.myEmitter.startDocument(properties);
    }

    public void endDocument() throws XPathException {
        this.myEmitter.endDocument();
    }

    public void namespace(int namespaceCode, int properties) throws XPathException {
        this.myEmitter.namespace(namespaceCode, properties);
    }

    public void close() throws XPathException {
        this.myEmitter.close();
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        if (this.myEventQueue.isEnabled()) {
            String localName = this.namePool.getLocalName(nameCode);
            String prefix = this.namePool.getPrefix(nameCode);
            this.myEventQueue.startElement(prefix, localName, this.namePool.getURI(nameCode));
        }
        this.myEmitter.startElement(nameCode, typeCode, locationId, properties);
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.myEventQueue.isEnabled()) {
            String localName = this.namePool.getLocalName(nameCode);
            String prefix = this.namePool.getPrefix(nameCode);
            this.myEventQueue.attribute(prefix, localName, this.namePool.getURI(nameCode), ((Object)value).toString());
        }
        this.myEmitter.attribute(nameCode, typeCode, value, locationId, properties);
    }

    public void startContent() throws XPathException {
    }

    public void endElement() throws XPathException {
        this.myEventQueue.endElement();
        this.myEmitter.endElement();
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        this.myEventQueue.characters(((Object)chars).toString());
        this.myEmitter.characters(chars, locationId, properties);
    }

    public void processingInstruction(String name, CharSequence data, int locationId, int properties) throws XPathException {
        this.myEventQueue.pi(name, ((Object)data).toString());
        this.myEmitter.processingInstruction(name, data, locationId, properties);
    }

    public void comment(CharSequence content, int locationId, int properties) throws XPathException {
        this.myEventQueue.comment(((Object)content).toString());
        this.myEmitter.comment(content, locationId, properties);
    }

    public boolean usesTypeAnnotations() {
        return false;
    }
}

