/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.impl;

import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import org.intellij.plugins.xsltDebugger.VMPausedException;
import org.intellij.plugins.xsltDebugger.XsltDebuggerSession;
import org.intellij.plugins.xsltDebugger.impl.XsltSourcePosition;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.intellij.plugins.xsltDebugger.rt.engine.DebuggerStoppedException;
import org.intellij.plugins.xsltDebugger.rt.engine.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltStackFrame
extends XStackFrame {
    private final Debugger.Frame myFrame;
    private final XsltDebuggerSession myDebuggerSession;
    private final XSourcePosition myPosition;

    public XsltStackFrame(Debugger.Frame frame, XsltDebuggerSession debuggerSession) {
        this.myFrame = frame;
        this.myDebuggerSession = debuggerSession;
        this.myPosition = XsltSourcePosition.create((Debugger.Locatable)frame);
    }

    public Object getEqualityObject() {
        return XsltStackFrame.class;
    }

    public XDebuggerEvaluator getEvaluator() {
        return this.myFrame instanceof Debugger.StyleFrame ? new MyEvaluator((Debugger.StyleFrame)this.myFrame) : null;
    }

    public XSourcePosition getSourcePosition() {
        return this.myPosition;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/xsltDebugger/impl/XsltStackFrame", "customizePresentation"));
        }
        if (this.myDebuggerSession.getCurrentState() == Debugger.State.SUSPENDED) {
            try {
                this._customizePresentation(component);
            }
            catch (VMPausedException ignore) {
            }
            catch (DebuggerStoppedException debuggerStoppedException) {
                // empty catch block
            }
        }
    }

    private void _customizePresentation(ColoredTextContainer component) {
        Debugger.Frame frame = this.myFrame;
        if (frame instanceof Debugger.StyleFrame) {
            component.append(((Debugger.StyleFrame)frame).getInstruction(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        } else if (frame instanceof Debugger.SourceFrame) {
            component.append(((Debugger.SourceFrame)frame).getXPath(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        component.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        try {
            VirtualFile file = VfsUtil.findFileByURL((URL)new URI(frame.getURI()).toURL());
            if (file != null) {
                component.append(file.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                if (frame.getLineNumber() > 0) {
                    component.append(":" + frame.getLineNumber(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
                component.setToolTipText(file.getPresentableUrl());
            } else {
                component.append(frame.getURI() + ":" + frame.getLineNumber(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }
        catch (Exception ignored) {
            component.append(frame.getURI() + ":" + frame.getLineNumber(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/xsltDebugger/impl/XsltStackFrame", "computeChildren"));
        }
        try {
            if (this.myFrame instanceof Debugger.StyleFrame) {
                List variables = ((Debugger.StyleFrame)this.myFrame).getVariables();
                XValueChildrenList list = new XValueChildrenList();
                for (Debugger.Variable variable : variables) {
                    list.add(variable.getName(), (XValue)new MyValue(variable));
                }
                node.addChildren(list, true);
            } else {
                super.computeChildren(node);
            }
        }
        catch (VMPausedException ignored) {
            node.setErrorMessage("Target VM is not responding");
        }
    }

    public Debugger.Frame getFrame() {
        return this.myFrame;
    }

    private static class MyEvaluator
    extends XDebuggerEvaluator {
        private final Debugger.StyleFrame myFrame;

        public MyEvaluator(Debugger.StyleFrame frame) {
            this.myFrame = frame;
        }

        public boolean isCodeFragmentEvaluationSupported() {
            return false;
        }

        public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/xsltDebugger/impl/XsltStackFrame$MyEvaluator", "evaluate"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/plugins/xsltDebugger/impl/XsltStackFrame$MyEvaluator", "evaluate"));
            }
            try {
                Value eval = this.myFrame.eval(expression);
                callback.evaluated((XValue)new MyValue(new ExpressionResult(eval)));
            }
            catch (VMPausedException ignored) {
                callback.errorOccurred("Target VM is not responding");
            }
            catch (Debugger.EvaluationException e) {
                callback.errorOccurred(e.getMessage() != null ? e.getMessage() : e.toString());
            }
        }

        private static class ExpressionResult
        implements Debugger.Variable {
            private final Value myValue;

            public ExpressionResult(Value value) {
                this.myValue = value;
            }

            public String getURI() {
                return null;
            }

            public int getLineNumber() {
                return -1;
            }

            public boolean isGlobal() {
                return false;
            }

            public Debugger.Variable.Kind getKind() {
                return Debugger.Variable.Kind.EXPRESSION;
            }

            public String getName() {
                return "result";
            }

            public Value getValue() {
                return this.myValue;
            }
        }
    }

    private static class MyValue
    extends XValue {
        private final Debugger.Variable myVariable;

        public MyValue(Debugger.Variable variable) {
            this.myVariable = variable;
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/xsltDebugger/impl/XsltStackFrame$MyValue", "computePresentation"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/plugins/xsltDebugger/impl/XsltStackFrame$MyValue", "computePresentation"));
            }
            Debugger.Variable.Kind kind = this.myVariable.getKind();
            Icon icon = null;
            if (this.myVariable.isGlobal()) {
                icon = kind == Debugger.Variable.Kind.VARIABLE ? PlatformIcons.FIELD_ICON : PlatformIcons.PROPERTY_ICON;
            } else if (kind == Debugger.Variable.Kind.VARIABLE) {
                icon = PlatformIcons.VARIABLE_ICON;
            } else if (kind == Debugger.Variable.Kind.PARAMETER) {
                icon = PlatformIcons.PARAMETER_ICON;
            }
            Value v = this.myVariable.getValue();
            if (v.getType() == Value.XPathType.STRING) {
                node.setPresentation(icon, v.getType().getName(), "'" + String.valueOf(v.getValue()) + "'", false);
            } else {
                boolean hasChildren = this.myVariable.getValue().getValue() instanceof Value.NodeSet;
                node.setPresentation(icon, v.getType().getName(), String.valueOf(v.getValue()), hasChildren);
            }
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/xsltDebugger/impl/XsltStackFrame$MyValue", "computeChildren"));
            }
            if (this.myVariable.getValue().getValue() instanceof Value.NodeSet) {
                Value.NodeSet set = (Value.NodeSet)this.myVariable.getValue().getValue();
                XValueChildrenList list = new XValueChildrenList();
                for (Value.Node n : set.getNodes()) {
                    list.add(n.myXPath, (XValue)new NodeValue(n));
                }
                node.addChildren(list, false);
            }
            super.computeChildren(node);
        }

        public String getEvaluationExpression() {
            return "$" + this.myVariable.getName();
        }

        public void computeSourcePosition(@NotNull XNavigatable navigatable) {
            if (navigatable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/xsltDebugger/impl/XsltStackFrame$MyValue", "computeSourcePosition"));
            }
            navigatable.setSourcePosition(XsltSourcePosition.create((Debugger.Locatable)this.myVariable));
        }

        static String clipValue(String stringValue) {
            return stringValue.length() < 100 ? stringValue : stringValue.substring(0, 100) + "...";
        }

        private static class NodeValue
        extends XValue {
            private final Value.Node myNode;

            public NodeValue(Value.Node n) {
                this.myNode = n;
            }

            public void computeSourcePosition(@NotNull XNavigatable navigatable) {
                if (navigatable == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/xsltDebugger/impl/XsltStackFrame$MyValue$NodeValue", "computeSourcePosition"));
                }
                navigatable.setSourcePosition(XsltSourcePosition.create((Debugger.Locatable)this.myNode));
            }

            public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/xsltDebugger/impl/XsltStackFrame$MyValue$NodeValue", "computePresentation"));
                }
                if (place == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/plugins/xsltDebugger/impl/XsltStackFrame$MyValue$NodeValue", "computePresentation"));
                }
                node.setPresentation(null, "node", this.myNode.myStringValue, false);
            }
        }
    }
}

