/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.upgrade;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.checkout.SvnKitCheckoutClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.upgrade.UpgradeClient;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnKitUpgradeClient
extends BaseSvnClient
implements UpgradeClient {
    @Override
    public void upgrade(@NotNull File path, @NotNull WorkingCopyFormat format, @Nullable ISVNEventHandler handler) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/upgrade/SvnKitUpgradeClient", "upgrade"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/upgrade/SvnKitUpgradeClient", "upgrade"));
        }
        this.validateFormat(format, this.getSupportedFormats());
        SVNWCClient client = this.myVcs.createWCClient();
        client.setEventHandler(handler);
        try {
            SvnKitUpgradeClient.cleanupIfNecessary(path, format, client, handler);
            SvnKitUpgradeClient.upgrade(path, format, client, handler);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public List<WorkingCopyFormat> getSupportedFormats() throws VcsException {
        return SvnKitCheckoutClient.SUPPORTED_FORMATS;
    }

    private static void cleanupIfNecessary(@NotNull File path, @NotNull WorkingCopyFormat format, @NotNull SVNWCClient client, @Nullable ISVNEventHandler handler) throws SVNException, VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/upgrade/SvnKitUpgradeClient", "cleanupIfNecessary"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/upgrade/SvnKitUpgradeClient", "cleanupIfNecessary"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/upgrade/SvnKitUpgradeClient", "cleanupIfNecessary"));
        }
        if (WorkingCopyFormat.ONE_DOT_SEVEN.equals((Object)format)) {
            SvnKitUpgradeClient.callHandler(handler, SvnKitUpgradeClient.createEvent(path, SVNEventAction.UPDATE_STARTED));
            client.doCleanup(path);
        }
    }

    private static void upgrade(@NotNull File path, @NotNull WorkingCopyFormat format, @NotNull SVNWCClient client, @Nullable ISVNEventHandler handler) throws SVNException, VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/upgrade/SvnKitUpgradeClient", "upgrade"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/upgrade/SvnKitUpgradeClient", "upgrade"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/upgrade/SvnKitUpgradeClient", "upgrade"));
        }
        SvnKitUpgradeClient.callHandler(handler, SvnKitUpgradeClient.createEvent(path, SVNEventAction.UPDATE_COMPLETED));
        client.doSetWCFormat(path, format.getFormat());
    }
}

