/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import java.io.File;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class UpdateRootInfo {
    private String myUrl;
    private SVNRevision myRevision = SVNRevision.HEAD;
    private boolean myUpdateToSpecifiedRevision = false;

    public UpdateRootInfo(File file, SvnVcs vcs) {
        SVNInfo info = vcs.getInfo(file);
        this.myUrl = info != null && info.getURL() != null ? info.getURL().toString() : "";
    }

    public SVNURL getUrl() {
        try {
            return SVNURL.parseURIEncoded((String)this.myUrl);
        }
        catch (SVNException e) {
            return null;
        }
    }

    public String getUrlAsString() {
        return this.myUrl;
    }

    public SVNRevision getRevision() {
        return this.myRevision;
    }

    public boolean isUpdateToRevision() {
        return this.myUpdateToSpecifiedRevision;
    }

    public void setUrl(String text) {
        this.myUrl = text;
    }

    public void setUpdateToRevision(boolean value) {
        this.myUpdateToSpecifiedRevision = value;
    }

    public void setRevision(SVNRevision svnRevision) {
        this.myRevision = svnRevision;
    }
}

