/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.revert;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.FileStatusResultParser;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.revert.RevertClient;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdRevertClient
extends BaseSvnClient
implements RevertClient {
    private static final String STATUS = "\\s*(.+?)\\s*";
    private static final String PATH = "\\s*'(.*?)'\\s*";
    private static final String OPTIONAL_COMMENT = "(.*)";
    private static final Pattern CHANGED_PATH = Pattern.compile("\\s*(.+?)\\s*\\s*'(.*?)'\\s*(.*)");

    @Override
    public void revert(@NotNull File[] paths, @Nullable SVNDepth depth, @Nullable ISVNEventHandler handler) throws VcsException {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/revert/CmdRevertClient", "revert"));
        }
        if (paths.length > 0) {
            List<String> parameters = CmdRevertClient.prepareParameters(paths, depth);
            CommandExecutor command = CommandUtil.execute(this.myVcs, SvnTarget.fromFile((File)paths[0]), CommandUtil.getHomeDirectory(), SvnCommandName.revert, parameters, null);
            FileStatusResultParser parser = new FileStatusResultParser(CHANGED_PATH, handler, new RevertStatusConvertor());
            parser.parse(command.getOutput());
        }
    }

    private static List<String> prepareParameters(File[] paths, SVNDepth depth) {
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, paths);
        CommandUtil.put(parameters, depth);
        return parameters;
    }

    private static class RevertStatusConvertor
    implements Convertor<Matcher, SVNEvent> {
        private RevertStatusConvertor() {
        }

        public SVNEvent convert(@NotNull Matcher matcher) {
            if (matcher == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/revert/CmdRevertClient$RevertStatusConvertor", "convert"));
            }
            String statusMessage = matcher.group(1);
            String path = matcher.group(2);
            return CmdRevertClient.createEvent(new File(path), RevertStatusConvertor.createAction(statusMessage));
        }

        @Nullable
        public static SVNEventAction createAction(@NotNull String code) {
            if (code == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/revert/CmdRevertClient$RevertStatusConvertor", "createAction"));
            }
            SVNEventAction result = null;
            if ("Reverted".equals(code)) {
                result = SVNEventAction.REVERT;
            } else if ("Failed to revert".equals(code)) {
                result = SVNEventAction.FAILED_REVERT;
            } else if ("Skipped".equals(code)) {
                result = SVNEventAction.SKIP;
            }
            return result;
        }
    }
}

