/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.properties;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.ISVNPropertyValueProvider;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitPropertyClient
extends BaseSvnClient
implements PropertyClient {
    @Override
    @Nullable
    public SVNPropertyData getProperty(@NotNull SvnTarget target, @NotNull String property, boolean revisionProperty, @Nullable SVNRevision revision) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "getProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "getProperty"));
        }
        try {
            if (!revisionProperty) {
                if (target.isFile()) {
                    return this.createClient().doGetProperty(target.getFile(), property, target.getPegRevision(), revision);
                }
                return this.createClient().doGetProperty(target.getURL(), property, target.getPegRevision(), revision);
            }
            return this.getRevisionProperty(target, property, revision);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @NotNull
    private SVNWCClient createClient() {
        SVNWCClient client = this.myVcs.createWCClient();
        client.setOptions(LF_SEPARATOR_OPTIONS);
        SVNWCClient sVNWCClient = client;
        if (sVNWCClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "createClient"));
        }
        return sVNWCClient;
    }

    @Override
    public void getProperty(@NotNull SvnTarget target, @NotNull String property, @Nullable SVNRevision revision, @Nullable SVNDepth depth, @Nullable ISVNPropertyHandler handler) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "getProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "getProperty"));
        }
        this.runGetProperty(target, property, revision, depth, handler);
    }

    @Override
    public void list(@NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable SVNDepth depth, @Nullable ISVNPropertyHandler handler) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "list"));
        }
        this.runGetProperty(target, null, revision, depth, handler);
    }

    @Override
    public void setProperty(@NotNull File file, @NotNull String property, @Nullable SVNPropertyValue value, @Nullable SVNDepth depth, boolean force) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "setProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "setProperty"));
        }
        try {
            this.createClient().doSetProperty(file, property, value, force, depth, null, null);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public void setProperties(@NotNull File file, @NotNull SVNProperties properties) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "setProperties"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "setProperties"));
        }
        try {
            this.createClient().doSetProperty(file, new ISVNPropertyValueProvider(){

                public SVNProperties providePropertyValues(File path, SVNProperties properties) throws SVNException {
                    return properties;
                }
            }, true, SVNDepth.EMPTY, null, null);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public void setRevisionProperty(@NotNull SvnTarget target, @NotNull String property, @NotNull SVNRevision revision, @Nullable SVNPropertyValue value, boolean force) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "setRevisionProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "setRevisionProperty"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "setRevisionProperty"));
        }
        try {
            if (target.isFile()) {
                this.createClient().doSetRevisionProperty(target.getFile(), revision, property, value, force, null);
            } else {
                this.createClient().doSetRevisionProperty(target.getURL(), revision, property, value, force, null);
            }
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    private void runGetProperty(@NotNull SvnTarget target, @Nullable String property, @Nullable SVNRevision revision, @Nullable SVNDepth depth, @Nullable ISVNPropertyHandler handler) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "runGetProperty"));
        }
        SVNWCClient client = this.createClient();
        try {
            if (target.isURL()) {
                client.doGetProperty(target.getURL(), property, target.getPegRevision(), revision, depth, handler);
            } else {
                client.doGetProperty(target.getFile(), property, target.getPegRevision(), revision, depth, handler, null);
            }
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private SVNPropertyData getRevisionProperty(@NotNull SvnTarget target, final @NotNull String property, @Nullable SVNRevision revision) throws SVNException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "getRevisionProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient", "getRevisionProperty"));
        }
        SVNWCClient client = this.createClient();
        final SVNPropertyData[] result = new SVNPropertyData[1];
        ISVNPropertyHandler handler = new ISVNPropertyHandler(){

            public void handleProperty(File path, SVNPropertyData property2) throws SVNException {
                this.handle(property2);
            }

            public void handleProperty(SVNURL url, SVNPropertyData property2) throws SVNException {
                this.handle(property2);
            }

            public void handleProperty(long revision, SVNPropertyData property2) throws SVNException {
                this.handle(property2);
            }

            private void handle(@NotNull SVNPropertyData data) {
                if (data == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/SvnKitPropertyClient$2", "handle"));
                }
                if (property.equals(data.getName())) {
                    result[0] = data;
                }
            }
        };
        if (target.isFile()) {
            client.doGetRevisionProperty(target.getFile(), null, revision, handler);
        } else {
            client.doGetRevisionProperty(target.getURL(), null, revision, handler);
        }
        return result[0];
    }
}

