/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.portable;

import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.portable.SvnStatusClientI;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;

public class SvnkitSvnStatusClient
implements SvnStatusClientI {
    @Nullable
    private final SVNStatusClient myStatusClient;
    @NotNull
    private final SvnVcs myVcs;

    public SvnkitSvnStatusClient(@NotNull SvnVcs vcs, @Nullable SVNStatusClient statusClient) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/portable/SvnkitSvnStatusClient", "<init>"));
        }
        this.myVcs = vcs;
        this.myStatusClient = statusClient;
    }

    @Override
    public long doStatus(File path, boolean recursive, boolean remote, boolean reportAll, boolean includeIgnored, ISVNStatusHandler handler) throws SVNException {
        return this.getStatusClient().doStatus(path, recursive, remote, reportAll, includeIgnored, handler);
    }

    @Override
    public long doStatus(File path, boolean recursive, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, ISVNStatusHandler handler) throws SVNException {
        return this.getStatusClient().doStatus(path, recursive, remote, reportAll, includeIgnored, collectParentExternals, handler);
    }

    @Override
    public long doStatus(File path, SVNRevision revision, boolean recursive, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, ISVNStatusHandler handler) throws SVNException {
        return this.getStatusClient().doStatus(path, revision, recursive, remote, reportAll, includeIgnored, collectParentExternals, handler);
    }

    @Override
    public long doStatus(File path, SVNRevision revision, SVNDepth depth, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, ISVNStatusHandler handler, Collection changeLists) throws SVNException {
        return this.getStatusClient().doStatus(path, revision, depth, remote, reportAll, includeIgnored, collectParentExternals, handler, changeLists);
    }

    @Override
    public SVNStatus doStatus(File path, boolean remote) throws SVNException {
        return this.getStatusClient().doStatus(path, remote);
    }

    @Override
    public SVNStatus doStatus(File path, boolean remote, boolean collectParentExternals) throws SVNException {
        return this.getStatusClient().doStatus(path, remote, collectParentExternals);
    }

    @NotNull
    private SVNStatusClient getStatusClient() {
        SVNStatusClient sVNStatusClient = this.myStatusClient != null ? this.myStatusClient : this.myVcs.createStatusClient();
        if (sVNStatusClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/portable/SvnkitSvnStatusClient", "getStatusClient"));
        }
        return sVNStatusClient;
    }
}

