/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;
import org.jetbrains.idea.svn.mergeinfo.OneRecursiveShotMergeInfoWorker;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;

public class OneShotMergeInfoHelper
implements MergeChecker {
    private OneRecursiveShotMergeInfoWorker myWorker;
    private final Map<Long, Collection<String>> myPartiallyMerged;

    public OneShotMergeInfoHelper(Project project, WCInfo wcInfo, String branchPath) {
        this.myWorker = new OneRecursiveShotMergeInfoWorker(project, wcInfo, branchPath);
        this.myPartiallyMerged = new HashMap<Long, Collection<String>>();
    }

    public void prepare() throws VcsException {
        this.myWorker.prepare();
    }

    @Override
    public Collection<String> getNotMergedPaths(long number) {
        return this.myPartiallyMerged.get(number);
    }

    @Override
    public SvnMergeInfoCache.MergeCheckResult checkList(SvnChangeList list) {
        HashSet<String> notMerged = new HashSet<String>();
        boolean somethingMerged = false;
        long number = list.getNumber();
        HashSet<String> paths = new HashSet<String>(list.getAddedPaths());
        paths.addAll(list.getDeletedPaths());
        paths.addAll(list.getChangedPaths());
        for (String path : paths) {
            SvnMergeInfoCache.MergeCheckResult pathResult = this.myWorker.isMerged(path, number);
            if (SvnMergeInfoCache.MergeCheckResult.MERGED.equals((Object)pathResult)) {
                somethingMerged = true;
                continue;
            }
            if (!SvnMergeInfoCache.MergeCheckResult.NOT_MERGED.equals((Object)pathResult)) continue;
            notMerged.add(path);
        }
        if (somethingMerged && !notMerged.isEmpty()) {
            this.myPartiallyMerged.put(number, notMerged);
        }
        if (!somethingMerged && notMerged.isEmpty()) {
            return SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS;
        }
        return SvnMergeInfoCache.MergeCheckResult.getInstance(somethingMerged && notMerged.isEmpty());
    }
}

