/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.lowLevel;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class SVNStoppableInputStream
extends InputStream {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.lowLevel.SVNStoppableInputStream");
    private static final String ourCheckAvalilable = "svn.check.available";
    private final InputStream myOriginalIs;
    private final InputStream myIn;
    private boolean myAvailableChecked;
    private final boolean myCheckAvailable;

    public SVNStoppableInputStream(InputStream original, InputStream in) {
        String property = System.getProperty(ourCheckAvalilable);
        this.myCheckAvailable = !StringUtil.isEmptyOrSpaces((String)property) && Boolean.parseBoolean(property);
        this.myOriginalIs = this.myCheckAvailable ? this.digOriginal(original) : original;
        this.myIn = in;
        this.myAvailableChecked = false;
    }

    private InputStream digOriginal(InputStream original) {
        InputStream current = original;
        try {
            Method[] methods;
            while (true) {
                String name;
                if ("org.tmatesoft.svn.core.internal.io.dav.http.SpoolFile.SpoolInputStream".equals(name = current.getClass().getName())) {
                    current = this.byName(current, "myCurrentInput");
                    continue;
                }
                if ("org.tmatesoft.svn.core.internal.util.ChunkedInputStream".equals(name)) {
                    current = this.byName(current, "myInputStream");
                    continue;
                }
                if (!"org.tmatesoft.svn.core.internal.util.FixedSizeInputStream".equals(name)) break;
                current = this.byName(current, "mySource");
            }
            if (current instanceof BufferedInputStream) {
                return this.createReadingProxy(current);
            }
            for (Method method : methods = current.getClass().getDeclaredMethods()) {
                if (!"available".equals(method.getName())) continue;
                return current;
            }
            return this.createReadingProxy(current);
        }
        catch (NoSuchFieldException e) {
            LOG.info((Throwable)e);
            return this.createReadingProxy(current);
        }
        catch (IllegalAccessException e) {
            LOG.info((Throwable)e);
            return this.createReadingProxy(current);
        }
    }

    private InputStream createReadingProxy(final InputStream current) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return current.read();
            }

            @Override
            public int read(byte[] b) throws IOException {
                return current.read(b);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return current.read(b, off, len);
            }

            @Override
            public long skip(long n) throws IOException {
                return current.skip(n);
            }

            @Override
            public void close() throws IOException {
                current.close();
            }

            @Override
            public void mark(int readlimit) {
                current.mark(readlimit);
            }

            @Override
            public void reset() throws IOException {
                current.reset();
            }

            @Override
            public boolean markSupported() {
                return current.markSupported();
            }

            @Override
            public int available() throws IOException {
                return 1;
            }
        };
    }

    private InputStream byName(InputStream current, String name) throws NoSuchFieldException, IllegalAccessException {
        Field input = current.getClass().getDeclaredField(name);
        input.setAccessible(true);
        current = (InputStream)input.get(current);
        return current;
    }

    @Override
    public int read() throws IOException {
        this.waitForAvailable();
        return this.myIn.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.waitForAvailable();
        return this.myIn.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        this.check();
        if (this.available() <= 0) {
            return 0L;
        }
        return this.myIn.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.check();
        if (!this.myAvailableChecked) {
            int available = this.myOriginalIs.available();
            if (available > 0) {
                this.myAvailableChecked = true;
            }
            return available;
        }
        return 1;
    }

    @Override
    public void close() throws IOException {
        this.check();
        this.myIn.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.myIn.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.check();
        this.myIn.reset();
    }

    @Override
    public boolean markSupported() {
        return this.myIn.markSupported();
    }

    private void check() throws IOException {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null && indicator.isCanceled()) {
            throw new IOException("Read request to canceled by user");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAvailable() throws IOException {
        Object lock;
        if (!this.myCheckAvailable) {
            return;
        }
        Object object = lock = new Object();
        synchronized (object) {
            while (this.available() <= 0) {
                this.check();
                try {
                    lock.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

