/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.lock;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.lock.LockClient;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnKitLockClient
extends BaseSvnClient
implements LockClient {
    @Override
    public void lock(@NotNull File file, boolean force, @NotNull String message, @Nullable ISVNEventHandler handler) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/lock/SvnKitLockClient", "lock"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/lock/SvnKitLockClient", "lock"));
        }
        try {
            this.getClient(handler).doLock(new File[]{file}, force, message);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public void unlock(@NotNull File file, boolean force, @Nullable ISVNEventHandler handler) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/lock/SvnKitLockClient", "unlock"));
        }
        try {
            this.getClient(handler).doUnlock(new File[]{file}, force);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @NotNull
    private SVNWCClient getClient(@Nullable ISVNEventHandler handler) {
        SVNWCClient client = this.myVcs.createWCClient();
        client.setEventHandler(handler);
        SVNWCClient sVNWCClient = client;
        if (sVNWCClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/lock/SvnKitLockClient", "getClient"));
        }
        return sVNWCClient;
    }
}

