/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.BlockReloadingUtil;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.update.RestoreUpdateTree;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.UpdatedFilesReverseSide;
import com.intellij.util.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnChangeProvider;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.integrate.AlienDirtyScope;
import org.jetbrains.idea.svn.integrate.GatheringChangelistBuilder;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.integrate.IntegrateEventHandler;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.ResolveWorker;
import org.jetbrains.idea.svn.integrate.WorkingCopyInfo;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SvnIntegrateChangesTask
extends Task.Backgroundable {
    private final ProjectLevelVcsManagerEx myProjectLevelVcsManager;
    private final SvnVcs myVcs;
    private final WorkingCopyInfo myInfo;
    private final UpdatedFilesReverseSide myAccomulatedFiles;
    private UpdatedFiles myRecentlyUpdatedFiles;
    private final List<VcsException> myExceptions;
    private UpdateEventHandler myHandler;
    private IMerger myMerger;
    private ResolveWorker myResolveWorker;
    private FilePathImpl myMergeTarget;
    private final String myTitle;
    private final String myBranchName;
    private final MergerFactory myMergerFactory;
    private final SVNURL myCurrentBranchUrl;
    private boolean myDryRun;

    public SvnIntegrateChangesTask(SvnVcs vcs, WorkingCopyInfo info, MergerFactory mergerFactory, SVNURL currentBranchUrl, String title, boolean dryRun, String branchName) {
        super(vcs.getProject(), title, true, VcsConfiguration.getInstance((Project)vcs.getProject()).getUpdateOption());
        this.myMergerFactory = mergerFactory;
        this.myCurrentBranchUrl = currentBranchUrl;
        this.myDryRun = dryRun;
        this.myTitle = title;
        this.myBranchName = branchName;
        this.myProjectLevelVcsManager = ProjectLevelVcsManagerEx.getInstanceEx((Project)this.myProject);
        this.myVcs = vcs;
        this.myInfo = info;
        this.myAccomulatedFiles = new UpdatedFilesReverseSide(UpdatedFiles.create());
        this.myExceptions = new ArrayList<VcsException>();
        this.myHandler = new IntegrateEventHandler(this.myVcs, ProgressManager.getInstance().getProgressIndicator());
        this.myMerger = this.myMergerFactory.createMerger(this.myVcs, new File(this.myInfo.getLocalPath()), this.myHandler, this.myCurrentBranchUrl, this.myBranchName);
    }

    private void indicatorOnStart() {
        ProgressIndicator ind = ProgressManager.getInstance().getProgressIndicator();
        if (ind != null) {
            ind.setIndeterminate(true);
        }
        if (ind != null) {
            ind.setText(SvnBundle.message("action.Subversion.integrate.changes.progress.integrating.text", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/integrate/SvnIntegrateChangesTask", "run"));
        }
        this.myHandler.setProgressIndicator(ProgressManager.getInstance().getProgressIndicator());
        this.myResolveWorker = new ResolveWorker(this.myInfo.isUnderProjectRoot(), this.myProject);
        BlockReloadingUtil.block();
        this.myProjectLevelVcsManager.startBackgroundVcsOperation();
        try {
            this.myRecentlyUpdatedFiles = UpdatedFiles.create();
            this.myHandler.setUpdatedFiles(this.myRecentlyUpdatedFiles);
            this.indicatorOnStart();
            while (true) {
                this.doMerge();
                RefreshVFsSynchronously.updateAllChanged((UpdatedFiles)this.myRecentlyUpdatedFiles);
                indicator.setText(VcsBundle.message((String)"progress.text.updating.done", (Object[])new Object[0]));
                if (this.myResolveWorker.needsInteraction(this.myRecentlyUpdatedFiles) || !this.myMerger.hasNext() || !this.myExceptions.isEmpty()) break;
                if (UpdatedFilesReverseSide.containErrors((UpdatedFiles)this.myRecentlyUpdatedFiles)) {
                    break;
                }
                this.accomulate();
            }
        }
        finally {
            this.myProjectLevelVcsManager.stopBackgroundVcsOperation();
        }
    }

    private void createMessage(boolean getLatest, boolean warning, String firstString) {
        final ArrayList<String> messages = new ArrayList<String>();
        messages.add(firstString);
        this.myMerger.getInfo(new Consumer<String>(){

            public void consume(String s) {
                messages.add(s);
            }
        }, getLatest);
        VcsException result = new VcsException(messages);
        result.setIsWarning(warning);
        this.myExceptions.add(result);
    }

    private void doMerge() {
        try {
            this.myMerger.mergeNext();
        }
        catch (SVNException e) {
            this.createMessage(true, false, e.getMessage());
        }
        catch (VcsException e) {
            this.createMessage(true, false, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCancel() {
        try {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.afterExecution(true);
        }
        finally {
            BlockReloadingUtil.unblock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess() {
        try {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.afterExecution(false);
        }
        finally {
            BlockReloadingUtil.unblock();
        }
    }

    private void accomulate() {
        this.myAccomulatedFiles.accomulateFiles(this.myRecentlyUpdatedFiles, UpdatedFilesReverseSide.DuplicateLevel.DUPLICATE_ERRORS);
    }

    private void afterExecution(boolean wasCanceled) {
        if (!this.myRecentlyUpdatedFiles.isEmpty()) {
            this.myResolveWorker.execute(this.myRecentlyUpdatedFiles);
        }
        boolean haveConflicts = ResolveWorker.haveUnresolvedConflicts(this.myRecentlyUpdatedFiles);
        this.accomulate();
        if (!this.myMerger.hasNext() || haveConflicts || !this.myExceptions.isEmpty() || this.myAccomulatedFiles.containErrors() || wasCanceled) {
            this.initMergeTarget();
            if (this.myAccomulatedFiles.isEmpty() && this.myExceptions.isEmpty() && this.myMergeTarget == null && !wasCanceled) {
                Messages.showMessageDialog((String)SvnBundle.message("action.Subversion.integrate.changes.message.files.up.to.date.text", new Object[0]), (String)this.myTitle, (Icon)Messages.getInformationIcon());
            } else {
                if (haveConflicts) {
                    VcsException exception = new VcsException(SvnBundle.message("svn.integrate.changelist.warning.unresolved.conflicts.text", new Object[0]));
                    exception.setIsWarning(true);
                    this.myExceptions.add(exception);
                }
                if (wasCanceled) {
                    final LinkedList<String> details = new LinkedList<String>();
                    details.add("Integration was canceled");
                    this.myMerger.getSkipped(new Consumer<String>(){

                        public void consume(String s) {
                            if (!StringUtil.isEmptyOrSpaces((String)s)) {
                                details.add(s);
                            }
                        }
                    });
                    VcsException exception = new VcsException(details);
                    exception.setIsWarning(true);
                    this.myExceptions.add(exception);
                }
                this.finishActions(wasCanceled);
            }
            this.myMerger.afterProcessing();
        } else {
            this.stepToNextChangeList();
        }
    }

    private void finishActions(boolean wasCanceled) {
        if (!(wasCanceled || ApplicationManager.getApplication().isUnitTestMode() || this.myDryRun || !this.myExceptions.isEmpty() || this.myAccomulatedFiles.containErrors() || this.myAccomulatedFiles.isEmpty() && this.myMergeTarget == null)) {
            if (this.myInfo.isUnderProjectRoot()) {
                this.showLocalCommit();
            } else {
                this.showAlienCommit();
            }
            return;
        }
        Collection<FilePath> files = this.gatherChangedPaths();
        VcsDirtyScopeManager.getInstance((Project)this.myProject).filePathsDirty(files, null);
        this.prepareAndShowResults();
    }

    private void prepareAndShowResults() {
        if (!this.myAccomulatedFiles.isEmpty()) {
            this.showUpdateTree();
        }
        if (!this.myExceptions.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(this.myExceptions, VcsBundle.message((String)"message.title.vcs.update.errors", (Object[])new Object[]{this.myExceptions.size()}));
        }
    }

    private void showUpdateTree() {
        RestoreUpdateTree restoreUpdateTree = RestoreUpdateTree.getInstance((Project)this.myProject);
        restoreUpdateTree.registerUpdateInformation(this.myAccomulatedFiles.getUpdatedFiles(), ActionInfo.INTEGRATE);
        this.myProjectLevelVcsManager.showUpdateProjectInfo(this.myAccomulatedFiles.getUpdatedFiles(), this.myTitle, ActionInfo.INTEGRATE, false);
    }

    private void stepToNextChangeList() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().run((Task)SvnIntegrateChangesTask.this);
            }
        });
    }

    @Nullable
    private void initMergeTarget() {
        SVNStatus svnStatus;
        File mergeInfoHolder = this.myMerger.getMergeInfoHolder();
        if (mergeInfoHolder != null && (svnStatus = SvnUtil.getStatus(this.myVcs, mergeInfoHolder)) != null && SVNStatusType.STATUS_MODIFIED.equals(svnStatus.getPropertiesStatus())) {
            this.myMergeTarget = FilePathImpl.create((File)mergeInfoHolder, (boolean)mergeInfoHolder.isDirectory());
        }
    }

    private void showLocalCommit() {
        final Collection<FilePath> files = this.gatherChangedPaths();
        final ChangeListManager clManager = ChangeListManager.getInstance((Project)this.myProject);
        clManager.invokeAfterUpdate(new Runnable(){

            @Override
            public void run() {
                ArrayList<Change> changes = new ArrayList<Change>();
                for (FilePath file : files) {
                    Change change = clManager.getChange(file);
                    if (change == null) continue;
                    changes.add(change);
                }
                CommitChangeListDialog.commitChanges((Project)SvnIntegrateChangesTask.this.myProject, changes, null, null, (String)SvnIntegrateChangesTask.this.myMerger.getComment());
                SvnIntegrateChangesTask.this.prepareAndShowResults();
            }
        }, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, this.myTitle, (Consumer)new Consumer<VcsDirtyScopeManager>(){

            public void consume(VcsDirtyScopeManager vcsDirtyScopeManager) {
                vcsDirtyScopeManager.filePathsDirty(files, null);
            }
        }, null);
    }

    private Collection<FilePath> gatherChangedPaths() {
        final ArrayList<FilePath> files = new ArrayList<FilePath>();
        UpdateFilesHelper.iterateFileGroupFiles((UpdatedFiles)this.myAccomulatedFiles.getUpdatedFiles(), (UpdateFilesHelper.Callback)new UpdateFilesHelper.Callback(){

            public void onFile(String filePath, String groupId) {
                FilePathImpl file = FilePathImpl.create((File)new File(filePath));
                files.add(file);
            }
        });
        if (this.myMergeTarget != null) {
            files.add((FilePath)this.myMergeTarget);
        }
        return files;
    }

    private void showAlienCommit() {
        final AlienDirtyScope dirtyScope = new AlienDirtyScope();
        if (this.myMergeTarget != null) {
            dirtyScope.addDir((FilePath)this.myMergeTarget);
        } else {
            UpdateFilesHelper.iterateFileGroupFiles((UpdatedFiles)this.myAccomulatedFiles.getUpdatedFiles(), (UpdateFilesHelper.Callback)new UpdateFilesHelper.Callback(){

                public void onFile(String filePath, String groupId) {
                    FilePathImpl file = FilePathImpl.create((File)new File(filePath));
                    dirtyScope.addFile((FilePath)file);
                }
            });
        }
        SvnChangeProvider provider = new SvnChangeProvider(this.myVcs);
        GatheringChangelistBuilder clb = new GatheringChangelistBuilder(this.myVcs, this.myAccomulatedFiles);
        try {
            provider.getChanges(dirtyScope, (ChangelistBuilder)clb, ProgressManager.getInstance().getProgressIndicator(), null);
        }
        catch (VcsException e) {
            Messages.showErrorDialog((String)SvnBundle.message("action.Subversion.integrate.changes.error.unable.to.collect.changes.text", e.getMessage()), (String)this.myTitle);
            return;
        }
        if (!clb.getChanges().isEmpty()) {
            CommitChangeListDialog.commitAlienChanges((Project)this.myProject, clb.getChanges(), (AbstractVcs)this.myVcs, (String)this.myMerger.getComment(), (String)this.myMerger.getComment());
        }
    }
}

