/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.changes.committed.VcsConfigurationChangeListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.ConfigureBranchesAction;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.MergeInfoUpdatesListener;
import org.jetbrains.idea.svn.history.MergeSourceHierarchyBuilder;
import org.jetbrains.idea.svn.history.RootsAndBranches;
import org.jetbrains.idea.svn.history.ShowHideMergePanelAction;
import org.jetbrains.idea.svn.history.SingleCommittedListProvider;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedListsZipper;
import org.jetbrains.idea.svn.history.SvnMergeSourceTracker;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.history.SvnVersionFilterComponent;
import org.jetbrains.idea.svn.history.TreeStructureNode;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnCommittedChangesProvider
implements CachingCommittedChangesProvider<SvnChangeList, ChangeBrowserSettings> {
    private static final Logger LOG = Logger.getInstance(SvnCommittedChangesProvider.class);
    private final Project myProject;
    private final SvnVcs myVcs;
    private final MessageBusConnection myConnection;
    private MergeInfoUpdatesListener myMergeInfoUpdatesListener;
    private final SvnCommittedListsZipper myZipper;
    public static final int VERSION_WITH_COPY_PATHS_ADDED = 2;
    public static final int VERSION_WITH_REPLACED_PATHS = 3;

    public SvnCommittedChangesProvider(Project project) {
        this.myProject = project;
        this.myVcs = SvnVcs.getInstance(this.myProject);
        this.myZipper = new SvnCommittedListsZipper(this.myVcs);
        this.myConnection = this.myProject.getMessageBus().connect();
        this.myConnection.subscribe(VcsConfigurationChangeListener.BRANCHES_CHANGED_RESPONSE, (Object)new VcsConfigurationChangeListener.DetailedNotification(){

            public void execute(final Project project, final VirtualFile vcsRoot, final List<CommittedChangeList> cachedList) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (project.isDisposed()) {
                            return;
                        }
                        for (CommittedChangeList committedChangeList : cachedList) {
                            if (!(committedChangeList instanceof SvnChangeList) || vcsRoot != null && !vcsRoot.equals(((SvnChangeList)committedChangeList).getVcsRoot())) continue;
                            ((SvnChangeList)committedChangeList).forceReloadCachedInfo(true);
                        }
                    }
                });
            }
        });
    }

    @NotNull
    public ChangeBrowserSettings createDefaultSettings() {
        ChangeBrowserSettings changeBrowserSettings = new ChangeBrowserSettings();
        if (changeBrowserSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "createDefaultSettings"));
        }
        return changeBrowserSettings;
    }

    public ChangesBrowserSettingsEditor<ChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        return new SvnVersionFilterComponent(showDateFilter);
    }

    @Nullable
    public RepositoryLocation getLocationFor(FilePath root) {
        String url = SvnUtil.getExactLocation(this.myVcs, root.getIOFile());
        return url == null ? null : new SvnRepositoryLocation(url, root);
    }

    public RepositoryLocation getLocationFor(FilePath root, String repositoryPath) {
        return repositoryPath == null ? this.getLocationFor(root) : new SvnRepositoryLocation(repositoryPath);
    }

    @Nullable
    public VcsCommittedListsZipper getZipper() {
        return this.myZipper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount, final AsynchConsumer<CommittedChangeList> consumer) throws VcsException {
        try {
            final SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
            final String repositoryRoot = this.getRepositoryRoot(svnLocation);
            final ChangeBrowserSettings.Filter filter = settings.createFilter();
            this.getCommittedChangesImpl(settings, svnLocation, maxCount, new Consumer<SVNLogEntry>(){

                public void consume(SVNLogEntry svnLogEntry) {
                    SvnChangeList cl = new SvnChangeList(SvnCommittedChangesProvider.this.myVcs, svnLocation, svnLogEntry, repositoryRoot);
                    if (filter.accepts((CommittedChangeList)cl)) {
                        consumer.consume((Object)cl);
                    }
                }
            }, false, true);
        }
        finally {
            consumer.finished();
        }
    }

    public List<SvnChangeList> getCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount) throws VcsException {
        final SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
        final ArrayList<SvnChangeList> result = new ArrayList<SvnChangeList>();
        final String repositoryRoot = this.getRepositoryRoot(svnLocation);
        this.getCommittedChangesImpl(settings, svnLocation, maxCount, new Consumer<SVNLogEntry>(){

            public void consume(SVNLogEntry svnLogEntry) {
                result.add(new SvnChangeList(SvnCommittedChangesProvider.this.myVcs, svnLocation, svnLogEntry, repositoryRoot));
            }
        }, false, true);
        settings.filterChanges(result);
        return result;
    }

    public void getCommittedChangesWithMergedRevisons(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount, final PairConsumer<SvnChangeList, TreeStructureNode<SVNLogEntry>> finalConsumer) throws VcsException {
        final SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
        final String repositoryRoot = this.getRepositoryRoot(svnLocation);
        final MergeSourceHierarchyBuilder builder = new MergeSourceHierarchyBuilder(new Consumer<TreeStructureNode<SVNLogEntry>>(){

            public void consume(TreeStructureNode<SVNLogEntry> node) {
                finalConsumer.consume((Object)new SvnChangeList(SvnCommittedChangesProvider.this.myVcs, svnLocation, node.getMe(), repositoryRoot), node);
            }
        });
        final SvnMergeSourceTracker mergeSourceTracker = new SvnMergeSourceTracker(new ThrowableConsumer<Pair<SVNLogEntry, Integer>, SVNException>(){

            public void consume(Pair<SVNLogEntry, Integer> svnLogEntryIntegerPair) throws SVNException {
                builder.consume(svnLogEntryIntegerPair);
            }
        });
        this.getCommittedChangesImpl(settings, svnLocation, maxCount, new Consumer<SVNLogEntry>(){

            public void consume(SVNLogEntry svnLogEntry) {
                try {
                    mergeSourceTracker.consume(svnLogEntry);
                }
                catch (SVNException e) {
                    throw new RuntimeException(e);
                }
            }
        }, true, false);
        builder.finish();
    }

    private String getRepositoryRoot(@NotNull SvnRepositoryLocation svnLocation) throws VcsException {
        SVNURL rootUrl;
        if (svnLocation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getRepositoryRoot"));
        }
        try {
            rootUrl = SvnUtil.getRepositoryRoot(this.myVcs, svnLocation.toSvnUrl());
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
        if (rootUrl == null) {
            throw new SvnBindException("Could not resolve repository root url for " + svnLocation);
        }
        return rootUrl.toDecodedString();
    }

    private void getCommittedChangesImpl(ChangeBrowserSettings settings, SvnRepositoryLocation location, int maxCount, Consumer<SVNLogEntry> resultConsumer, boolean includeMergedRevisions, boolean filterOutByDate) throws VcsException {
        SvnCommittedChangesProvider.setCollectingChangesProgress(location);
        String author = settings.getUserFilter();
        Date dateFrom = settings.getDateAfterFilter();
        Long changeFrom = settings.getChangeAfterFilter();
        Date dateTo = settings.getDateBeforeFilter();
        Long changeTo = settings.getChangeBeforeFilter();
        SVNRevision revisionBefore = SvnCommittedChangesProvider.createRevision(dateTo, changeTo, SVNRevision.HEAD);
        SVNRevision revisionAfter = SvnCommittedChangesProvider.createRevision(dateFrom, changeFrom, SVNRevision.create((long)1L));
        SvnTarget target = SvnTarget.fromURL((SVNURL)location.toSvnUrl(), (SVNRevision)revisionBefore);
        this.myVcs.getFactory(target).createHistoryClient().doLog(target, revisionBefore, revisionAfter, settings.STOP_ON_COPY, true, includeMergedRevisions, maxCount, null, this.createLogHandler(resultConsumer, filterOutByDate, author));
    }

    @NotNull
    private static SVNRevision createRevision(@Nullable Date date, @Nullable Long change, @NotNull SVNRevision defaultValue) throws VcsException {
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "createRevision"));
        }
        SVNRevision result = date != null ? SVNRevision.create((Date)date) : (change != null ? SVNRevision.create((long)change) : defaultValue);
        SVNRevision sVNRevision = result;
        if (sVNRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "createRevision"));
        }
        return sVNRevision;
    }

    @NotNull
    private ISVNLogEntryHandler createLogHandler(final Consumer<SVNLogEntry> resultConsumer, final boolean filterOutByDate, final String author) {
        ISVNLogEntryHandler iSVNLogEntryHandler = new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) {
                if (SvnCommittedChangesProvider.this.myProject.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                ProgressManager.progress2((String)SvnBundle.message("progress.text2.processing.revision", logEntry.getRevision()));
                if (filterOutByDate && logEntry.getDate() == null) {
                    return;
                }
                if (author == null || author.equalsIgnoreCase(logEntry.getAuthor())) {
                    resultConsumer.consume((Object)logEntry);
                }
            }
        };
        if (iSVNLogEntryHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "createLogHandler"));
        }
        return iSVNLogEntryHandler;
    }

    private static void setCollectingChangesProgress(@Nullable Object location) {
        ProgressManager.progress((String)SvnBundle.message("progress.text.changes.collecting.changes", new Object[0]), (String)SvnBundle.message("progress.text2.changes.establishing.connection", location));
    }

    public ChangeListColumn[] getColumns() {
        return new ChangeListColumn[]{new ChangeListColumn.ChangeListNumberColumn(SvnBundle.message("revision.title", new Object[0])), ChangeListColumn.NAME, ChangeListColumn.DATE, ChangeListColumn.DESCRIPTION};
    }

    private void refreshMergeInfo(RootsAndBranches action) {
        if (this.myMergeInfoUpdatesListener == null) {
            this.myMergeInfoUpdatesListener = new MergeInfoUpdatesListener(this.myProject, this.myConnection);
        }
        this.myMergeInfoUpdatesListener.addPanel(action);
    }

    @Nullable
    public VcsCommittedViewAuxiliary createActions(DecoratorManager manager, @Nullable RepositoryLocation location) {
        final RootsAndBranches rootsAndBranches = new RootsAndBranches(this.myProject, manager, location);
        this.refreshMergeInfo(rootsAndBranches);
        DefaultActionGroup popup = new DefaultActionGroup(this.myVcs.getDisplayName(), true);
        popup.add((AnAction)rootsAndBranches.getIntegrateAction());
        popup.add((AnAction)rootsAndBranches.getUndoIntegrateAction());
        popup.add((AnAction)new ConfigureBranchesAction());
        ShowHideMergePanelAction action = new ShowHideMergePanelAction(manager, rootsAndBranches.getStrategy());
        return new VcsCommittedViewAuxiliary(Collections.singletonList(popup), new Runnable(){

            @Override
            public void run() {
                if (SvnCommittedChangesProvider.this.myMergeInfoUpdatesListener != null) {
                    SvnCommittedChangesProvider.this.myMergeInfoUpdatesListener.removePanel(rootsAndBranches);
                    rootsAndBranches.dispose();
                }
            }
        }, Collections.singletonList(action));
    }

    public int getUnlimitedCountValue() {
        return 0;
    }

    public Pair<SvnChangeList, FilePath> getOneList(VirtualFile file, VcsRevisionNumber number) throws VcsException {
        return new SingleCommittedListProvider(this.myVcs, file, number).run();
    }

    public RepositoryLocation getForNonLocal(VirtualFile file) {
        String url = file.getPresentableUrl();
        return new SvnRepositoryLocation(FileUtil.toSystemIndependentName((String)url));
    }

    public boolean supportsIncomingChanges() {
        return true;
    }

    public int getFormatVersion() {
        return 3;
    }

    public void writeChangeList(DataOutput dataStream, SvnChangeList list) throws IOException {
        list.writeToStream(dataStream);
    }

    public SvnChangeList readChangeList(RepositoryLocation location, DataInput stream) throws IOException {
        int version = this.getFormatVersion();
        return new SvnChangeList(this.myVcs, (SvnRepositoryLocation)location, stream, 2 <= version, 3 <= version);
    }

    public boolean isMaxCountSupported() {
        return true;
    }

    @Nullable
    public Collection<FilePath> getIncomingFiles(RepositoryLocation location) throws VcsException {
        FilePath root = null;
        if (Registry.is((String)"svn.use.incoming.optimization") && (root = ((SvnRepositoryLocation)location).getRoot()) == null) {
            LOG.info("Working copy root is not provided for repository location " + location);
        }
        return root != null ? this.getIncomingFiles(root) : null;
    }

    @NotNull
    private Collection<FilePath> getIncomingFiles(@NotNull FilePath root) throws SvnBindException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getIncomingFiles"));
        }
        final HashSet result = ContainerUtil.newHashSet();
        File rootFile = root.getIOFile();
        try {
            this.myVcs.getFactory(rootFile).createStatusClient().doStatus(rootFile, SVNRevision.UNDEFINED, SVNDepth.INFINITY, true, false, false, false, new ISVNStatusHandler(){

                public void handleStatus(SVNStatus status) throws SVNException {
                    boolean changedOnServer;
                    File file = status.getFile();
                    boolean bl = changedOnServer = SvnCommittedChangesProvider.isNotNone(status.getRemoteContentsStatus()) || SvnCommittedChangesProvider.isNotNone(status.getRemoteNodeStatus()) || SvnCommittedChangesProvider.isNotNone(status.getRemotePropertiesStatus());
                    if (file != null && changedOnServer) {
                        result.add(VcsUtil.getFilePath((File)file, (boolean)file.isDirectory()));
                    }
                }
            }, null);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getIncomingFiles"));
        }
        return hashSet;
    }

    private static boolean isNotNone(@Nullable SVNStatusType status) {
        return status != null && !SVNStatusType.STATUS_NONE.equals(status);
    }

    public boolean refreshCacheByNumber() {
        return true;
    }

    public String getChangelistTitle() {
        return SvnBundle.message("changes.browser.revision.term", new Object[0]);
    }

    public boolean isChangeLocallyAvailable(FilePath filePath, @Nullable VcsRevisionNumber localRevision, VcsRevisionNumber changeRevision, SvnChangeList changeList) {
        return localRevision != null && localRevision.compareTo((Object)changeRevision) >= 0;
    }

    public boolean refreshIncomingWithCommitted() {
        return true;
    }

    public void deactivate() {
        this.myConnection.disconnect();
    }
}

