/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConsumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.history.TreeStructureNode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;

public class MergeSourceHierarchyBuilder
implements ThrowableConsumer<Pair<SVNLogEntry, Integer>, SVNException> {
    private TreeStructureNode<SVNLogEntry> myCurrentHierarchy;
    @NotNull
    private final Consumer<TreeStructureNode<SVNLogEntry>> myConsumer;

    public MergeSourceHierarchyBuilder(@NotNull Consumer<TreeStructureNode<SVNLogEntry>> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/history/MergeSourceHierarchyBuilder", "<init>"));
        }
        this.myConsumer = consumer;
    }

    public void consume(Pair<SVNLogEntry, Integer> svnLogEntryIntegerPair) throws SVNException {
        SVNLogEntry logEntry = (SVNLogEntry)svnLogEntryIntegerPair.getFirst();
        Integer mergeLevel = (Integer)svnLogEntryIntegerPair.getSecond();
        if (mergeLevel < 0) {
            if (this.myCurrentHierarchy != null) {
                this.myConsumer.consume(this.myCurrentHierarchy);
            }
            if (logEntry.hasChildren()) {
                this.myCurrentHierarchy = new TreeStructureNode<SVNLogEntry>(logEntry);
            } else {
                this.myCurrentHierarchy = null;
                this.myConsumer.consume(new TreeStructureNode<SVNLogEntry>(logEntry));
            }
        } else {
            MergeSourceHierarchyBuilder.addToLevel(this.myCurrentHierarchy, logEntry, mergeLevel);
        }
    }

    public void finish() {
        if (this.myCurrentHierarchy != null) {
            this.myConsumer.consume(this.myCurrentHierarchy);
        }
    }

    private static void addToLevel(TreeStructureNode<SVNLogEntry> tree, SVNLogEntry entry, int left) {
        assert (tree != null);
        if (left == 0) {
            tree.add(entry);
        } else {
            List<TreeStructureNode<SVNLogEntry>> children = tree.getChildren();
            assert (!children.isEmpty());
            MergeSourceHierarchyBuilder.addToLevel(children.get(children.size() - 1), entry, left - 1);
        }
    }
}

