/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.util.Consumer;
import com.intellij.util.containers.hash.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.CopyData;
import org.jetbrains.idea.svn.history.SvnPathThroughHistoryCorrection;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class FirstInBranch
implements Runnable {
    private final SvnVcs myVcs;
    private final String myBranchUrl;
    private final String myTrunkUrl;
    private final String myRepositoryRoot;
    private final TransparentlyFailedValueI<CopyData, SVNException> myConsumer;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.history.FirstInBranch");

    public FirstInBranch(SvnVcs vcs, String repositoryRoot, String branchUrl, String trunkUrl, TransparentlyFailedValueI<CopyData, SVNException> consumer) {
        this.myVcs = vcs;
        this.myRepositoryRoot = repositoryRoot;
        this.myConsumer = consumer;
        this.myBranchUrl = this.relativePath(repositoryRoot, branchUrl);
        this.myTrunkUrl = this.relativePath(repositoryRoot, trunkUrl);
    }

    private String relativePath(String parent, String child) {
        String path = SVNPathUtil.getRelativePath((String)parent, (String)child);
        return path.startsWith("/") ? path : "/" + path;
    }

    @Override
    public void run() {
        HashSet exceptions = new HashSet();
        final boolean[] called = new boolean[1];
        try {
            this.createTask(SVNURL.parseURIDecoded((String)this.myRepositoryRoot), (Set<SVNException>)exceptions).consume((Object)new Consumer<CopyData>(){

                public void consume(CopyData data) {
                    if (data != null) {
                        FirstInBranch.this.myConsumer.set((Object)data);
                        called[0] = true;
                    }
                }
            });
        }
        catch (SVNException e) {
            this.myConsumer.fail((Exception)((Object)e));
            return;
        }
        if (called[0]) {
            return;
        }
        if (!exceptions.isEmpty()) {
            LOG.info("Wasn't able to find branch point, exception(s) below");
            for (SVNException exception : exceptions) {
                LOG.info((Throwable)exception);
            }
            this.myConsumer.fail((Exception)exceptions.iterator().next());
        } else if (!called[0]) {
            this.myConsumer.set(null);
        }
    }

    private Consumer<Consumer<CopyData>> createTask(final SVNURL branchURL, final Set<SVNException> exceptions) {
        return new Consumer<Consumer<CopyData>>(){

            public void consume(Consumer<CopyData> copyDataConsumer) {
                SVNLogClient logClient = (SVNLogClient)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SVNLogClient>(){

                    public SVNLogClient compute() {
                        if (FirstInBranch.this.myVcs.getProject().isDisposed()) {
                            return null;
                        }
                        return FirstInBranch.this.myVcs.createLogClient();
                    }
                });
                if (logClient == null) {
                    return;
                }
                try {
                    logClient.doLog(branchURL, null, SVNRevision.UNDEFINED, SVNRevision.HEAD, SVNRevision.create((long)0L), false, true, -1L, (ISVNLogEntryHandler)new MyLogEntryHandler(copyDataConsumer, FirstInBranch.this.myTrunkUrl, FirstInBranch.this.myBranchUrl));
                }
                catch (SVNCancelException e) {
                }
                catch (SVNException e) {
                    exceptions.add(e);
                }
            }
        };
    }

    private static class MyLogEntryHandler
    implements ISVNLogEntryHandler {
        private final SvnPathThroughHistoryCorrection myTrunkCorrector;
        private final SvnPathThroughHistoryCorrection myBranchCorrector;
        private final Consumer<CopyData> myCopyDataConsumer;

        public MyLogEntryHandler(Consumer<CopyData> copyDataConsumer, String trunkUrl, String branchUrl) {
            this.myCopyDataConsumer = copyDataConsumer;
            this.myTrunkCorrector = new SvnPathThroughHistoryCorrection(trunkUrl);
            this.myBranchCorrector = new SvnPathThroughHistoryCorrection(branchUrl);
        }

        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            Map map = logEntry.getChangedPaths();
            this.checkEntries(logEntry, map);
            this.myTrunkCorrector.handleLogEntry(logEntry);
            this.myBranchCorrector.handleLogEntry(logEntry);
            this.checkEntries(logEntry, map);
        }

        private void checkEntries(SVNLogEntry logEntry, Map map) throws SVNCancelException {
            for (Object o : map.values()) {
                SVNLogEntryPath path = (SVNLogEntryPath)o;
                String localPath = path.getPath();
                String copyPath = path.getCopyPath();
                if ('A' != path.getType() || !this.checkForCopyCase(logEntry, path, localPath, copyPath, this.myTrunkCorrector.getCurrentPath(), this.myBranchCorrector.getCurrentPath())) continue;
                throw new SVNCancelException();
            }
        }

        private boolean checkForCopyCase(SVNLogEntry logEntry, SVNLogEntryPath path, String localPath, String copyPath, String trunkUrl, String branchUrl) {
            if (MyLogEntryHandler.equalOrParent(localPath, branchUrl) && MyLogEntryHandler.equalOrParent(copyPath, trunkUrl)) {
                this.myCopyDataConsumer.consume((Object)new CopyData(path.getCopyRevision(), logEntry.getRevision(), true));
                return true;
            }
            if (MyLogEntryHandler.equalOrParent(copyPath, branchUrl) && MyLogEntryHandler.equalOrParent(localPath, trunkUrl)) {
                this.myCopyDataConsumer.consume((Object)new CopyData(path.getCopyRevision(), logEntry.getRevision(), false));
                return true;
            }
            return false;
        }

        private static boolean equalOrParent(String localPath, String targetPath) {
            return targetPath.equals(localPath) || SVNPathUtil.isAncestor((String)localPath, (String)targetPath);
        }
    }
}

