/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnProgressCanceller;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.diff.ElementWithBranchComparer;
import org.jetbrains.idea.svn.status.SvnDiffEditor;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNReporter;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc17.SVNReporter17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class DirectoryWithBranchComparer
extends ElementWithBranchComparer {
    @NotNull
    private final StringBuilder titleBuilder;
    @NotNull
    private final List<Change> changes;

    public DirectoryWithBranchComparer(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull String branchUrl, long branchRevision) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/diff/DirectoryWithBranchComparer", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/diff/DirectoryWithBranchComparer", "<init>"));
        }
        if (branchUrl == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/diff/DirectoryWithBranchComparer", "<init>"));
        }
        super(project, virtualFile, branchUrl, branchRevision);
        this.titleBuilder = new StringBuilder();
        this.changes = new ArrayList<Change>();
    }

    @Override
    protected void compare() throws SVNException, VcsException {
        this.titleBuilder.append(SvnBundle.message("repository.browser.compare.title", this.myElementUrl, FileUtil.toSystemDependentName((String)this.myVirtualFile.getPresentableUrl())));
        File ioFile = new File(this.myVirtualFile.getPath());
        WorkingCopyFormat format = this.myVcs.getWorkingCopyFormat(ioFile);
        if (WorkingCopyFormat.ONE_DOT_EIGHT.equals((Object)format)) {
            this.compareWithCommandLine();
        } else if (WorkingCopyFormat.ONE_DOT_SEVEN.equals((Object)format)) {
            this.report17DirDiff();
        } else {
            this.report16DirDiff();
        }
    }

    private void compareWithCommandLine() throws VcsException {
        SvnTarget target1 = SvnTarget.fromFile((File)new File(this.myVirtualFile.getPath()));
        SvnTarget target2 = SvnTarget.fromURL((SVNURL)this.myElementUrl);
        this.changes.addAll(this.myVcs.getFactory(target1).createDiffClient().compare(target1, target2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void report17DirDiff() throws SVNException {
        SVNErrorMessage err;
        File ioFile = new File(this.myVirtualFile.getPath());
        SVNInfo info1 = this.myVcs.getInfo(ioFile, SVNRevision.HEAD);
        if (info1 == null) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_NOT_FOUND, (String)"''{0}'' is not under version control", (Object)this.myVirtualFile.getPath());
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.WC);
        } else if (info1.getURL() == null) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_MISSING_URL, (String)"''{0}'' has no URL", (Object)this.myVirtualFile.getPath());
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.WC);
        }
        SVNReporter17 reporter17 = new SVNReporter17(ioFile, new SVNWCContext(SvnConfiguration.getInstance(this.myProject).getOptions(this.myProject), new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) throws SVNException {
            }

            public void checkCancelled() throws SVNCancelException {
            }
        }), false, true, SVNDepth.INFINITY, false, false, true, false, SVNDebugLog.getDefaultLog());
        SVNRepository repository = null;
        SVNRepository repository2 = null;
        try {
            repository = this.myVcs.createRepository(info1.getURL());
            long rev = repository.getLatestRevision();
            repository2 = this.myVcs.createRepository(this.myElementUrl.toString());
            SvnDiffEditor diffEditor = new SvnDiffEditor(this.myVirtualFile, repository2, rev, true);
            repository.diff(this.myElementUrl, rev, rev, null, true, SVNDepth.INFINITY, false, (ISVNReporterBaton)reporter17, SVNCancellableEditor.newInstance((ISVNEditor)diffEditor, (ISVNCanceller)new SvnProgressCanceller(), null));
            this.changes.addAll(diffEditor.getChangesMap().values());
        }
        finally {
            if (repository != null) {
                repository.closeSession();
            }
            if (repository2 != null) {
                repository2.closeSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void report16DirDiff() throws SVNException {
        SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
        wcAccess.setOptions(this.myVcs.getSvnOptions());
        SVNRepository repository = null;
        SVNRepository repository2 = null;
        try {
            SVNErrorMessage err;
            SVNAdminAreaInfo info = wcAccess.openAnchor(new File(this.myVirtualFile.getPath()), false, -1);
            File anchorPath = info.getAnchor().getRoot();
            String target = "".equals(info.getTargetName()) ? null : info.getTargetName();
            SVNEntry anchorEntry = info.getAnchor().getEntry("", false);
            if (anchorEntry == null) {
                err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_NOT_FOUND, (String)"''{0}'' is not under version control", (Object)anchorPath);
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.WC);
            } else if (anchorEntry.getURL() == null) {
                err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_MISSING_URL, (String)"''{0}'' has no URL", (Object)anchorPath);
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.WC);
            }
            SVNURL anchorURL = anchorEntry.getSVNURL();
            SVNReporter reporter = new SVNReporter(info, info.getAnchor().getFile(info.getTargetName()), false, true, SVNDepth.INFINITY, false, false, true, SVNDebugLog.getDefaultLog());
            repository = this.myVcs.createRepository(anchorURL.toString());
            long rev = repository.getLatestRevision();
            repository2 = this.myVcs.createRepository(target == null ? this.myElementUrl.toString() : this.myElementUrl.removePathTail().toString());
            SvnDiffEditor diffEditor = new SvnDiffEditor(target == null ? this.myVirtualFile : this.myVirtualFile.getParent(), repository2, rev, true);
            repository.diff(this.myElementUrl, rev, rev, target, true, true, false, (ISVNReporterBaton)reporter, SVNCancellableEditor.newInstance((ISVNEditor)diffEditor, (ISVNCanceller)new SvnProgressCanceller(), null));
            this.changes.addAll(diffEditor.getChangesMap().values());
        }
        finally {
            wcAccess.close();
            if (repository != null) {
                repository.closeSession();
            }
            if (repository2 != null) {
                repository2.closeSession();
            }
        }
    }

    @Override
    protected void onCancel() {
        this.changes.clear();
    }

    @Override
    protected void showResult() {
        if (!this.changes.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showWhatDiffersBrowser(null, this.changes, this.titleBuilder.toString());
        }
    }

    @Override
    public String getTitle() {
        return SvnBundle.message("progress.computing.difference", new Object[0]);
    }
}

