/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnStatusConvertor;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.commandLine.SvnStatusHandler;
import org.jetbrains.idea.svn.diff.DiffClient;
import org.jetbrains.idea.svn.history.SvnRepositoryContentRevision;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdDiffClient
extends BaseSvnClient
implements DiffClient {
    @Override
    public List<Change> compare(@NotNull SvnTarget target1, @NotNull SvnTarget target2) throws VcsException {
        if (target1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/diff/CmdDiffClient", "compare"));
        }
        if (target2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/diff/CmdDiffClient", "compare"));
        }
        this.assertDirectory(target1);
        this.assertUrl(target2);
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target1);
        CommandUtil.put(parameters, target2);
        parameters.add("--xml");
        parameters.add("--summarize");
        CommandExecutor executor = CommandUtil.execute(this.myVcs, target1, SvnCommandName.diff, parameters, null);
        return this.parseOutput(target1, target2, executor);
    }

    private List<Change> parseOutput(@NotNull SvnTarget target1, @NotNull SvnTarget target2, @NotNull CommandExecutor executor) throws SvnBindException {
        if (target1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/diff/CmdDiffClient", "parseOutput"));
        }
        if (target2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/diff/CmdDiffClient", "parseOutput"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/diff/CmdDiffClient", "parseOutput"));
        }
        try {
            DiffInfo diffInfo = CommandUtil.parse(executor.getOutput(), DiffInfo.class);
            ArrayList result = ContainerUtil.newArrayList();
            if (diffInfo != null && diffInfo.paths != null) {
                for (DiffPath path : diffInfo.paths.diffPaths) {
                    result.add(this.createChange(target1, target2, path));
                }
            }
            return result;
        }
        catch (JAXBException e) {
            throw new SvnBindException(e);
        }
    }

    private ContentRevision createRemoteRevision(@NotNull FilePath remotePath, @NotNull FilePath localPath, @NotNull FileStatus status) {
        if (remotePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/diff/CmdDiffClient", "createRemoteRevision"));
        }
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/diff/CmdDiffClient", "createRemoteRevision"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/diff/CmdDiffClient", "createRemoteRevision"));
        }
        return SvnRepositoryContentRevision.create(this.myVcs, remotePath, (FilePath)(status == FileStatus.DELETED ? localPath : null), SVNRevision.HEAD.getNumber());
    }

    private static ContentRevision createLocalRevision(@NotNull FilePath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/diff/CmdDiffClient", "createLocalRevision"));
        }
        return CurrentContentRevision.create((FilePath)path);
    }

    @NotNull
    private Change createChange(@NotNull SvnTarget target1, @NotNull SvnTarget target2, @NotNull DiffPath diffPath) throws SvnBindException {
        if (target1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/diff/CmdDiffClient", "createChange"));
        }
        if (target2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/diff/CmdDiffClient", "createChange"));
        }
        if (diffPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/diff/CmdDiffClient", "createChange"));
        }
        File oldTarget = CommandUtil.resolvePath(target1.getFile(), diffPath.path);
        String relativePath = FileUtil.getRelativePath((File)target1.getFile(), (File)oldTarget);
        if (relativePath == null) {
            throw new SvnBindException("Could not get relative path for " + target1.getFile() + " and " + oldTarget);
        }
        FilePath localPath = VcsUtil.getFilePath((File)oldTarget, (boolean)diffPath.isDirectory());
        FilePath remotePath = VcsUtil.getFilePathOnNonLocal((String)SVNPathUtil.append((String)target2.getPathOrUrlDecodedString(), (String)FileUtil.toSystemIndependentName((String)relativePath)), (boolean)diffPath.isDirectory());
        FileStatus status = SvnStatusConvertor.convertStatus(SvnStatusHandler.getStatus(diffPath.itemStatus), SvnStatusHandler.getStatus(diffPath.propertiesStatus));
        ContentRevision beforeRevision = status == FileStatus.ADDED ? null : this.createRemoteRevision(remotePath, localPath, status);
        ContentRevision afterRevision = status == FileStatus.DELETED ? null : CmdDiffClient.createLocalRevision(localPath);
        Change change = CmdDiffClient.createChange(status, beforeRevision, afterRevision);
        if (change == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/diff/CmdDiffClient", "createChange"));
        }
        return change;
    }

    @NotNull
    private static Change createChange(@NotNull FileStatus status, @Nullable ContentRevision beforeRevision, @Nullable ContentRevision afterRevision) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/diff/CmdDiffClient", "createChange"));
        }
        Change change = new Change(beforeRevision, afterRevision, status){

            public boolean isRenamed() {
                return false;
            }

            public boolean isMoved() {
                return false;
            }
        };
        if (change == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/diff/CmdDiffClient", "createChange"));
        }
        return change;
    }

    public static class DiffPath {
        @XmlAttribute(name="kind")
        public String kind;
        @XmlAttribute(name="props")
        public String propertiesStatus;
        @XmlAttribute(name="item")
        public String itemStatus;
        @XmlValue
        public String path;

        public boolean isDirectory() {
            return SVNNodeKind.DIR.equals(SVNNodeKind.parseKind((String)this.kind));
        }
    }

    public static class DiffPaths {
        @XmlElement(name="path")
        public List<DiffPath> diffPaths = new ArrayList<DiffPath>();
    }

    @XmlRootElement(name="diff")
    public static class DiffInfo {
        @XmlElement(name="paths")
        public DiffPaths paths;
    }
}

