/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import java.util.List;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.NodeLoadState;
import org.jetbrains.idea.svn.dialogs.browserCache.SvnRepositoryCache;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorMessage;

public abstract class Loader {
    protected final SvnRepositoryCache myCache;

    protected Loader(SvnRepositoryCache cache) {
        this.myCache = cache;
    }

    public abstract void load(RepositoryTreeNode var1, Expander var2);

    public abstract void forceRefresh(String var1);

    protected abstract NodeLoadState getNodeLoadState();

    protected void refreshNodeError(RepositoryTreeNode node, SVNErrorMessage text) {
        if (node.isDisposed()) {
            return;
        }
        RepositoryTreeNode existingNode = node.getNodeWithSamePathUnderModelRoot();
        if (existingNode == null) {
            return;
        }
        if (existingNode.isDisposed()) {
            return;
        }
        existingNode.setErrorNode(text, this.getNodeLoadState());
    }

    protected void refreshNode(RepositoryTreeNode node, List<SVNDirEntry> data, Expander expander) {
        if (node.isDisposed()) {
            return;
        }
        RepositoryTreeNode existingNode = node.getNodeWithSamePathUnderModelRoot();
        if (existingNode == null) {
            return;
        }
        if (existingNode.isDisposed()) {
            return;
        }
        expander.onBeforeRefresh(existingNode);
        existingNode.setChildren(data, this.getNodeLoadState());
        expander.onAfterRefresh(existingNode);
    }
}

