/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.DepthCombo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.dialogs.browser.MessageBoxCellRenderer;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNURL;

public class ImportOptionsDialog
extends DialogWrapper
implements ActionListener {
    private final SVNURL myURL;
    private final File myFile;
    private TextFieldWithBrowseButton myPathField;
    private DepthCombo myDepth;
    private JCheckBox myIncludeIgnoredCheckbox;
    private JTextArea myCommitMessage;
    private final Project myProject;

    public ImportOptionsDialog(Project project, SVNURL url, File target) {
        super(project, true);
        this.myURL = url;
        this.myFile = target;
        this.myProject = project;
        this.setTitle("SVN Import Options");
        this.init();
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn4idea.import.options";
    }

    public File getTarget() {
        return new File(this.myPathField.getText());
    }

    public SVNDepth getDepth() {
        return this.myDepth.getDepth();
    }

    public boolean isIncludeIgnored() {
        return this.myIncludeIgnoredCheckbox.isSelected();
    }

    public String getCommitMessage() {
        return this.myCommitMessage.getText();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(2, 2, 2, 2);
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 17;
        gc.fill = 0;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        panel.add((Component)new JLabel("Import to:"), gc);
        ++gc.gridx;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        gc.fill = 2;
        JLabel urlLabel = new JLabel(this.myURL.toString());
        urlLabel.setFont(urlLabel.getFont().deriveFont(1));
        panel.add((Component)urlLabel, gc);
        ++gc.gridy;
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.fill = 0;
        panel.add((Component)new JLabel("Import from:"), gc);
        ++gc.gridx;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        gc.fill = 2;
        this.myPathField = new TextFieldWithBrowseButton((ActionListener)this);
        this.myPathField.setText(this.myFile.getAbsolutePath());
        this.myPathField.setEditable(false);
        panel.add((Component)this.myPathField, gc);
        ++gc.gridy;
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.gridwidth = 3;
        gc.fill = 0;
        JLabel depthLabel = new JLabel(SvnBundle.message("label.depth.text", new Object[0]));
        depthLabel.setToolTipText(SvnBundle.message("label.depth.description", new Object[0]));
        panel.add((Component)depthLabel, gc);
        ++gc.gridx;
        this.myDepth = new DepthCombo(false);
        panel.add((Component)this.myDepth, gc);
        depthLabel.setLabelFor(this.myDepth);
        gc.gridx = 0;
        ++gc.gridy;
        this.myIncludeIgnoredCheckbox = new JCheckBox("Include ignored resources");
        this.myIncludeIgnoredCheckbox.setSelected(true);
        panel.add((Component)this.myIncludeIgnoredCheckbox, gc);
        ++gc.gridy;
        panel.add((Component)new JLabel("Commit Message:"), gc);
        ++gc.gridy;
        gc.gridwidth = 3;
        gc.gridx = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.anchor = 11;
        gc.fill = 1;
        this.myCommitMessage = new JTextArea(10, 0);
        this.myCommitMessage.setWrapStyleWord(true);
        this.myCommitMessage.setLineWrap(true);
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myCommitMessage), gc);
        ++gc.gridy;
        gc.gridwidth = 3;
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.anchor = 11;
        gc.fill = 2;
        panel.add((Component)new JLabel("Recent Messages: "), gc);
        ++gc.gridy;
        ArrayList messages = VcsConfiguration.getInstance((Project)this.myProject).getRecentMessages();
        Collections.reverse(messages);
        String[] model = ArrayUtil.toStringArray((Collection)messages);
        final JComboBox<String> messagesBox = new JComboBox<String>(model);
        messagesBox.setRenderer(new MessageBoxCellRenderer());
        panel.add(messagesBox, gc);
        String lastMessage = VcsConfiguration.getInstance((Project)this.myProject).getLastNonEmptyCommitMessage();
        if (lastMessage != null) {
            this.myCommitMessage.setText(lastMessage);
            this.myCommitMessage.selectAll();
        }
        messagesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportOptionsDialog.this.myCommitMessage.setText(messagesBox.getSelectedItem().toString());
                ImportOptionsDialog.this.myCommitMessage.selectAll();
            }
        });
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCommitMessage;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setTitle("Checkout Directory");
        fcd.setDescription("Select directory to checkout from subversion");
        fcd.setHideIgnored(false);
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)fcd, (Component)this.getContentPane(), (Project)this.myProject, null);
        if (file == null) {
            return;
        }
        this.myPathField.setText(file.getPath().replace('/', File.separatorChar));
    }
}

