/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.dialogs.WCPaths;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class WCInfo
implements WCPaths {
    private final boolean myIsWcRoot;
    private final SVNDepth myStickyDepth;
    private final RootUrlInfo myRootInfo;

    public WCInfo(@NotNull RootUrlInfo rootInfo, boolean isWcRoot, SVNDepth stickyDepth) {
        if (rootInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/dialogs/WCInfo", "<init>"));
        }
        this.myRootInfo = rootInfo;
        this.myIsWcRoot = isWcRoot;
        this.myStickyDepth = stickyDepth;
    }

    public SVNDepth getStickyDepth() {
        return this.myStickyDepth;
    }

    @Override
    public String getPath() {
        return this.myRootInfo.getPath();
    }

    @Override
    public VirtualFile getVcsRoot() {
        return null;
    }

    public SVNURL getUrl() {
        return this.myRootInfo.getAbsoluteUrlAsUrl();
    }

    @Override
    public String getRootUrl() {
        return this.getUrl().toString();
    }

    @Override
    public String getRepoUrl() {
        return this.getRepositoryRoot();
    }

    public RootUrlInfo getRootInfo() {
        return this.myRootInfo;
    }

    public boolean hasError() {
        return this.getRootInfo().getNode().hasError();
    }

    public String getErrorMessage() {
        SVNException error = this.getRootInfo().getNode().getError();
        return error != null ? error.getMessage() : "";
    }

    public WorkingCopyFormat getFormat() {
        return this.myRootInfo.getFormat();
    }

    public String getRepositoryRoot() {
        return this.myRootInfo.getRepositoryUrl();
    }

    public boolean isIsWcRoot() {
        return this.myIsWcRoot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WCInfo)) {
            return false;
        }
        WCInfo wcInfo = (WCInfo)o;
        String path = this.getPath();
        return !(path != null ? !path.equals(wcInfo.getPath()) : wcInfo.getPath() != null);
    }

    public int hashCode() {
        String path = this.getPath();
        return path != null ? path.hashCode() : 0;
    }

    public NestedCopyType getType() {
        return this.myRootInfo.getType();
    }
}

