/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.QuantitySelection;
import com.intellij.openapi.vcs.SelectionResult;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListDecorator;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListRenderer;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.RepositoryChangesBrowser;
import com.intellij.openapi.vcs.changes.issueLinks.AbstractBaseTagMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.ClickListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableViewSpeedSearch;
import com.intellij.ui.table.TableView;
import com.intellij.util.Alarm;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.MoreAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.dialogs.BasePageEngine;
import org.jetbrains.idea.svn.dialogs.MergeDialogI;
import org.jetbrains.idea.svn.dialogs.PageEngine;
import org.jetbrains.idea.svn.dialogs.PagedListWithActions;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.mergeinfo.ListMergeStatus;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;

public class ToBeMergedDialog
extends DialogWrapper
implements MergeDialogI {
    public static final int MERGE_ALL_CODE = 222;
    private final JPanel myPanel;
    private final Project myProject;
    private final PageEngine<List<CommittedChangeList>> myListsEngine;
    private final Alarm myAlarm;
    private TableView<CommittedChangeList> myRevisionsList;
    private RepositoryChangesBrowser myRepositoryChangesBrowser;
    private Splitter mySplitter;
    private final QuantitySelection<Long> myWiseSelection;
    private final Set<Change> myAlreadyMerged;
    private final List<CommittedChangeList> myLists;
    private final PairConsumer<Long, MergeDialogI> myMoreLoader;
    private final MergeChecker myMergeChecker;
    private final boolean myAlreadyCalculatedState;
    private volatile boolean myEverythingLoaded;
    private final Map<Long, ListMergeStatus> myStatusMap;
    private MoreXAction myMore100Action;
    private MoreXAction myMore500Action;
    private static final ColumnInfo FAKE_COLUMN = new ColumnInfo<CommittedChangeList, CommittedChangeList>("fake column"){

        public CommittedChangeList valueOf(CommittedChangeList committedChangeList) {
            return committedChangeList;
        }
    };

    public ToBeMergedDialog(Project project, List<CommittedChangeList> lists, String title, MergeChecker mergeChecker, PairConsumer<Long, MergeDialogI> moreLoader) {
        super(project, true);
        this.myLists = lists;
        this.myMoreLoader = moreLoader;
        this.myEverythingLoaded = moreLoader == null;
        this.myStatusMap = Collections.synchronizedMap(new HashMap());
        this.myMergeChecker = mergeChecker;
        this.myAlreadyCalculatedState = moreLoader == null;
        this.setTitle(title);
        this.myProject = project;
        this.myListsEngine = new BasePageEngine<CommittedChangeList>(lists, lists.size());
        this.myPanel = new JPanel(new BorderLayout());
        this.myWiseSelection = new QuantitySelection(this.myEverythingLoaded);
        this.myAlreadyMerged = new HashSet<Change>();
        this.setOKButtonText("Merge Selected");
        this.initUI();
        this.init();
        this.enableMore();
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.getDisposable());
        if (!this.myAlreadyCalculatedState) {
            this.refreshListStatus();
        }
    }

    private void enableMore() {
        this.myMore100Action.setVisible(!this.myEverythingLoaded);
        this.myMore500Action.setVisible(!this.myEverythingLoaded);
        this.myMore100Action.setEnabled(!this.myEverythingLoaded);
        this.myMore500Action.setEnabled(!this.myEverythingLoaded);
    }

    @Override
    public void setEverythingLoaded(boolean everythingLoaded) {
        this.myEverythingLoaded = everythingLoaded;
        this.myMore100Action.setVisible(false);
        this.myMore500Action.setVisible(false);
    }

    @Override
    public long getLastNumber() {
        return this.myLists.get(this.myLists.size() - 1).getNumber();
    }

    @Override
    public void addMoreLists(List<CommittedChangeList> list) {
        this.myListsEngine.getCurrent().addAll(list);
        this.myRevisionsList.revalidate();
        this.myRevisionsList.repaint();
        this.myMore100Action.setEnabled(true);
        this.myMore500Action.setEnabled(true);
        this.myMore500Action.setVisible(true);
        this.refreshListStatus();
    }

    public void refreshListStatus() {
        if (this.myAlarm.isDisposed()) {
            return;
        }
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                int cnt = 10;
                for (CommittedChangeList list : ToBeMergedDialog.this.myLists) {
                    SvnMergeInfoCache.MergeCheckResult result = ToBeMergedDialog.this.myMergeChecker.checkList((SvnChangeList)list);
                    if (SvnMergeInfoCache.MergeCheckResult.MERGED.equals((Object)result)) {
                        ToBeMergedDialog.this.myStatusMap.put(list.getNumber(), ListMergeStatus.MERGED);
                    } else if (SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS.equals((Object)result)) {
                        ToBeMergedDialog.this.myStatusMap.put(list.getNumber(), ListMergeStatus.ALIEN);
                    } else if (SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS_PARTLY_MERGED.equals((Object)result)) {
                        ToBeMergedDialog.this.myStatusMap.put(list.getNumber(), ListMergeStatus.NOT_MERGED);
                    } else {
                        ToBeMergedDialog.this.myStatusMap.put(list.getNumber(), ListMergeStatus.REFRESHING);
                    }
                    if (--cnt > 0) continue;
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ToBeMergedDialog.this.myRevisionsList.revalidate();
                            ToBeMergedDialog.this.myRevisionsList.repaint();
                        }
                    });
                    cnt = 10;
                }
                ToBeMergedDialog.this.myRevisionsList.revalidate();
                ToBeMergedDialog.this.myRevisionsList.repaint();
            }
        }, 0);
    }

    @NotNull
    protected Action[] createActions() {
        if (this.myAlreadyCalculatedState) {
            Action[] actionArray = new Action[]{this.getOKAction(), new DialogWrapper.DialogWrapperAction("Merge All"){

                protected void doAction(ActionEvent e) {
                    ToBeMergedDialog.this.close(222);
                }
            }, this.getCancelAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/ToBeMergedDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = super.createActions();
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/ToBeMergedDialog", "createActions"));
        }
        return actionArray;
    }

    public List<CommittedChangeList> getSelected() {
        SelectionResult selected = this.myWiseSelection.getSelected();
        SelectionResult unselected = this.myWiseSelection.getUnselected();
        LinkedList<CommittedChangeList> result = new LinkedList<CommittedChangeList>();
        result.addAll((Collection)this.myListsEngine.getCurrent());
        while (this.myListsEngine.hasNext()) {
            result.addAll((Collection)this.myListsEngine.next());
        }
        if (selected.isAll()) {
            Set excluded = unselected.getMarked();
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                CommittedChangeList list = (CommittedChangeList)iterator.next();
                if (!excluded.contains(list.getNumber())) continue;
                iterator.remove();
            }
        } else {
            Set included = selected.getMarked();
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                CommittedChangeList list = (CommittedChangeList)iterator.next();
                if (included.contains(list.getNumber())) continue;
                iterator.remove();
            }
        }
        return result;
    }

    protected String getDimensionServiceKey() {
        return "org.jetbrains.idea.svn.dialogs.ToBeMergedDialog";
    }

    private void initUI() {
        final ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                List objects = ToBeMergedDialog.this.myRevisionsList.getSelectedObjects();
                ToBeMergedDialog.this.myRepositoryChangesBrowser.setChangesToDisplay(Collections.emptyList());
                ToBeMergedDialog.this.myAlreadyMerged.clear();
                if (!objects.isEmpty()) {
                    List lists = ObjectsConvertor.convert((Collection)objects, (Convertor)new Convertor<Object, CommittedChangeList>(){

                        public CommittedChangeList convert(Object o) {
                            if (o instanceof CommittedChangeList) {
                                CommittedChangeList cl = (CommittedChangeList)o;
                                Collection<String> notMerged = ToBeMergedDialog.this.myMergeChecker.getNotMergedPaths(cl.getNumber());
                                SvnChangeList svnList = (SvnChangeList)cl;
                                HashSet<String> forCheck = new HashSet<String>();
                                forCheck.addAll(svnList.getAddedPaths());
                                forCheck.addAll(svnList.getChangedPaths());
                                forCheck.addAll(svnList.getDeletedPaths());
                                for (String path : forCheck) {
                                    if (notMerged == null || notMerged.isEmpty() || notMerged.contains(path)) continue;
                                    ToBeMergedDialog.this.myAlreadyMerged.add(((SvnChangeList)cl).getByPath(path));
                                }
                                return cl;
                            }
                            return null;
                        }
                    }, (NotNullFunction)ObjectsConvertor.NOT_NULL);
                    List changes = CommittedChangesTreeBrowser.collectChanges((List)lists, (boolean)false);
                    ToBeMergedDialog.this.myRepositoryChangesBrowser.setChangesToDisplay(changes);
                }
                ToBeMergedDialog.this.mySplitter.doLayout();
                ToBeMergedDialog.this.myRepositoryChangesBrowser.repaint();
            }
        };
        final MyListCellRenderer listCellRenderer = new MyListCellRenderer();
        this.myRevisionsList = new TableView<CommittedChangeList>(){

            public TableCellRenderer getCellRenderer(int row, int column) {
                return listCellRenderer;
            }

            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                selectionListener.valueChanged(e);
            }
        };
        this.myRevisionsList.getExpandableItemsHandler().setEnabled(false);
        new TableViewSpeedSearch<CommittedChangeList>(this.myRevisionsList){

            protected String getItemText(@NotNull CommittedChangeList element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/dialogs/ToBeMergedDialog$5", "getItemText"));
                }
                return element.getComment();
            }
        };
        final ListTableModel flatModel = new ListTableModel(new ColumnInfo[]{FAKE_COLUMN});
        this.myRevisionsList.setModelAndUpdateColumns(flatModel);
        this.myRevisionsList.setTableHeader(null);
        this.myRevisionsList.setShowGrid(false);
        AbstractBaseTagMouseListener mouseListener = new AbstractBaseTagMouseListener(){

            public Object getTagAt(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/dialogs/ToBeMergedDialog$6", "getTagAt"));
                }
                JTable table = (JTable)e.getSource();
                int row = table.rowAtPoint(e.getPoint());
                int column = table.columnAtPoint(e.getPoint());
                if (row == -1 || column == -1) {
                    return null;
                }
                listCellRenderer.customizeCellRenderer(table, table.getValueAt(row, column), table.isRowSelected(row), false, row, column);
                return listCellRenderer.myRenderer.getFragmentTagAt(e.getPoint().x - table.getCellRect((int)row, (int)column, (boolean)false).x);
            }
        };
        mouseListener.installOn(this.myRevisionsList);
        PagedListWithActions.InnerComponentManager<CommittedChangeList> listsManager = new PagedListWithActions.InnerComponentManager<CommittedChangeList>(){

            @Override
            public Component getComponent() {
                return ToBeMergedDialog.this.myRevisionsList;
            }

            @Override
            public void setData(List<CommittedChangeList> committedChangeLists) {
                flatModel.setItems(committedChangeLists);
                flatModel.fireTableDataChanged();
            }

            @Override
            public void refresh() {
                ToBeMergedDialog.this.myRevisionsList.revalidate();
                ToBeMergedDialog.this.myRevisionsList.repaint();
            }
        };
        this.myMore100Action = new MoreXAction(100);
        this.myMore500Action = new MoreXAction(500);
        PagedListWithActions<CommittedChangeList> byRevisions = new PagedListWithActions<CommittedChangeList>(this.myListsEngine, listsManager, new AnAction[]{new MySelectAll(), new MyUnselectAll(), this.myMore100Action, this.myMore500Action});
        this.mySplitter = new Splitter(false, 0.7f);
        this.mySplitter.setFirstComponent(byRevisions.getComponent());
        flatModel.setItems(this.myListsEngine.getCurrent());
        flatModel.fireTableDataChanged();
        this.myRepositoryChangesBrowser = new RepositoryChangesBrowser(this.myProject, Collections.emptyList(), Collections.emptyList(), null);
        this.myRepositoryChangesBrowser.getDiffAction().registerCustomShortcutSet(CommonShortcuts.getDiff(), this.myRevisionsList);
        this.setChangesDecorator();
        this.mySplitter.setSecondComponent((JComponent)this.myRepositoryChangesBrowser);
        this.mySplitter.setDividerWidth(2);
        this.addRevisionListListeners();
        this.myPanel.add((Component)this.mySplitter, "Center");
    }

    private void setChangesDecorator() {
        this.myRepositoryChangesBrowser.setDecorator(new ChangeNodeDecorator(){

            public void decorate(Change change, SimpleColoredComponent component, boolean isShowFlatten) {
            }

            public List<Pair<String, ChangeNodeDecorator.Stress>> stressPartsOfFileName(Change change, String parentPath) {
                return null;
            }

            public void preDecorate(Change change, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
                if (ToBeMergedDialog.this.myAlreadyMerged.contains(change)) {
                    renderer.append(" [already merged] ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
            }
        });
    }

    private void addRevisionListListeners() {
        final int checkboxWidth = new JCheckBox().getPreferredSize().width;
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/dialogs/ToBeMergedDialog$9", "onClick"));
                }
                int idx = ToBeMergedDialog.this.myRevisionsList.rowAtPoint(e.getPoint());
                if (idx >= 0) {
                    Rectangle baseRect = ToBeMergedDialog.this.myRevisionsList.getCellRect(idx, 0, false);
                    baseRect.setSize(checkboxWidth, baseRect.height);
                    if (baseRect.contains(e.getPoint())) {
                        SvnChangeList changeList = (SvnChangeList)ToBeMergedDialog.this.myRevisionsList.getModel().getValueAt(idx, 0);
                        long number = changeList.getNumber();
                        ToBeMergedDialog.this.toggleInclusion(number);
                        ToBeMergedDialog.this.myRevisionsList.repaint(baseRect);
                    }
                }
                return true;
            }
        }.installOn(this.myRevisionsList);
        this.myRevisionsList.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (32 == e.getKeyCode()) {
                    List selected = ToBeMergedDialog.this.myRevisionsList.getSelectedObjects();
                    if (selected.isEmpty()) {
                        return;
                    }
                    for (Object o : selected) {
                        if (!(o instanceof SvnChangeList)) continue;
                        SvnChangeList changeList = (SvnChangeList)o;
                        ToBeMergedDialog.this.toggleInclusion(changeList.getNumber());
                    }
                    ToBeMergedDialog.this.myRevisionsList.repaint();
                    e.consume();
                }
            }
        });
    }

    private void toggleInclusion(long number) {
        if (this.myWiseSelection.isSelected((Object)number)) {
            this.myWiseSelection.remove((Object)number);
        } else {
            this.myWiseSelection.add((Object)number);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private class MyListCellRenderer
    implements TableCellRenderer {
        private final JPanel myPanel = new JPanel(new BorderLayout());
        private final CommittedChangeListRenderer myRenderer;
        private JCheckBox myCheckBox = new JCheckBox();

        private MyListCellRenderer() {
            this.myCheckBox.setEnabled(true);
            this.myCheckBox.setSelected(true);
            this.myRenderer = new CommittedChangeListRenderer(ToBeMergedDialog.this.myProject, Collections.singletonList(new CommittedChangeListDecorator(){

                @Nullable
                public Icon decorate(CommittedChangeList list) {
                    if (ToBeMergedDialog.this.myAlreadyCalculatedState) {
                        return ListMergeStatus.NOT_MERGED.getIcon();
                    }
                    ListMergeStatus status = (ListMergeStatus)((Object)ToBeMergedDialog.this.myStatusMap.get(list.getNumber()));
                    if (status != null) {
                        return status.getIcon();
                    }
                    return ListMergeStatus.REFRESHING.getIcon();
                }
            }));
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            this.myPanel.removeAll();
            this.myPanel.setBackground(null);
            this.myRenderer.clear();
            this.myRenderer.setBackground(null);
            if (value instanceof SvnChangeList) {
                SvnChangeList changeList = (SvnChangeList)value;
                this.myRenderer.renderChangeList((JComponent)table, (CommittedChangeList)changeList);
                Color bg = selected ? UIUtil.getTableSelectionBackground() : UIUtil.getTableBackground();
                Color fg = selected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground();
                this.myRenderer.setBackground(bg);
                this.myRenderer.setForeground(fg);
                this.myCheckBox.setBackground(bg);
                this.myCheckBox.setForeground(fg);
                this.myPanel.setBackground(bg);
                this.myPanel.setForeground(fg);
                this.myCheckBox.setSelected(ToBeMergedDialog.this.myWiseSelection.isSelected((Object)changeList.getNumber()));
                this.myPanel.add((Component)this.myCheckBox, "West");
                this.myPanel.add((Component)this.myRenderer, "Center");
            }
        }

        @Override
        public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.customizeCellRenderer(table, value, isSelected, hasFocus, row, column);
            return this.myPanel;
        }
    }

    private class MyUnselectAll
    extends DumbAwareAction {
        private MyUnselectAll() {
            super("Unselect All", "Unselect All", AllIcons.Actions.Unselectall);
        }

        public void actionPerformed(AnActionEvent e) {
            ToBeMergedDialog.this.myWiseSelection.clearAll();
            ToBeMergedDialog.this.myRevisionsList.repaint();
        }
    }

    private class MySelectAll
    extends DumbAwareAction {
        private MySelectAll() {
            super("Select All", "Select All", AllIcons.Actions.Selectall);
        }

        public void actionPerformed(AnActionEvent e) {
            ToBeMergedDialog.this.myWiseSelection.setAll();
            ToBeMergedDialog.this.myRevisionsList.repaint();
        }
    }

    private class MoreXAction
    extends MoreAction {
        private final int myQuantity;

        private MoreXAction(int quantity) {
            super("Load +" + quantity);
            this.myQuantity = quantity;
        }

        public void actionPerformed(AnActionEvent e) {
            ToBeMergedDialog.this.myMore500Action.setVisible(false);
            ToBeMergedDialog.this.myMore100Action.setEnabled(false);
            ToBeMergedDialog.this.myMore500Action.setEnabled(false);
            ToBeMergedDialog.this.myMoreLoader.consume((Object)this.myQuantity, (Object)ToBeMergedDialog.this);
        }
    }
}

