/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;

public class ServerSSLDialog
extends DialogWrapper {
    private final X509Certificate myCertificate;
    private Action myTempAction;
    private int myResult;
    @NonNls
    public static final String ALGORITHM_SHA1 = "SHA1";

    protected ServerSSLDialog(Project project, X509Certificate cert, boolean store) {
        super(project, true);
        this.myCertificate = cert;
        this.myResult = 0;
        this.setOKButtonText(SvnBundle.message("button.text.ssl.accept", new Object[0]));
        this.setOKActionEnabled(store);
        this.setCancelButtonText(SvnBundle.message("button.text.ssl.reject", new Object[0]));
        this.setTitle(SvnBundle.message("dialog.title.ssl.examine.server.crertificate", new Object[0]));
        this.setResizable(true);
        this.init();
    }

    public boolean shouldCloseOnCross() {
        return false;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getTempAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/ServerSSLDialog", "createActions"));
        }
        return actionArray;
    }

    private Action getTempAction() {
        if (this.myTempAction == null) {
            this.myTempAction = new AbstractAction(SvnBundle.message("server.ssl.accept.temporary.action.name", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServerSSLDialog.this.myResult = 1;
                    ServerSSLDialog.this.close(0);
                }
            };
        }
        return this.myTempAction;
    }

    protected void doOKAction() {
        this.myResult = 2;
        super.doOKAction();
    }

    public void doCancelAction() {
        this.myResult = 0;
        super.doCancelAction();
    }

    public int getResult() {
        return this.myResult;
    }

    protected String getDimensionServiceKey() {
        return "svn.sslDialog";
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.add((Component)new JLabel(SvnBundle.message("label.ssl.server.provided.certificate", new Object[0])), "North");
        JTextArea area = new JTextArea(5, 50);
        area.setText(ServerSSLDialog.getServerCertificateInfo(this.myCertificate));
        area.setEditable(false);
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)area), "Center");
        return panel;
    }

    private static String getFingerprint(X509Certificate cert) {
        StringBuffer s = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM_SHA1);
            md.update(cert.getEncoded());
            byte[] digest = md.digest();
            for (int i = 0; i < digest.length; ++i) {
                int b;
                String hex;
                if (i != 0) {
                    s.append(':');
                }
                if ((hex = Integer.toHexString(b = digest[i] & 0xFF)).length() == 1) {
                    s.append('0');
                }
                s.append(hex.toLowerCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s.toString();
    }

    private static String getServerCertificateInfo(X509Certificate cert) {
        StringBuffer info = new StringBuffer();
        info.append(" - Subject: ");
        info.append(cert.getSubjectDN().getName());
        info.append('\n');
        info.append(" - Valid: ");
        info.append("from ").append(cert.getNotBefore()).append(" until ").append(cert.getNotAfter());
        info.append('\n');
        info.append(" - Issuer: ");
        info.append(cert.getIssuerDN().getName());
        info.append('\n');
        info.append(" - Fingerprint: ");
        info.append(ServerSSLDialog.getFingerprint(cert));
        return info.toString();
    }
}

