/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshSessionImpl;
import com.intellij.util.Consumer;
import com.intellij.util.FilePathByPathComparator;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.continuation.Continuation;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.ContinuationPause;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.ChangeListsMergerFactory;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.BranchMerger;
import org.jetbrains.idea.svn.dialogs.LoadRecentBranchRevisions;
import org.jetbrains.idea.svn.dialogs.LocalChangesAction;
import org.jetbrains.idea.svn.dialogs.MergeDialogI;
import org.jetbrains.idea.svn.dialogs.QuickMergeContentsVariants;
import org.jetbrains.idea.svn.dialogs.SvnBranchPointsCalculator;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedChangesProvider;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.history.TreeStructureNode;
import org.jetbrains.idea.svn.integrate.GroupMerger;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.SvnIntegrateChangesTask;
import org.jetbrains.idea.svn.integrate.WorkingCopyInfo;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;
import org.jetbrains.idea.svn.mergeinfo.OneShotMergeInfoHelper;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;

public class QuickMerge {
    private final Project myProject;
    private final String myBranchName;
    private final VirtualFile myRoot;
    private WCInfo myWcInfo;
    private String mySourceUrl;
    private SvnVcs myVcs;
    private final String myTitle;
    private final Continuation myContinuation;
    private QuickMergeInteraction myInteraction;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.dialogs.QuickMerge");

    public QuickMerge(Project project, String sourceUrl, WCInfo wcInfo, String branchName, VirtualFile root) {
        this.myProject = project;
        this.myBranchName = branchName;
        this.myRoot = root;
        this.myVcs = SvnVcs.getInstance(project);
        this.mySourceUrl = sourceUrl;
        this.myWcInfo = wcInfo;
        this.myTitle = "Merge from " + this.myBranchName;
        this.myContinuation = Continuation.createFragmented((Project)this.myProject, (boolean)true);
    }

    public void execute(@NotNull QuickMergeInteraction interaction, TaskDescriptor ... finalTasks) {
        if (interaction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/dialogs/QuickMerge", "execute"));
        }
        if (finalTasks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/dialogs/QuickMerge", "execute"));
        }
        this.myInteraction = interaction;
        this.myInteraction.setTitle(this.myTitle);
        FileDocumentManager.getInstance().saveAllDocuments();
        LinkedList<TaskDescriptor> tasks = new LinkedList<TaskDescriptor>();
        tasks.add(new MyInitChecks());
        tasks.add(new SourceUrlCorrection());
        tasks.add(new CheckRepositorySupportsMergeinfo());
        if (finalTasks.length > 0) {
            tasks.addAll(Arrays.asList(finalTasks));
        }
        this.myContinuation.addExceptionHandler(VcsException.class, (Consumer)new Consumer<VcsException>(){

            public void consume(VcsException e) {
                QuickMerge.this.myInteraction.showErrors(QuickMerge.this.myTitle, Collections.singletonList(e));
            }
        });
        this.myContinuation.addExceptionHandler(SVNException.class, (Consumer)new Consumer<SVNException>(){

            public void consume(SVNException e) {
                QuickMerge.this.myInteraction.showErrors(QuickMerge.this.myTitle, Collections.singletonList(new VcsException((Throwable)e)));
            }
        });
        this.myContinuation.addExceptionHandler(RuntimeException.class, (Consumer)new Consumer<RuntimeException>(){

            public void consume(RuntimeException e) {
                QuickMerge.this.myInteraction.showError(e);
            }
        });
        this.myContinuation.run(tasks);
    }

    private void insertMergeAll(ContinuationContext context) {
        ArrayList<TaskDescriptor> queue = new ArrayList<TaskDescriptor>();
        this.insertMergeAll(queue);
        context.next(queue);
    }

    private boolean checkForSwitchedRoots() {
        List<WCInfo> infoList = this.myVcs.getAllWcInfos();
        boolean switchedFound = false;
        for (WCInfo wcInfo : infoList) {
            if (!FileUtil.isAncestor((File)new File(this.myWcInfo.getPath()), (File)new File(wcInfo.getPath()), (boolean)true) || !NestedCopyType.switched.equals((Object)wcInfo.getType())) continue;
            switchedFound = true;
            break;
        }
        if (switchedFound) {
            return this.myInteraction.shouldContinueSwitchedRootFound();
        }
        return true;
    }

    private void finishWithError(ContinuationContext context, final String message, final List<VcsException> exceptions) {
        if (exceptions != null) {
            for (VcsException exception : exceptions) {
                LOG.info(message, (Throwable)exception);
            }
        }
        context.cancelEverything();
        context.next(new TaskDescriptor[]{new TaskDescriptor(message, Where.AWT){

            public void run(ContinuationContext context) {
                QuickMerge.this.myInteraction.showErrors(message, exceptions);
            }
        }});
    }

    private void finishWithError(ContinuationContext context, final String message, final boolean isError) {
        LOG.info((isError ? "Error: " : "Info: ") + message);
        context.next(new TaskDescriptor[]{new TaskDescriptor(message, Where.AWT){

            public void run(ContinuationContext context) {
                QuickMerge.this.myInteraction.showErrors(message, isError);
                context.cancelEverything();
            }
        }});
    }

    private void insertMergeAll(List<TaskDescriptor> queue) {
        queue.add(new LocalChangesPrompt(true, null, null));
        MergeAllWithBranchCopyPoint mergeAllExecutor = new MergeAllWithBranchCopyPoint();
        queue.add(this.myVcs.getSvnBranchPointsCalculator().getFirstCopyPointTask(this.myWcInfo.getRepositoryRoot(), this.mySourceUrl, this.myWcInfo.getRootUrl(), mergeAllExecutor));
        queue.add(mergeAllExecutor);
    }

    static boolean checkListForPaths(String relativeLocal, String relativeBranch, Pair<SvnChangeList, TreeStructureNode<SVNLogEntry>> pair) {
        List children = ((TreeStructureNode)pair.getSecond()).getChildren();
        boolean localChange = false;
        for (TreeStructureNode<SVNLogEntry> treeStructureNode : children) {
            if (!QuickMerge.checkForSubtree(treeStructureNode, relativeLocal, relativeBranch)) continue;
            localChange = true;
            break;
        }
        if (!localChange) {
            return QuickMerge.checkForEntry((SVNLogEntry)((TreeStructureNode)pair.getSecond()).getMe(), relativeLocal, relativeBranch);
        }
        return localChange;
    }

    private static boolean checkForSubtree(TreeStructureNode<SVNLogEntry> tree, String relativeBranch, String localURL) {
        LinkedList queue = new LinkedList();
        queue.addLast(tree);
        while (!queue.isEmpty()) {
            TreeStructureNode element = (TreeStructureNode)queue.removeFirst();
            ProgressManager.checkCanceled();
            if (QuickMerge.checkForEntry((SVNLogEntry)element.getMe(), localURL, relativeBranch)) {
                return true;
            }
            queue.addAll(element.getChildren());
        }
        return false;
    }

    private static boolean checkForEntry(SVNLogEntry entry, String localURL, String relativeBranch) {
        boolean atLeastOneUnderBranch = false;
        Map map = entry.getChangedPaths();
        for (Object o : map.values()) {
            SVNLogEntryPath path = (SVNLogEntryPath)o;
            if (SVNPathUtil.isAncestor((String)localURL, (String)path.getPath())) {
                return true;
            }
            if (atLeastOneUnderBranch || !SVNPathUtil.isAncestor((String)relativeBranch, (String)path.getPath())) continue;
            atLeastOneUnderBranch = true;
        }
        return !atLeastOneUnderBranch;
    }

    private Intersection getMergeAllIntersection(List<LocalChangeList> localChangeLists) {
        Intersection intersection = new Intersection();
        for (LocalChangeList localChangeList : localChangeLists) {
            Collection localChanges = localChangeList.getChanges();
            for (Change localChange : localChanges) {
                intersection.add(localChangeList.getName(), localChangeList.getComment(), localChange);
            }
        }
        return intersection;
    }

    private static class Intersection {
        private final Map<String, String> myLists = new HashMap<String, String>();
        private final MultiMap<String, Change> myChangesSubset = new MultiMap();

        private Intersection() {
        }

        public void add(@NotNull String listName, @Nullable String comment, Change change) {
            if (listName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/dialogs/QuickMerge$Intersection", "add"));
            }
            this.myChangesSubset.putValue((Object)listName, (Object)change);
            String commentToPut = comment == null ? listName : comment;
            this.myLists.put(listName, commentToPut);
        }

        public String getComment(String listName) {
            return this.myLists.get(listName);
        }

        public MultiMap<String, Change> getChangesSubset() {
            return this.myChangesSubset;
        }
    }

    private class ShelveLocalChanges
    extends TaskDescriptor {
        private final Intersection myIntersection;

        private ShelveLocalChanges(Intersection intersection) {
            super("Shelving local changes before merge", Where.POOLED);
            this.myIntersection = intersection;
        }

        public void run(final ContinuationContext context) {
            MultiMap<String, Change> map = this.myIntersection.getChangesSubset();
            RefreshSessionImpl session = new RefreshSessionImpl(true, false, new Runnable(){

                @Override
                public void run() {
                    context.ping();
                }
            });
            for (String name : map.keySet()) {
                try {
                    Collection changes = map.get((Object)name);
                    ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            FileDocumentManager.getInstance().saveAllDocuments();
                        }
                    }, ModalityState.NON_MODAL);
                    ShelveChangesManager.getInstance((Project)QuickMerge.this.myProject).shelveChanges(changes, this.myIntersection.getComment(name) + " (auto shelve before merge)", true);
                    session.addAllFiles(ChangesUtil.getFilesFromChanges((Collection)changes));
                }
                catch (IOException e) {
                    QuickMerge.this.finishWithError(context, e.getMessage(), true);
                }
                catch (VcsException e) {
                    QuickMerge.this.finishWithError(context, e.getMessage(), true);
                }
            }
            context.suspend();
            session.launch();
        }
    }

    private class LocalChangesPrompt
    extends TaskDescriptor {
        private final boolean myMergeAll;
        @Nullable
        private final List<CommittedChangeList> myLists;
        private final SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData> myCopyPoint;

        private LocalChangesPrompt(@Nullable boolean mergeAll, @Nullable List<CommittedChangeList> lists, SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData> copyPoint) {
            super("local changes intersection check", Where.AWT);
            this.myMergeAll = mergeAll;
            this.myLists = lists;
            this.myCopyPoint = copyPoint;
        }

        @Nullable
        private File getLocalPath(String relativeToRepoPath) {
            String pathToCheck = SVNPathUtil.append((String)QuickMerge.this.myWcInfo.getRepositoryRoot(), (String)relativeToRepoPath);
            SvnBranchPointsCalculator.BranchCopyData wrapped = this.myCopyPoint.getWrapped();
            String relativeInSource = SVNPathUtil.getRelativePath((String)(this.myCopyPoint.isInvertedSense() ? wrapped.getSource() : wrapped.getTarget()), (String)pathToCheck);
            if (StringUtil.isEmptyOrSpaces((String)relativeInSource)) {
                return null;
            }
            File local = new File(QuickMerge.this.myWcInfo.getPath(), relativeInSource);
            return local;
        }

        public void run(ContinuationContext context) {
            ChangeListManager listManager = ChangeListManager.getInstance((Project)QuickMerge.this.myProject);
            List localChangeLists = listManager.getChangeListsCopy();
            Intersection intersection = this.myMergeAll ? QuickMerge.this.getMergeAllIntersection(localChangeLists) : this.checkIntersection(this.myLists, localChangeLists);
            if (intersection == null || intersection.getChangesSubset().isEmpty()) {
                return;
            }
            LocalChangesAction action = QuickMerge.this.myInteraction.selectLocalChangesAction(this.myMergeAll);
            switch (action) {
                case shelve: {
                    context.next(new TaskDescriptor[]{new ShelveLocalChanges(intersection)});
                    return;
                }
                case cancel: {
                    context.cancelEverything();
                    return;
                }
                case continueMerge: {
                    return;
                }
                case inspect: {
                    Collection changes = intersection.getChangesSubset().values();
                    List paths = ChangesUtil.getPaths((Collection)changes);
                    Collections.sort(paths, FilePathByPathComparator.getInstance());
                    QuickMerge.this.myInteraction.showIntersectedLocalPaths(paths);
                    context.cancelEverything();
                    return;
                }
            }
        }

        @Nullable
        private Intersection checkIntersection(@Nullable List<CommittedChangeList> lists, List<LocalChangeList> localChangeLists) {
            if (lists == null || lists.isEmpty()) {
                return null;
            }
            HashSet<FilePathImpl> mergePaths = new HashSet<FilePathImpl>();
            for (CommittedChangeList list : lists) {
                SvnChangeList svnList = (SvnChangeList)list;
                ArrayList<String> paths = new ArrayList<String>(svnList.getAddedPaths());
                paths.addAll(svnList.getChangedPaths());
                paths.addAll(svnList.getDeletedPaths());
                for (String path : paths) {
                    File localPath = this.getLocalPath(path);
                    if (localPath == null) continue;
                    mergePaths.add(new FilePathImpl(localPath, false));
                }
            }
            Intersection intersection = new Intersection();
            for (LocalChangeList localChangeList : localChangeLists) {
                Collection localChanges = localChangeList.getChanges();
                for (Change localChange : localChanges) {
                    FilePath after;
                    FilePath before = localChange.getBeforeRevision() == null ? null : localChange.getBeforeRevision().getFile();
                    FilePath filePath = after = localChange.getAfterRevision() == null ? null : localChange.getAfterRevision().getFile();
                    if ((before == null || !mergePaths.contains(before)) && (after == null || !mergePaths.contains(after))) continue;
                    intersection.add(localChangeList.getName(), localChangeList.getComment(), localChange);
                }
            }
            return intersection;
        }
    }

    private class MergeCalculator
    extends TaskDescriptor
    implements Consumer<TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData>, SVNException>> {
        private static final String ourOneShotStrategy = "svn.quickmerge.oneShotStrategy";
        private final WCInfo myWcInfo;
        private final String mySourceUrl;
        private final String myBranchName;
        private final AtomicReference<TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData>, SVNException>> myCopyData;
        private boolean myIsReintegrate;
        private final List<CommittedChangeList> myNotMerged;
        private String myMergeTitle;
        private final MergeChecker myMergeChecker;

        public void consume(TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData>, SVNException> value) {
            this.myCopyData.set(value);
        }

        private MergeCalculator(WCInfo wcInfo, String sourceUrl, String branchName) throws VcsException {
            super("Calculating not merged revisions", Where.POOLED);
            this.myWcInfo = wcInfo;
            this.mySourceUrl = sourceUrl;
            this.myBranchName = branchName;
            this.myNotMerged = new LinkedList<CommittedChangeList>();
            this.myMergeTitle = "Merge from " + branchName;
            this.myMergeChecker = new OneShotMergeInfoHelper(QuickMerge.this.myProject, this.myWcInfo, this.mySourceUrl);
            ((OneShotMergeInfoHelper)this.myMergeChecker).prepare();
            this.myCopyData = new AtomicReference();
        }

        public void run(ContinuationContext context) {
            SvnBranchPointsCalculator.WrapperInvertor copyDataValue = null;
            try {
                copyDataValue = (SvnBranchPointsCalculator.WrapperInvertor)this.myCopyData.get().get();
            }
            catch (SVNException e) {
                QuickMerge.this.finishWithError(context, "Merge start wasn't found", Collections.singletonList(new VcsException((Throwable)e)));
                return;
            }
            if (copyDataValue == null) {
                QuickMerge.this.finishWithError(context, "Merge start wasn't found", true);
                return;
            }
            final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            this.myIsReintegrate = copyDataValue.isInvertedSense();
            if (!this.myWcInfo.getFormat().supportsMergeInfo()) {
                return;
            }
            SvnBranchPointsCalculator.BranchCopyData data = (SvnBranchPointsCalculator.BranchCopyData)copyDataValue.getTrue();
            final long sourceLatest = data.getTargetRevision();
            SvnCommittedChangesProvider committedChangesProvider = (SvnCommittedChangesProvider)QuickMerge.this.myVcs.getCommittedChangesProvider();
            ChangeBrowserSettings settings = new ChangeBrowserSettings();
            settings.CHANGE_AFTER = Long.toString(sourceLatest);
            settings.USE_CHANGE_AFTER_FILTER = true;
            String local = SVNPathUtil.getRelativePath((String)this.myWcInfo.getRepositoryRoot(), (String)this.myWcInfo.getRootUrl());
            String relativeLocal = local.startsWith("/") ? local : "/" + local;
            String relativeBranch = SVNPathUtil.getRelativePath((String)this.myWcInfo.getRepositoryRoot(), (String)this.mySourceUrl);
            relativeBranch = relativeBranch.startsWith("/") ? relativeBranch : "/" + relativeBranch;
            final LinkedList list = new LinkedList();
            try {
                committedChangesProvider.getCommittedChangesWithMergedRevisons(settings, new SvnRepositoryLocation(this.mySourceUrl), 0, new PairConsumer<SvnChangeList, TreeStructureNode<SVNLogEntry>>(){

                    public void consume(SvnChangeList svnList, TreeStructureNode<SVNLogEntry> tree) {
                        indicator.checkCanceled();
                        if (sourceLatest >= svnList.getNumber()) {
                            return;
                        }
                        list.add(new Pair((Object)svnList, tree));
                    }
                });
            }
            catch (VcsException e) {
                QuickMerge.this.finishWithError(context, "Checking revisions for merge fault", Collections.singletonList(e));
            }
            indicator.setText("Checking merge information...");
            for (Pair pair : list) {
                boolean localChange;
                SvnChangeList svnList = (SvnChangeList)pair.getFirst();
                SvnMergeInfoCache.MergeCheckResult checkResult = this.myMergeChecker.checkList(svnList);
                indicator.setText2("Processing revision " + svnList.getNumber());
                if (!SvnMergeInfoCache.MergeCheckResult.NOT_MERGED.equals((Object)checkResult) || (localChange = QuickMerge.checkListForPaths(relativeLocal, relativeBranch, (Pair<SvnChangeList, TreeStructureNode<SVNLogEntry>>)pair))) continue;
                this.myNotMerged.add(svnList);
            }
            if (this.myNotMerged.isEmpty()) {
                QuickMerge.this.finishWithError(context, "Everything is up-to-date", false);
                return;
            }
            context.next(new TaskDescriptor[]{new ShowRevisionSelector(copyDataValue)});
        }

        private class ShowRevisionSelector
        extends TaskDescriptor {
            private final SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData> myCopyPoint;

            private ShowRevisionSelector(SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData> copyPoint) {
                super("show revisions to merge", Where.AWT);
                this.myCopyPoint = copyPoint;
            }

            public void run(ContinuationContext context) {
                QuickMergeInteraction.SelectMergeItemsResult result = QuickMerge.this.myInteraction.selectMergeItems(MergeCalculator.this.myNotMerged, MergeCalculator.this.myMergeTitle, MergeCalculator.this.myMergeChecker);
                if (QuickMergeContentsVariants.cancel == result.getResultCode()) {
                    context.cancelEverything();
                    return;
                }
                if (QuickMergeContentsVariants.all == result.getResultCode()) {
                    QuickMerge.this.insertMergeAll(context);
                } else {
                    final List<CommittedChangeList> lists = result.getSelectedLists();
                    if (lists.isEmpty()) {
                        return;
                    }
                    ChangeListsMergerFactory factory = new ChangeListsMergerFactory(lists){

                        @Override
                        public IMerger createMerger(SvnVcs vcs, File target, UpdateEventHandler handler, SVNURL currentBranchUrl, String branchName) {
                            return new GroupMerger(vcs, lists, target, handler, currentBranchUrl, branchName, false, false, false);
                        }
                    };
                    context.next(new TaskDescriptor[]{new LocalChangesPrompt(false, lists, this.myCopyPoint), new MergeTask(factory, MergeCalculator.this.myMergeTitle)});
                }
            }
        }
    }

    private class MergeTask
    extends TaskDescriptor {
        private final MergerFactory myFactory;

        private MergeTask(MergerFactory factory, String mergeTitle) {
            super(mergeTitle, Where.AWT);
            this.myFactory = factory;
        }

        public void run(ContinuationContext context) {
            SVNURL sourceUrlUrl;
            try {
                sourceUrlUrl = SVNURL.parseURIEncoded((String)QuickMerge.this.mySourceUrl);
            }
            catch (SVNException e) {
                QuickMerge.this.finishWithError(context, "Cannot merge: " + e.getMessage(), true);
                return;
            }
            SvnIntegrateChangesTask task = new SvnIntegrateChangesTask(SvnVcs.getInstance(QuickMerge.this.myProject), new WorkingCopyInfo(QuickMerge.this.myWcInfo.getPath(), true), this.myFactory, sourceUrlUrl, this.getName(), false, QuickMerge.this.myBranchName);
            TaskDescriptor taskDescriptor = TaskDescriptor.createForBackgroundableTask((Task.Backgroundable)task);
            context.next(new TaskDescriptor[]{taskDescriptor});
            this.createChangelist((ContinuationPause)context);
        }

        private void createChangelist(final ContinuationPause context) {
            ChangeListManager listManager = ChangeListManager.getInstance((Project)QuickMerge.this.myProject);
            String name = QuickMerge.this.myTitle;
            int i = 1;
            boolean updateDefaultList = false;
            while (true) {
                LocalChangeList changeList;
                if ((changeList = listManager.findChangeList(name)) == null) {
                    LocalChangeList newList = listManager.addChangeList(name, null);
                    listManager.setDefaultChangeList(newList);
                    updateDefaultList = true;
                    break;
                }
                if (changeList.getChanges().isEmpty()) {
                    if (changeList.isDefault()) break;
                    listManager.setDefaultChangeList(changeList);
                    updateDefaultList = true;
                    break;
                }
                name = QuickMerge.this.myTitle + " (" + i + ")";
                ++i;
            }
            if (updateDefaultList) {
                context.suspend();
                listManager.invokeAfterUpdate(new Runnable(){

                    @Override
                    public void run() {
                        context.ping();
                    }
                }, InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE_NOT_AWT, "", ModalityState.NON_MODAL);
            }
        }
    }

    private class MergeAllWithBranchCopyPoint
    extends TaskDescriptor
    implements Consumer<TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData>, SVNException>> {
        private final AtomicReference<TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData>, SVNException>> myData;

        private MergeAllWithBranchCopyPoint() {
            super("merge all", Where.AWT);
            this.myData = new AtomicReference();
        }

        public void consume(TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData>, SVNException> value) {
            this.myData.set(value);
        }

        public void run(ContinuationContext context) {
            SvnBranchPointsCalculator.WrapperInvertor invertor;
            try {
                TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData>, SVNException> transparentlyFailedValueI = this.myData.get();
                if (transparentlyFailedValueI == null) {
                    QuickMerge.this.finishWithError(context, "Merge start wasn't found", true);
                    return;
                }
                invertor = (SvnBranchPointsCalculator.WrapperInvertor)transparentlyFailedValueI.get();
            }
            catch (SVNException e) {
                QuickMerge.this.finishWithError(context, "Merge start wasn't found", Collections.singletonList(new VcsException((Throwable)e)));
                return;
            }
            if (invertor == null) {
                QuickMerge.this.finishWithError(context, "Merge start wasn't found", true);
                return;
            }
            boolean reintegrate = invertor.isInvertedSense();
            if (reintegrate && !QuickMerge.this.myInteraction.shouldReintegrate(QuickMerge.this.mySourceUrl, ((SvnBranchPointsCalculator.BranchCopyData)invertor.inverted()).getTarget())) {
                context.cancelEverything();
                return;
            }
            MergerFactory mergerFactory = this.createBranchMergerFactory(reintegrate, invertor);
            String title = "Merging all from " + QuickMerge.this.myBranchName + (reintegrate ? " (reintegrate)" : "");
            context.next(new TaskDescriptor[]{new MergeTask(mergerFactory, title)});
        }

        private MergerFactory createBranchMergerFactory(final boolean reintegrate, final SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData> invertor) {
            return new MergerFactory(){

                @Override
                public IMerger createMerger(SvnVcs vcs, File target, UpdateEventHandler handler, SVNURL currentBranchUrl, String branchName) {
                    return new BranchMerger(vcs, currentBranchUrl, QuickMerge.this.myWcInfo.getUrl(), QuickMerge.this.myWcInfo.getPath(), handler, reintegrate, QuickMerge.this.myBranchName, reintegrate ? ((SvnBranchPointsCalculator.BranchCopyData)invertor.getWrapped()).getTargetRevision() : ((SvnBranchPointsCalculator.BranchCopyData)invertor.getWrapped()).getSourceRevision());
                }

                @Override
                @Nullable
                public List<CommittedChangeList> getListsToMerge() {
                    return null;
                }

                @Override
                public boolean isMergeAll() {
                    return true;
                }
            };
        }
    }

    private class MergeAllOrSelectedChooser
    extends TaskDescriptor {
        private MergeAllOrSelectedChooser() {
            super("merge source selector", Where.AWT);
        }

        public void run(ContinuationContext context) {
            MergeCalculator calculator;
            QuickMergeContentsVariants variant = QuickMerge.this.myInteraction.selectMergeVariant();
            if (QuickMergeContentsVariants.cancel == variant) {
                return;
            }
            if (QuickMergeContentsVariants.all == variant) {
                QuickMerge.this.insertMergeAll(context);
                return;
            }
            if (QuickMergeContentsVariants.showLatest == variant) {
                LoadRecentBranchRevisions loader = new LoadRecentBranchRevisions(QuickMerge.this.myBranchName, -1L, QuickMerge.this.myWcInfo, QuickMerge.this.myVcs, QuickMerge.this.mySourceUrl);
                ShowRecentInDialog dialog = new ShowRecentInDialog(loader);
                context.next(new TaskDescriptor[]{loader, dialog});
                return;
            }
            try {
                calculator = new MergeCalculator(QuickMerge.this.myWcInfo, QuickMerge.this.mySourceUrl, QuickMerge.this.myBranchName);
            }
            catch (VcsException e) {
                QuickMerge.this.finishWithError(context, e.getMessage(), true);
                return;
            }
            context.next(new TaskDescriptor[]{QuickMerge.this.myVcs.getSvnBranchPointsCalculator().getFirstCopyPointTask(QuickMerge.this.myWcInfo.getRepositoryRoot(), QuickMerge.this.myWcInfo.getRootUrl(), QuickMerge.this.mySourceUrl, calculator), calculator});
        }
    }

    private class ShowRecentInDialog
    extends TaskDescriptor {
        private final LoadRecentBranchRevisions myLoader;

        private ShowRecentInDialog(LoadRecentBranchRevisions loader) {
            super("", Where.AWT);
            this.myLoader = loader;
        }

        public void run(ContinuationContext context) {
            PairConsumer<Long, MergeDialogI> loader = new PairConsumer<Long, MergeDialogI>(){

                public void consume(Long bunchSize, final MergeDialogI dialog) {
                    final LoadRecentBranchRevisions loader = new LoadRecentBranchRevisions(QuickMerge.this.myBranchName, dialog.getLastNumber(), QuickMerge.this.myWcInfo, QuickMerge.this.myVcs, QuickMerge.this.mySourceUrl, bunchSize.intValue());
                    TaskDescriptor updater = new TaskDescriptor("", Where.AWT){

                        public void run(ContinuationContext context) {
                            dialog.addMoreLists(loader.getCommittedChangeLists());
                            if (loader.isLastLoaded()) {
                                dialog.setEverythingLoaded(true);
                            }
                        }

                        public void canceled() {
                            dialog.addMoreLists(Collections.<CommittedChangeList>emptyList());
                            dialog.setEverythingLoaded(true);
                        }
                    };
                    Continuation fragmented = Continuation.createFragmented((Project)QuickMerge.this.myProject, (boolean)true);
                    fragmented.addExceptionHandler(VcsException.class, (Consumer)new Consumer<VcsException>(){

                        public void consume(VcsException e) {
                            PopupUtil.showBalloonForActiveComponent((String)(e.getMessage() == null ? ((Object)((Object)e)).getClass().getName() : e.getMessage()), (MessageType)MessageType.ERROR);
                        }
                    });
                    fragmented.run(new TaskDescriptor[]{loader, updater});
                }
            };
            final List<CommittedChangeList> lists = QuickMerge.this.myInteraction.showRecentListsForSelection(this.myLoader.getCommittedChangeLists(), QuickMerge.this.myTitle, this.myLoader.getHelper(), loader, this.myLoader.isLastLoaded());
            if (lists != null && !lists.isEmpty()) {
                ChangeListsMergerFactory factory = new ChangeListsMergerFactory(lists){

                    @Override
                    public IMerger createMerger(SvnVcs vcs, File target, UpdateEventHandler handler, SVNURL currentBranchUrl, String branchName) {
                        return new GroupMerger(vcs, lists, target, handler, currentBranchUrl, branchName, false, false, false);
                    }
                };
                SvnBranchPointsCalculator.BranchCopyData copyData = new SvnBranchPointsCalculator.BranchCopyData(QuickMerge.this.myWcInfo.getUrl().toString(), -1L, QuickMerge.this.mySourceUrl, -1L);
                context.next(new TaskDescriptor[]{new LocalChangesPrompt(false, lists, new SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData>(false, copyData)), new MergeTask(factory, QuickMerge.this.myTitle)});
            } else {
                context.cancelEverything();
            }
        }
    }

    private class CheckRepositorySupportsMergeinfo
    extends TaskDescriptor {
        private CheckRepositorySupportsMergeinfo() {
            super("Checking repository capabilities", Where.POOLED);
        }

        public void run(ContinuationContext context) {
            boolean supportsMergeinfo;
            LinkedList<MergeAllOrSelectedChooser> tasks = new LinkedList<MergeAllOrSelectedChooser>();
            boolean bl = supportsMergeinfo = QuickMerge.this.myWcInfo.getFormat().supportsMergeInfo() && SvnUtil.checkRepositoryVersion15(QuickMerge.this.myVcs, QuickMerge.this.mySourceUrl);
            if (!supportsMergeinfo) {
                QuickMerge.this.insertMergeAll(tasks);
            } else {
                tasks.add(new MergeAllOrSelectedChooser());
            }
            context.next(tasks);
        }
    }

    private class MyInitChecks
    extends TaskDescriptor {
        private MyInitChecks() {
            super("initial checks", Where.AWT);
        }

        public void run(ContinuationContext continuationContext) {
            SVNURL url = this.parseUrl(continuationContext);
            if (url == null) {
                return;
            }
            if (SVNURLUtil.isAncestor((SVNURL)url, (SVNURL)QuickMerge.this.myWcInfo.getUrl()) || SVNURLUtil.isAncestor((SVNURL)QuickMerge.this.myWcInfo.getUrl(), (SVNURL)url)) {
                QuickMerge.this.finishWithError(continuationContext, "Cannot merge from self", true);
                return;
            }
            if (!QuickMerge.this.checkForSwitchedRoots()) {
                continuationContext.cancelEverything();
            }
        }

        @Nullable
        private SVNURL parseUrl(ContinuationContext continuationContext) {
            SVNURL url = null;
            try {
                url = SvnUtil.createUrl(QuickMerge.this.mySourceUrl);
            }
            catch (SvnBindException e) {
                QuickMerge.this.finishWithError(continuationContext, e.getMessage(), true);
            }
            return url;
        }
    }

    private class SourceUrlCorrection
    extends TaskDescriptor {
        private SourceUrlCorrection() {
            super("Checking branch", Where.POOLED);
        }

        public void run(ContinuationContext continuationContext) {
            String branchString;
            SVNURL branch = SvnBranchConfigurationManager.getInstance(QuickMerge.this.myProject).getSvnBranchConfigManager().getWorkingBranchWithReload(QuickMerge.this.myWcInfo.getUrl(), QuickMerge.this.myRoot);
            if (branch != null && !QuickMerge.this.myWcInfo.getUrl().equals((Object)branch) && SVNPathUtil.isAncestor((String)(branchString = branch.toString()), (String)QuickMerge.this.myWcInfo.getRootUrl())) {
                String subPath = SVNPathUtil.getRelativePath((String)branchString, (String)QuickMerge.this.myWcInfo.getRootUrl());
                QuickMerge.this.mySourceUrl = SVNPathUtil.append((String)QuickMerge.this.mySourceUrl, (String)subPath);
            }
        }
    }
}

